/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetricsMasterWrapperImpl;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterMetricsWrapper {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterMetricsWrapper.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterMetricsWrapper.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final int NUM_RS = 4;

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL.startMiniCluster(4);
    }

    @AfterClass
    public static void teardown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testInfo() throws IOException {
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        MetricsMasterWrapperImpl info = new MetricsMasterWrapperImpl(master);
        Assert.assertEquals((float)master.getRegionNormalizerManager().getSplitPlanCount(), (float)info.getSplitPlanCount(), (float)0.0f);
        Assert.assertEquals((float)master.getRegionNormalizerManager().getMergePlanCount(), (float)info.getMergePlanCount(), (float)0.0f);
        Assert.assertEquals((double)master.getAverageLoad(), (double)info.getAverageLoad(), (double)0.0);
        Assert.assertEquals((Object)master.getClusterId(), (Object)info.getClusterId());
        Assert.assertEquals((long)master.getMasterActiveTime(), (long)info.getActiveTime());
        Assert.assertEquals((long)master.getMasterStartTime(), (long)info.getStartTime());
        Assert.assertEquals((long)master.getMasterCoprocessors().length, (long)info.getCoprocessors().length);
        Assert.assertEquals((long)master.getServerManager().getOnlineServersList().size(), (long)info.getNumRegionServers());
        Assert.assertEquals((long)master.getMasterWalManager().getOldWALsDirSize(), (long)info.getOldWALsDirSize());
        int regionServerCount = 4;
        Assert.assertEquals((long)regionServerCount, (long)info.getNumRegionServers());
        String zkServers = info.getZookeeperQuorum();
        Assert.assertEquals((long)zkServers.split(",").length, (long)TEST_UTIL.getZkCluster().getZooKeeperServerNum());
        int index = 3;
        LOG.info("Stopping " + TEST_UTIL.getMiniHBaseCluster().getRegionServer(3));
        TEST_UTIL.getMiniHBaseCluster().stopRegionServer(3, false);
        TEST_UTIL.getMiniHBaseCluster().waitOnRegionServer(3);
        while (TEST_UTIL.getHBaseCluster().getMaster().getServerManager().getOnlineServers().size() == regionServerCount) {
            Threads.sleep((long)10L);
        }
        Assert.assertEquals((long)(regionServerCount - 1), (long)info.getNumRegionServers());
        Assert.assertEquals((long)1L, (long)info.getNumDeadRegionServers());
        Assert.assertEquals((long)0L, (long)info.getNumWALFiles());
        TEST_UTIL.getMiniHBaseCluster().getMaster().decommissionRegionServers(master.getServerManager().getOnlineServersList().subList(0, 1), false);
        Assert.assertEquals((long)1L, (long)info.getNumDrainingRegionServers());
        Assert.assertEquals((Object)((ServerName)master.getServerManager().getOnlineServersList().get(0)).toString(), (Object)info.getDrainingRegionServers());
    }

    @Test
    public void testQuotaSnapshotConversion() {
        MetricsMasterWrapperImpl info = new MetricsMasterWrapperImpl(TEST_UTIL.getHBaseCluster().getMaster());
        Assert.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(1024L, 2048L), (Object)info.convertSnapshot(new SpaceQuotaSnapshot(SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation(), 1024L, 2048L)));
        Assert.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(4096L, 2048L), (Object)info.convertSnapshot(new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_INSERTS), 4096L, 2048L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOfflineRegion() throws Exception {
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        MetricsMasterWrapperImpl info = new MetricsMasterWrapperImpl(master);
        TableName table = TableName.valueOf((String)"testRegionNumber");
        try {
            List regions;
            byte[] FAMILY = Bytes.toBytes((String)"FAMILY");
            TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)table).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
            TEST_UTIL.getAdmin().createTable(tableDescriptor, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"), 5);
            long timeoutTime = EnvironmentEdgeManager.currentTime() + 1000L;
            while (true) {
                if ((regions = master.getAssignmentManager().getRegionStates().getRegionsOfTable(table)).size() > 3) break;
                long now = EnvironmentEdgeManager.currentTime();
                if (now > timeoutTime) {
                    Assert.fail((String)"Could not find an online region");
                }
                Thread.sleep(10L);
            }
            RegionInfo hri = (RegionInfo)regions.get(2);
            PairOfSameType regionNumberPair = info.getRegionCounts();
            Assert.assertEquals((long)5L, (long)((Integer)regionNumberPair.getFirst()).intValue());
            Assert.assertEquals((long)0L, (long)((Integer)regionNumberPair.getSecond()).intValue());
            TEST_UTIL.getAdmin().offline(hri.getRegionName());
            timeoutTime = EnvironmentEdgeManager.currentTime() + 800L;
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            while (!((List)regionStates.getRegionByStateOfTable(table).get(RegionState.State.OFFLINE)).contains(hri)) {
                long now = EnvironmentEdgeManager.currentTime();
                if (now > timeoutTime) {
                    Assert.fail((String)"Failed to offline the region in time");
                    break;
                }
                Thread.sleep(10L);
            }
            regionNumberPair = info.getRegionCounts();
            Assert.assertEquals((long)4L, (long)((Integer)regionNumberPair.getFirst()).intValue());
            Assert.assertEquals((long)1L, (long)((Integer)regionNumberPair.getSecond()).intValue());
        }
        finally {
            TEST_UTIL.deleteTable(table);
        }
    }
}

