/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineNamespaceProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMigrateNamespaceTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMigrateNamespaceTable.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setUp() throws Exception {
        StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(1).numAlwaysStandByMasters(1).numRegionServers(1).build();
        UTIL.startMiniCluster(option);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMigrate() throws IOException, InterruptedException {
        UTIL.getAdmin().createTable(TableDescriptorBuilder.NAMESPACE_TABLEDESC);
        try (Table table = UTIL.getConnection().getTable(TableName.NAMESPACE_TABLE_NAME);){
            for (int i = 0; i < 5; ++i) {
                NamespaceDescriptor nd = NamespaceDescriptor.create((String)("Test-NS-" + i)).addConfiguration("key-" + i, "value-" + i).build();
                table.put(new Put(Bytes.toBytes((String)nd.getName())).addColumn(TableDescriptorBuilder.NAMESPACE_FAMILY_INFO_BYTES, TableDescriptorBuilder.NAMESPACE_COL_DESC_BYTES, ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)nd).toByteArray()));
                AbstractStateMachineNamespaceProcedure.createDirectory((MasterFileSystem)UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem(), (NamespaceDescriptor)nd);
            }
        }
        JVMClusterUtil.MasterThread masterThread = UTIL.getMiniHBaseCluster().getMasterThread();
        masterThread.getMaster().stop("For testing");
        masterThread.join();
        UTIL.getMiniHBaseCluster().startMaster();
        Assert.assertEquals((long)7L, (long)UTIL.getAdmin().listNamespaceDescriptors().length);
        for (int i = 0; i < 5; ++i) {
            NamespaceDescriptor nd = UTIL.getAdmin().getNamespaceDescriptor("Test-NS-" + i);
            Assert.assertEquals((Object)("Test-NS-" + i), (Object)nd.getName());
            Assert.assertEquals((long)1L, (long)nd.getConfiguration().size());
            Assert.assertEquals((Object)("value-" + i), (Object)nd.getConfigurationValue("key-" + i));
        }
        UTIL.waitFor(30000L, () -> UTIL.getAdmin().isTableDisabled(TableName.NAMESPACE_TABLE_NAME));
        masterThread = UTIL.getMiniHBaseCluster().getMasterThread();
        masterThread.getMaster().stop("For testing");
        masterThread.join();
        UTIL.getMiniHBaseCluster().startMaster();
        Assert.assertEquals((long)7L, (long)UTIL.getAdmin().listNamespaceDescriptors().length);
        UTIL.getAdmin().deleteTable(TableName.NAMESPACE_TABLE_NAME);
        Assert.assertFalse((boolean)UTIL.getAdmin().tableExists(TableName.NAMESPACE_TABLE_NAME));
    }
}

