/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestExceptionInAssignRegion {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExceptionInAssignRegion.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final CountDownLatch countDownLatch = new CountDownLatch(2);
    private static final byte[] CF = Bytes.toBytes((String)"cf");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setStrings("hbase.coprocessor.region.classes", new String[]{ThrowInOpenCP.class.getName()});
        UTIL.startMiniCluster(3);
        UTIL.getAdmin().balancerSwitch(false, true);
        UTIL.createTable(TABLE_NAME, CF);
        UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testExceptionInAssignRegion() {
        ProcedureExecutor procedureExecutor = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        JVMClusterUtil.RegionServerThread rsThread = null;
        for (JVMClusterUtil.RegionServerThread t : UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            if (t.getRegionServer().getRegions(TABLE_NAME).isEmpty()) continue;
            rsThread = t;
            break;
        }
        HRegionServer rs = rsThread.getRegionServer();
        RegionInfo hri = ((HRegion)rs.getRegions(TABLE_NAME).get(0)).getRegionInfo();
        TransitRegionStateProcedure assignRegionProcedure = TransitRegionStateProcedure.move((MasterProcedureEnv)((MasterProcedureEnv)UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment()), (RegionInfo)hri, null);
        RegionStateNode regionNode = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(hri);
        regionNode.setProcedure(assignRegionProcedure);
        countDownLatch.countDown();
        long prodId = procedureExecutor.submitProcedure((Procedure)assignRegionProcedure);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procedureExecutor, (long)prodId);
        Assert.assertEquals((String)"Should be two RS since other is aborted", (long)2L, (long)UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size());
        Assert.assertNull((String)"RIT Map doesn't have correct value", this.getRegionServer(0).getRegionsInTransitionInRS().get(hri.getEncodedNameAsBytes()));
        Assert.assertNull((String)"RIT Map doesn't have correct value", this.getRegionServer(1).getRegionsInTransitionInRS().get(hri.getEncodedNameAsBytes()));
        Assert.assertNull((String)"RIT Map doesn't have correct value", this.getRegionServer(2).getRegionsInTransitionInRS().get(hri.getEncodedNameAsBytes()));
    }

    private HRegionServer getRegionServer(int index) {
        return UTIL.getMiniHBaseCluster().getRegionServer(index);
    }

    public static class ThrowInOpenCP
    implements RegionCoprocessor,
    RegionObserver {
        public void preOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
            if (countDownLatch.getCount() == 1L) {
                countDownLatch.countDown();
                throw new RuntimeException();
            }
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }
    }
}

