/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ProcedureTestUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.OpenRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestOpenRegionProcedureBackoff {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOpenRegionProcedureBackoff.class);
    private static volatile boolean FAIL = false;
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static TableName NAME = TableName.valueOf((String)"Open");
    private static byte[] CF = Bytes.toBytes((String)"cf");

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        UTIL.startMiniCluster(1);
        UTIL.waitTableAvailable(TableName.META_TABLE_NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private void assertBackoffIncrease() throws IOException, InterruptedException {
        ProcedureTestUtil.waitUntilProcedureWaitingTimeout(UTIL, OpenRegionProcedure.class, 30000L);
        ProcedureTestUtil.waitUntilProcedureTimeoutIncrease(UTIL, OpenRegionProcedure.class, 2);
    }

    @Test
    public void testBackoff() throws IOException, InterruptedException, ExecutionException {
        FAIL = true;
        AsyncAdmin admin = UTIL.getAsyncConnection().getAdminBuilder().setRpcTimeout(5L, TimeUnit.MINUTES).setOperationTimeout(10L, TimeUnit.MINUTES).build();
        CompletableFuture future = admin.createTable(TableDescriptorBuilder.newBuilder((TableName)NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF)).build());
        this.assertBackoffIncrease();
        FAIL = false;
        future.get();
        UTIL.waitTableAvailable(NAME);
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master, MasterRegion masterRegion) {
            return new AssignmentManagerForTest(master, masterRegion);
        }
    }

    private static final class AssignmentManagerForTest
    extends AssignmentManager {
        public AssignmentManagerForTest(MasterServices master, MasterRegion masterRegion) {
            super(master, masterRegion);
        }

        CompletableFuture<Void> persistToMeta(RegionStateNode regionNode) {
            if (FAIL) {
                return FutureUtils.failedFuture((Throwable)new IOException("Inject Error!"));
            }
            return super.persistToMeta(regionNode);
        }
    }
}

