/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRegionStates {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionStates.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionStates.class);
    protected static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static ThreadPoolExecutor threadPool;
    private static ExecutorCompletionService<Object> executorService;

    @BeforeClass
    public static void setUp() throws Exception {
        threadPool = Threads.getBoundedCachedThreadPool((int)32, (long)60L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)new ThreadFactoryBuilder().setNameFormat("ProcedureDispatcher-pool-%d").setDaemon(true).setUncaughtExceptionHandler((t, e) -> LOG.warn("Failed thread " + t.getName(), e)).build());
        executorService = new ExecutorCompletionService(threadPool);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        threadPool.shutdown();
    }

    @Before
    public void testSetup() {
    }

    @After
    public void testTearDown() throws Exception {
        Future<Object> f;
        while ((f = executorService.poll()) != null) {
            f.get();
        }
    }

    private static void waitExecutorService(int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            executorService.take().get();
        }
    }

    @Test
    public void testRegionDoubleCreation() throws Exception {
        int i;
        TableName TABLE_NAME_A = TableName.valueOf((String)"testOrderedByTableA");
        TableName TABLE_NAME_B = TableName.valueOf((String)"testOrderedByTableB");
        TableName TABLE_NAME_C = TableName.valueOf((String)"testOrderedByTableC");
        RegionStates stateMap = new RegionStates();
        int NRUNS = 1000;
        int NSMALL_RUNS = 3;
        for (i = 0; i < 1000; ++i) {
            this.addRegionNode(stateMap, TABLE_NAME_B, i);
        }
        for (i = 0; i < 1000; ++i) {
            this.addRegionNode(stateMap, TABLE_NAME_B, i);
        }
        TestRegionStates.waitExecutorService(2000);
        for (i = 0; i < 3; ++i) {
            this.addRegionNode(stateMap, TABLE_NAME_A, i);
            this.addRegionNode(stateMap, TABLE_NAME_C, i);
        }
        TestRegionStates.waitExecutorService(6);
        this.checkTableRegions(stateMap, TABLE_NAME_A, 3);
        this.checkTableRegions(stateMap, TABLE_NAME_B, 1000);
        this.checkTableRegions(stateMap, TABLE_NAME_C, 3);
    }

    private void checkTableRegions(RegionStates stateMap, TableName tableName, int nregions) {
        List rns = stateMap.getTableRegionStateNodes(tableName);
        Assert.assertEquals((long)nregions, (long)rns.size());
        for (int i = 1; i < rns.size(); ++i) {
            long a = Bytes.toLong((byte[])((RegionStateNode)rns.get(i - 1)).getRegionInfo().getStartKey());
            long b = Bytes.toLong((byte[])((RegionStateNode)rns.get(i + 0)).getRegionInfo().getStartKey());
            Assert.assertEquals((long)b, (long)(a + 1L));
        }
    }

    private void addRegionNode(final RegionStates stateMap, final TableName tableName, final long regionId) {
        executorService.submit(new Callable<Object>(){

            @Override
            public Object call() {
                return stateMap.getOrCreateRegionStateNode(RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((long)regionId)).setEndKey(Bytes.toBytes((long)(regionId + 1L))).setSplit(false).setRegionId(0L).build());
            }
        });
    }

    private RegionInfo createRegionInfo(TableName tableName, long regionId) {
        return RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((long)regionId)).setEndKey(Bytes.toBytes((long)(regionId + 1L))).setSplit(false).setRegionId(0L).build();
    }

    @Test
    public void testPerf() throws Exception {
        final TableName TABLE_NAME = TableName.valueOf((String)"testPerf");
        int NRUNS = 1000000;
        final RegionStates stateMap = new RegionStates();
        long st = EnvironmentEdgeManager.currentTime();
        int i = 0;
        while (i < 1000000) {
            final int regionId = i++;
            executorService.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    RegionInfo hri = TestRegionStates.this.createRegionInfo(TABLE_NAME, regionId);
                    return stateMap.getOrCreateRegionStateNode(hri);
                }
            });
        }
        TestRegionStates.waitExecutorService(1000000);
        long et = EnvironmentEdgeManager.currentTime();
        LOG.info(String.format("PERF STATEMAP INSERT: %s %s/sec", StringUtils.humanTimeDiff((long)(et - st)), StringUtils.humanSize((double)(1000000.0f / ((float)(et - st) / 1000.0f)))));
        st = EnvironmentEdgeManager.currentTime();
        int i2 = 0;
        while (i2 < 1000000) {
            final int regionId = i2++;
            executorService.submit(new Callable<Object>(){

                @Override
                public Object call() {
                    RegionInfo hri = TestRegionStates.this.createRegionInfo(TABLE_NAME, regionId);
                    return stateMap.getRegionState(hri);
                }
            });
        }
        TestRegionStates.waitExecutorService(1000000);
        et = EnvironmentEdgeManager.currentTime();
        LOG.info(String.format("PERF STATEMAP GET: %s %s/sec", StringUtils.humanTimeDiff((long)(et - st)), StringUtils.humanSize((double)(1000000.0f / ((float)(et - st) / 1000.0f)))));
    }

    @Test
    public void testPerfSingleThread() {
        TableName TABLE_NAME = TableName.valueOf((String)"testPerf");
        int NRUNS = 1000000;
        RegionStates stateMap = new RegionStates();
        long st = EnvironmentEdgeManager.currentTime();
        for (int i = 0; i < 1000000; ++i) {
            stateMap.createRegionStateNode(this.createRegionInfo(TABLE_NAME, i));
        }
        long et = EnvironmentEdgeManager.currentTime();
        LOG.info(String.format("PERF SingleThread: %s %s/sec", StringUtils.humanTimeDiff((long)(et - st)), StringUtils.humanSize((double)(1000000.0f / ((float)(et - st) / 1000.0f)))));
    }
}

