/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.master.balancer.HeterogeneousRegionCountCostFunction;
import org.apache.hadoop.hbase.master.balancer.StochasticBalancerTestBase;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestStochasticLoadBalancerHeterogeneousCostRulesLoadFromHDFS
extends StochasticBalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancerHeterogeneousCostRulesLoadFromHDFS.class);
    private HeterogeneousRegionCountCostFunction costFunction;
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();

    @Before
    public void setUp() throws Exception {
        HTU.startMiniCluster(1);
    }

    @After
    public void tearDown() throws IOException {
        HTU.shutdownMiniCluster();
    }

    @Test
    public void testLoadingFomHDFS() throws Exception {
        MiniDFSCluster cluster = HTU.getDFSCluster();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path(fs.getHomeDirectory(), "hbase-balancer.rules");
        FSDataOutputStream stream = fs.create(path);
        stream.write("server1 10".getBytes());
        stream.flush();
        stream.close();
        Configuration configuration = HTU.getConfiguration();
        configuration.set("hbase.master.balancer.heterogeneousRegionCountRulesFile", path.toString());
        this.costFunction = new HeterogeneousRegionCountCostFunction(configuration);
        this.costFunction.loadRules();
        Assert.assertEquals((long)1L, (long)this.costFunction.getNumberOfRulesLoaded());
    }
}

