/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.cleaner.SnapshotCleanerChore;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestSnapshotCleanerChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotCleanerChore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotCleanerChore.class);
    private static final HBaseTestingUtil HBASE_TESTING_UTILITY = new HBaseTestingUtil();
    private SnapshotManager snapshotManager;

    private Configuration getSnapshotCleanerConf() {
        Configuration conf = HBASE_TESTING_UTILITY.getConfiguration();
        conf.setInt("hbase.master.cleaner.snapshot.interval", 100);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotCleanerWithoutAnyCompletedSnapshot() throws IOException {
        this.snapshotManager = (SnapshotManager)Mockito.mock(SnapshotManager.class);
        StoppableImplementation stopper = new StoppableImplementation();
        Configuration conf = this.getSnapshotCleanerConf();
        SnapshotCleanerChore snapshotCleanerChore = new SnapshotCleanerChore((Stoppable)stopper, conf, this.snapshotManager);
        try {
            snapshotCleanerChore.chore();
        }
        finally {
            stopper.stop("Stopping Test Stopper");
        }
        ((SnapshotManager)Mockito.verify((Object)this.snapshotManager, (VerificationMode)Mockito.times((int)0))).deleteSnapshot((SnapshotProtos.SnapshotDescription)Mockito.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotCleanerWithNoTtlExpired() throws IOException {
        this.snapshotManager = (SnapshotManager)Mockito.mock(SnapshotManager.class);
        StoppableImplementation stopper = new StoppableImplementation();
        Configuration conf = this.getSnapshotCleanerConf();
        SnapshotCleanerChore snapshotCleanerChore = new SnapshotCleanerChore((Stoppable)stopper, conf, this.snapshotManager);
        ArrayList<SnapshotProtos.SnapshotDescription> snapshotDescriptionList = new ArrayList<SnapshotProtos.SnapshotDescription>();
        snapshotDescriptionList.add(this.getSnapshotDescription(-2L, "snapshot01", "table01", EnvironmentEdgeManager.currentTime() - 100000L));
        snapshotDescriptionList.add(this.getSnapshotDescription(10L, "snapshot02", "table02", EnvironmentEdgeManager.currentTime()));
        Mockito.when((Object)this.snapshotManager.getCompletedSnapshots()).thenReturn(snapshotDescriptionList);
        try {
            LOG.info("2 Snapshots are completed but TTL is not expired for any of them");
            snapshotCleanerChore.chore();
        }
        finally {
            stopper.stop("Stopping Test Stopper");
        }
        ((SnapshotManager)Mockito.verify((Object)this.snapshotManager, (VerificationMode)Mockito.times((int)0))).deleteSnapshot((SnapshotProtos.SnapshotDescription)Mockito.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotCleanerWithSomeTtlExpired() throws IOException {
        this.snapshotManager = (SnapshotManager)Mockito.mock(SnapshotManager.class);
        StoppableImplementation stopper = new StoppableImplementation();
        Configuration conf = this.getSnapshotCleanerConf();
        SnapshotCleanerChore snapshotCleanerChore = new SnapshotCleanerChore((Stoppable)stopper, conf, this.snapshotManager);
        ArrayList<SnapshotProtos.SnapshotDescription> snapshotDescriptionList = new ArrayList<SnapshotProtos.SnapshotDescription>();
        snapshotDescriptionList.add(this.getSnapshotDescription(10L, "snapshot01", "table01", 1L));
        snapshotDescriptionList.add(this.getSnapshotDescription(5L, "snapshot02", "table02", 2L));
        snapshotDescriptionList.add(this.getSnapshotDescription(30L, "snapshot01", "table01", EnvironmentEdgeManager.currentTime()));
        snapshotDescriptionList.add(this.getSnapshotDescription(0L, "snapshot02", "table02", EnvironmentEdgeManager.currentTime()));
        snapshotDescriptionList.add(this.getSnapshotDescription(40L, "snapshot03", "table03", EnvironmentEdgeManager.currentTime()));
        Mockito.when((Object)this.snapshotManager.getCompletedSnapshots()).thenReturn(snapshotDescriptionList);
        try {
            LOG.info("5 Snapshots are completed. TTL is expired for 2 them. Going to delete them");
            snapshotCleanerChore.chore();
        }
        finally {
            stopper.stop("Stopping Test Stopper");
        }
        ((SnapshotManager)Mockito.verify((Object)this.snapshotManager, (VerificationMode)Mockito.times((int)2))).deleteSnapshot((SnapshotProtos.SnapshotDescription)Mockito.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotCleanerWithReadIOE() throws IOException {
        this.snapshotManager = (SnapshotManager)Mockito.mock(SnapshotManager.class);
        StoppableImplementation stopper = new StoppableImplementation();
        Configuration conf = new HBaseTestingUtil().getConfiguration();
        SnapshotCleanerChore snapshotCleanerChore = new SnapshotCleanerChore((Stoppable)stopper, conf, this.snapshotManager);
        Mockito.when((Object)this.snapshotManager.getCompletedSnapshots()).thenThrow(IOException.class);
        try {
            LOG.info("While getting completed Snapshots, IOException would occur. Hence, No Snapshot should be deleted");
            snapshotCleanerChore.chore();
        }
        finally {
            stopper.stop("Stopping Test Stopper");
        }
        ((SnapshotManager)Mockito.verify((Object)this.snapshotManager, (VerificationMode)Mockito.times((int)0))).deleteSnapshot((SnapshotProtos.SnapshotDescription)Mockito.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotChoreWithTtlOutOfRange() throws IOException {
        this.snapshotManager = (SnapshotManager)Mockito.mock(SnapshotManager.class);
        StoppableImplementation stopper = new StoppableImplementation();
        Configuration conf = this.getSnapshotCleanerConf();
        ArrayList<SnapshotProtos.SnapshotDescription> snapshotDescriptionList = new ArrayList<SnapshotProtos.SnapshotDescription>();
        snapshotDescriptionList.add(this.getSnapshotDescription(Long.MAX_VALUE, "snapshot01", "table01", 1L));
        snapshotDescriptionList.add(this.getSnapshotDescription(5L, "snapshot02", "table02", 2L));
        Mockito.when((Object)this.snapshotManager.getCompletedSnapshots()).thenReturn(snapshotDescriptionList);
        SnapshotCleanerChore snapshotCleanerChore = new SnapshotCleanerChore((Stoppable)stopper, conf, this.snapshotManager);
        try {
            LOG.info("Snapshot Chore is disabled. No cleanup performed for Expired Snapshots");
            snapshotCleanerChore.chore();
        }
        finally {
            stopper.stop("Stopping Test Stopper");
        }
        ((SnapshotManager)Mockito.verify((Object)this.snapshotManager, (VerificationMode)Mockito.times((int)1))).getCompletedSnapshots();
    }

    private SnapshotProtos.SnapshotDescription getSnapshotDescription(long ttl, String snapshotName, String tableName, long snapshotCreationTime) {
        SnapshotProtos.SnapshotDescription.Builder snapshotDescriptionBuilder = SnapshotProtos.SnapshotDescription.newBuilder();
        snapshotDescriptionBuilder.setTtl(ttl);
        snapshotDescriptionBuilder.setName(snapshotName);
        snapshotDescriptionBuilder.setTable(tableName);
        snapshotDescriptionBuilder.setType(SnapshotProtos.SnapshotDescription.Type.FLUSH);
        snapshotDescriptionBuilder.setCreationTime(snapshotCreationTime);
        return snapshotDescriptionBuilder.build();
    }

    private static class StoppableImplementation
    implements Stoppable {
        private volatile boolean stop = false;

        private StoppableImplementation() {
        }

        public void stop(String why) {
            this.stop = true;
        }

        public boolean isStopped() {
            return this.stop;
        }
    }
}

