/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.janitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaMockingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.GCRegionProcedure;
import org.apache.hadoop.hbase.master.janitor.CatalogJanitor;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCatalogJanitorInMemoryStates {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCatalogJanitorInMemoryStates.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCatalogJanitorInMemoryStates.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    @Rule
    public final TableNameTestRule name = new TableNameTestRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testInMemoryParentCleanup() throws IOException, InterruptedException, ExecutionException {
        final HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        AssignmentManager am = master.getAssignmentManager();
        ServerManager sm = master.getServerManager();
        Admin admin = TEST_UTIL.getAdmin();
        admin.catalogJanitorSwitch(false);
        TableName tableName = this.name.getTableName();
        Table t = TEST_UTIL.createTable(tableName, FAMILY);
        TEST_UTIL.loadTable(t, FAMILY, false);
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
        List allRegionLocations = locator.getAllRegionLocations();
        HRegionLocation parent = (HRegionLocation)allRegionLocations.get(0);
        List<HRegionLocation> daughters = this.splitRegion(parent.getRegion());
        LOG.info("Parent region: " + parent);
        LOG.info("Daughter regions: " + daughters);
        Assert.assertNotNull((String)("Should have found daughter regions for " + parent), daughters);
        Assert.assertTrue((String)"Parent region should exist in RegionStates", (boolean)am.getRegionStates().isRegionInRegionStates(parent.getRegion()));
        Assert.assertTrue((String)"Parent region should exist in ServerManager", (boolean)sm.isRegionInServerManagerStates(parent.getRegion()));
        Result r = MetaMockingUtil.getMetaTableRowResult(parent.getRegion(), null, daughters.get(0).getRegion(), daughters.get(1).getRegion());
        CatalogJanitor.cleanParent((MasterServices)master, (RegionInfo)parent.getRegion(), (Result)r);
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ProcedureExecutor pe = master.getMasterProcedureExecutor();
                for (Procedure proc : pe.getProcedures()) {
                    if (!proc.getClass().isAssignableFrom(GCRegionProcedure.class) || !proc.isFinished()) continue;
                    return true;
                }
                return false;
            }
        });
        Assert.assertFalse((String)"Parent region should have been removed from RegionStates", (boolean)am.getRegionStates().isRegionInRegionStates(parent.getRegion()));
        Assert.assertFalse((String)"Parent region should have been removed from ServerManager", (boolean)sm.isRegionInServerManagerStates(parent.getRegion()));
    }

    private List<HRegionLocation> splitRegion(RegionInfo r) throws IOException, InterruptedException, ExecutionException {
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
        Admin admin = TEST_UTIL.getAdmin();
        Connection connection = TEST_UTIL.getConnection();
        admin.splitRegionAsync(r.getEncodedNameAsBytes()).get();
        admin.close();
        PairOfSameType<RegionInfo> regions = this.waitOnDaughters(r);
        if (regions != null) {
            try (RegionLocator rl = connection.getRegionLocator(r.getTable());){
                locations.add(rl.getRegionLocation(((RegionInfo)regions.getFirst()).getEncodedNameAsBytes()));
                locations.add(rl.getRegionLocation(((RegionInfo)regions.getSecond()).getEncodedNameAsBytes()));
            }
            return locations;
        }
        return locations;
    }

    /*
     * Exception decompiling
     */
    private PairOfSameType<RegionInfo> waitOnDaughters(RegionInfo r) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

