/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.master.procedure.CreateNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestDeleteNamespaceProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDeleteNamespaceProcedure.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestDeleteNamespaceProcedure.class);
    protected static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestDeleteNamespaceProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (TableDescriptor htd : UTIL.getAdmin().listTableDescriptors()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testDeleteNamespace() throws Exception {
        String namespaceName = "testDeleteNamespace";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting("testDeleteNamespace");
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), "testDeleteNamespace"));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        TestDeleteNamespaceProcedure.validateNamespaceNotExist("testDeleteNamespace");
    }

    @Test
    public void testDeleteNonExistNamespace() throws Exception {
        String namespaceName = "testDeleteNonExistNamespace";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        TestDeleteNamespaceProcedure.validateNamespaceNotExist("testDeleteNonExistNamespace");
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), "testDeleteNonExistNamespace"));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug("Delete namespace failed with exception: " + result.getException());
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof NamespaceNotFoundException));
    }

    @Test
    public void testDeleteSystemNamespace() throws Exception {
        String namespaceName = NamespaceDescriptor.SYSTEM_NAMESPACE.getName();
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), namespaceName));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug("Delete namespace failed with exception: " + result.getException());
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof ConstraintException));
    }

    @Test
    public void testDeleteNonEmptyNamespace() throws Exception {
        String namespaceName = "testDeleteNonExistNamespace";
        TableName tableName = TableName.valueOf((String)("testDeleteNonExistNamespace:" + this.name.getMethodName()));
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting("testDeleteNonExistNamespace");
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1");
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), "testDeleteNonExistNamespace"));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Procedure result = procExec.getResult(procId);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug("Delete namespace failed with exception: " + result.getException());
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof ConstraintException));
    }

    @Test
    public void testRecoveryAndDoubleExecution() throws Exception {
        String namespaceName = "testRecoveryAndDoubleExecution";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting("testRecoveryAndDoubleExecution");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), "testRecoveryAndDoubleExecution"));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        TestDeleteNamespaceProcedure.validateNamespaceNotExist("testRecoveryAndDoubleExecution");
    }

    @Test
    public void testRollbackAndDoubleExecution() throws Exception {
        String namespaceName = "testRollbackAndDoubleExecution";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        this.createNamespaceForTesting("testRollbackAndDoubleExecution");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DeleteNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), "testRollbackAndDoubleExecution"));
        int lastStep = 2;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, lastStep);
        NamespaceDescriptor createdNsDescriptor = UTIL.getAdmin().getNamespaceDescriptor("testRollbackAndDoubleExecution");
        Assert.assertNotNull((Object)createdNsDescriptor);
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    private void createNamespaceForTesting(String namespaceName) throws Exception {
        NamespaceDescriptor nsd = NamespaceDescriptor.create((String)namespaceName).build();
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)new CreateNamespaceProcedure((MasterProcedureEnv)procExec.getEnvironment(), nsd));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    public static void validateNamespaceNotExist(String nsName) throws IOException {
        try {
            NamespaceDescriptor nsDescriptor = UTIL.getAdmin().getNamespaceDescriptor(nsName);
            Assert.assertNull((Object)nsDescriptor);
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
    }
}

