/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.procedure.FlushRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.FlushTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TestFlushTableProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestFlushTableProcedureMasterRestarts
extends TestFlushTableProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFlushTableProcedureMasterRestarts.class);

    @Test
    public void testMasterRestarts() throws IOException {
        this.assertTableMemStoreNotEmpty();
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        ProcedureExecutor procExec = master.getMasterProcedureExecutor();
        MasterProcedureEnv env = (MasterProcedureEnv)procExec.getEnvironment();
        FlushTableProcedure proc = new FlushTableProcedure(env, this.TABLE_NAME);
        long procId = procExec.submitProcedure((Procedure)proc);
        TEST_UTIL.waitFor(5000L, 1000L, () -> proc.getState().getNumber() > 1);
        TEST_UTIL.getHBaseCluster().killMaster(master.getServerName());
        TEST_UTIL.getHBaseCluster().waitForMasterToStop(master.getServerName(), 30000L);
        TEST_UTIL.getHBaseCluster().startMaster();
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        master = TEST_UTIL.getHBaseCluster().getMaster();
        procExec = master.getMasterProcedureExecutor();
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        this.assertTableMemStoreEmpty();
    }

    @Test
    public void testSkipRIT() throws IOException {
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(this.TABLE_NAME).get(0);
        TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionStateNode(region.getRegionInfo()).setState(RegionState.State.CLOSING, new RegionState.State[]{RegionState.State.OPEN});
        FlushRegionProcedure proc = new FlushRegionProcedure(region.getRegionInfo());
        TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor().submitProcedure((Procedure)proc);
        TEST_UTIL.waitFor(5000L, () -> proc.isFinished());
    }
}

