/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterObserverPostCalls {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterObserverPostCalls.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterObserverPostCalls.class);
    protected static final HBaseTestingUtil UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestMasterObserverPostCalls.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.set("hbase.coprocessor.master.classes", MasterObserverForTest.class.getName());
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void testPostDeleteNamespace() throws IOException {
        Admin admin = UTIL.getAdmin();
        String ns = "postdeletens";
        TableName tn1 = TableName.valueOf((String)"postdeletens", (String)"table1");
        admin.createNamespace(NamespaceDescriptor.create((String)"postdeletens").build());
        admin.createTable(TableDescriptorBuilder.newBuilder((TableName)tn1).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f1")).build()).build());
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterObserverForTest observer = (MasterObserverForTest)master.getMasterCoprocessorHost().findCoprocessor(MasterObserverForTest.class);
        int preCount = observer.postHookCalls.get();
        try {
            admin.deleteNamespace("postdeletens");
            Assert.fail((String)"Deleting a non-empty namespace should be disallowed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected no invocations of postDeleteNamespace when the operation fails", (long)preCount, (long)postCount);
        admin.disableTable(tn1);
        admin.deleteTable(tn1);
        preCount = observer.postHookCalls.get();
        admin.deleteNamespace("postdeletens");
        postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected 1 invocation of postDeleteNamespace", (long)(preCount + 1), (long)postCount);
    }

    @Test
    public void testPostModifyNamespace() throws IOException {
        Admin admin = UTIL.getAdmin();
        String ns = "postmodifyns";
        NamespaceDescriptor nsDesc = NamespaceDescriptor.create((String)"postmodifyns").build();
        admin.createNamespace(nsDesc);
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterObserverForTest observer = (MasterObserverForTest)master.getMasterCoprocessorHost().findCoprocessor(MasterObserverForTest.class);
        int preCount = observer.postHookCalls.get();
        try {
            admin.modifyNamespace(NamespaceDescriptor.create((String)"nonexistent").build());
            Assert.fail((String)"Modifying a missing namespace should fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected no invocations of postModifyNamespace when the operation fails", (long)preCount, (long)postCount);
        preCount = observer.postHookCalls.get();
        admin.modifyNamespace(NamespaceDescriptor.create((NamespaceDescriptor)nsDesc).addConfiguration("foo", "bar").build());
        postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected 1 invocation of postModifyNamespace", (long)(preCount + 1), (long)postCount);
    }

    @Test
    public void testPostCreateNamespace() throws IOException {
        Admin admin = UTIL.getAdmin();
        String ns = "postcreatens";
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterObserverForTest observer = (MasterObserverForTest)master.getMasterCoprocessorHost().findCoprocessor(MasterObserverForTest.class);
        int preCount = observer.postHookCalls.get();
        NamespaceDescriptor nsDesc = NamespaceDescriptor.create((String)"postcreatens").build();
        admin.createNamespace(nsDesc);
        int postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected 1 invocation of postModifyNamespace", (long)(preCount + 1), (long)postCount);
        preCount = observer.postHookCalls.get();
        try {
            admin.createNamespace(nsDesc);
            Assert.fail((String)"Creating an already present namespace should fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected no invocations of postModifyNamespace when the operation fails", (long)preCount, (long)postCount);
    }

    @Test
    public void testPostCreateTable() throws IOException {
        Admin admin = UTIL.getAdmin();
        TableName tn = TableName.valueOf((String)"postcreatetable");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f1")).build()).build();
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterObserverForTest observer = (MasterObserverForTest)master.getMasterCoprocessorHost().findCoprocessor(MasterObserverForTest.class);
        int preCount = observer.postHookCalls.get();
        admin.createTable(td);
        int postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected 1 invocation of postCreateTable", (long)(preCount + 1), (long)postCount);
        preCount = observer.postHookCalls.get();
        try {
            admin.createTable(td);
            Assert.fail((String)"Creating an already present table should fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected no invocations of postCreateTable when the operation fails", (long)preCount, (long)postCount);
    }

    @Test
    public void testPostModifyTable() throws IOException {
        Admin admin = UTIL.getAdmin();
        TableName tn = TableName.valueOf((String)"postmodifytable");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f1")).build()).build();
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterObserverForTest observer = (MasterObserverForTest)master.getMasterCoprocessorHost().findCoprocessor(MasterObserverForTest.class);
        admin.createTable(td);
        int preCount = observer.postHookCalls.get();
        admin.modifyTable(td);
        int postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected 1 invocation of postModifyTable", (long)(preCount + 1), (long)postCount);
        preCount = observer.postHookCalls.get();
        try {
            admin.modifyTable(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"missing")).setColumnFamily(td.getColumnFamily(Bytes.toBytes((String)"f1"))).build());
            Assert.fail((String)"Modifying a missing table should fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected no invocations of postModifyTable when the operation fails", (long)preCount, (long)postCount);
    }

    @Test
    public void testPostDisableTable() throws IOException {
        Admin admin = UTIL.getAdmin();
        TableName tn = TableName.valueOf((String)"postdisabletable");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f1")).build()).build();
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterObserverForTest observer = (MasterObserverForTest)master.getMasterCoprocessorHost().findCoprocessor(MasterObserverForTest.class);
        admin.createTable(td);
        int preCount = observer.postHookCalls.get();
        admin.disableTable(td.getTableName());
        int postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected 1 invocation of postDisableTable", (long)(preCount + 1), (long)postCount);
        preCount = observer.postHookCalls.get();
        try {
            admin.disableTable(TableName.valueOf((String)"Missing"));
            Assert.fail((String)"Disabling a missing table should fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected no invocations of postDisableTable when the operation fails", (long)preCount, (long)postCount);
    }

    @Test
    public void testPostDeleteTable() throws IOException {
        Admin admin = UTIL.getAdmin();
        TableName tn = TableName.valueOf((String)"postdeletetable");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f1")).build()).build();
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterObserverForTest observer = (MasterObserverForTest)master.getMasterCoprocessorHost().findCoprocessor(MasterObserverForTest.class);
        admin.createTable(td);
        admin.disableTable(td.getTableName());
        int preCount = observer.postHookCalls.get();
        admin.deleteTable(td.getTableName());
        int postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected 1 invocation of postDeleteTable", (long)(preCount + 1), (long)postCount);
        preCount = observer.postHookCalls.get();
        try {
            admin.deleteTable(TableName.valueOf((String)"missing"));
            Assert.fail((String)"Deleting a missing table should fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        postCount = observer.postHookCalls.get();
        Assert.assertEquals((String)"Expected no invocations of postDeleteTable when the operation fails", (long)preCount, (long)postCount);
    }

    public static class MasterObserverForTest
    implements MasterCoprocessor,
    MasterObserver {
        private AtomicInteger postHookCalls = null;

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void start(CoprocessorEnvironment ctx) throws IOException {
            this.postHookCalls = new AtomicInteger(0);
        }

        public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) {
            this.postHookCalls.incrementAndGet();
        }

        public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor oldNsDesc, NamespaceDescriptor currentNsDesc) {
            this.postHookCalls.incrementAndGet();
        }

        public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor desc) {
            this.postHookCalls.incrementAndGet();
        }

        public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor td, RegionInfo[] regions) {
            this.postHookCalls.incrementAndGet();
        }

        public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tn, TableDescriptor oldDescriptor, TableDescriptor currentDescriptor) {
            this.postHookCalls.incrementAndGet();
        }

        public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tn) {
            this.postHookCalls.incrementAndGet();
        }

        public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tn) {
            this.postHookCalls.incrementAndGet();
        }
    }
}

