/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.SnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.TestSnapshotProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotProcedureSnapshotCorrupted
extends TestSnapshotProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotProcedureSnapshotCorrupted.class);

    @Test
    public void testSnapshotCorruptedAndRollback() throws Exception {
        ProcedureExecutor procExec = this.master.getMasterProcedureExecutor();
        SnapshotProcedure sp = new SnapshotProcedure((MasterProcedureEnv)procExec.getEnvironment(), this.snapshotProto);
        procExec.submitProcedure((Procedure)sp);
        TEST_UTIL.waitFor(60000L, 500L, () -> sp.getCurrentStateId() > 8);
        DistributedFileSystem dfs = TEST_UTIL.getDFSCluster().getFileSystem();
        Optional<HRegion> region = TEST_UTIL.getHBaseCluster().getRegions(this.TABLE_NAME).stream().filter(r -> !r.getStoreFileList((byte[][])new byte[][]{this.CF}).isEmpty()).findFirst();
        Assert.assertTrue((boolean)region.isPresent());
        region.get().getStoreFileList((byte[][])new byte[][]{this.CF}).forEach(s -> {
            try {
                dfs.delete(new Path(s), true);
                LOG.info("delete {} to make snapshot corrupt", s);
            }
            catch (Exception e) {
                LOG.warn("Failed delete {} to make snapshot corrupt", s, (Object)e);
            }
        });
        TEST_UTIL.waitFor(60000L, () -> sp.isFailed() && sp.isFinished());
        Configuration conf = this.master.getConfiguration();
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((SnapshotProtos.SnapshotDescription)this.snapshotProto, (Path)CommonFSUtils.getRootDir((Configuration)conf), (Configuration)conf);
        Assert.assertFalse((boolean)dfs.exists(workingDir));
        Assert.assertFalse((boolean)this.master.getSnapshotManager().isTakingSnapshot(this.TABLE_NAME));
        Assert.assertFalse((boolean)this.master.getSnapshotManager().isTakingAnySnapshot());
    }
}

