/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionServerList;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.replication.MigrateReplicationQueueFromZkToTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleanerBarrier;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMigrateReplicationQueueFromZkToTableProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMigrateReplicationQueueFromZkToTableProcedure.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final ConcurrentMap<ServerName, ServerMetrics> EXTRA_REGION_SERVERS = new ConcurrentHashMap<ServerName, ServerMetrics>();
    private static CountDownLatch PEER_PROC_ARRIVE;
    private static CountDownLatch PEER_PROC_RESUME;

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.cleaner.interval", 3600000);
        UTIL.startMiniCluster(StartTestingClusterOption.builder().masterClass(HMasterForTest.class).build());
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    @After
    public void tearDown() throws Exception {
        Admin admin = UTIL.getAdmin();
        for (ReplicationPeerDescription pd : admin.listReplicationPeers()) {
            admin.removeReplicationPeer(pd.getPeerId());
        }
    }

    @Test
    public void testWaitUntilNoPeerProcedure() throws Exception {
        PEER_PROC_ARRIVE = new CountDownLatch(1);
        PEER_PROC_RESUME = new CountDownLatch(1);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        procExec.submitProcedure((Procedure)new FakePeerProcedure("1"));
        PEER_PROC_ARRIVE.await();
        MigrateReplicationQueueFromZkToTableProcedure proc = new MigrateReplicationQueueFromZkToTableProcedure();
        procExec.submitProcedure((Procedure)proc);
        UTIL.waitFor(30000L, () -> proc.getState() == ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        PEER_PROC_RESUME.countDown();
        UTIL.waitFor(30000L, () -> proc.isSuccess());
    }

    @Test
    public void testDisablePeerAndWaitStates() throws Exception {
        String peerId = "2";
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL.getZkCluster().getAddress().toString() + ":/testhbase").setReplicateAllUserTables(true).build();
        UTIL.getAdmin().addReplicationPeer(peerId, rpc);
        ServerMetrics metrics = (ServerMetrics)Mockito.mock(ServerMetrics.class);
        Mockito.when((Object)metrics.getVersion()).thenReturn((Object)"2.5.0");
        EXTRA_REGION_SERVERS.put(ServerName.valueOf((String)"localhost", (int)54321, (long)EnvironmentEdgeManager.currentTime()), metrics);
        ReplicationLogCleanerBarrier barrier = UTIL.getHBaseCluster().getMaster().getReplicationLogCleanerBarrier();
        Assert.assertTrue((boolean)barrier.start());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MigrateReplicationQueueFromZkToTableProcedure proc = new MigrateReplicationQueueFromZkToTableProcedure();
        procExec.submitProcedure((Procedure)proc);
        Thread.sleep(5000L);
        Assert.assertEquals((long)MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState.MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_DISABLE_CLEANER.getNumber(), (long)proc.getCurrentStateId());
        barrier.stop();
        UTIL.waitFor(30000L, () -> proc.getCurrentStateId() == MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState.MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_WAIT_UPGRADING.getNumber() && proc.getState() == ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        Assert.assertFalse((boolean)UTIL.getAdmin().isReplicationPeerEnabled(peerId));
        Assert.assertFalse((boolean)barrier.start());
        EXTRA_REGION_SERVERS.clear();
        UTIL.waitFor(30000L, () -> proc.isSuccess());
        Assert.assertTrue((boolean)UTIL.getAdmin().isReplicationPeerEnabled(peerId));
        Assert.assertTrue((boolean)barrier.start());
        barrier.stop();
    }

    public static final class FakePeerProcedure
    extends Procedure<MasterProcedureEnv>
    implements PeerProcedureInterface {
        private String peerId;

        public FakePeerProcedure() {
        }

        public FakePeerProcedure(String peerId) {
            this.peerId = peerId;
        }

        public String getPeerId() {
            return this.peerId;
        }

        public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
            return PeerProcedureInterface.PeerOperationType.UPDATE_CONFIG;
        }

        protected Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            PEER_PROC_ARRIVE.countDown();
            PEER_PROC_RESUME.await();
            return null;
        }

        protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
            throw new UnsupportedOperationException();
        }

        protected boolean abort(MasterProcedureEnv env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }
    }

    public static final class ServerManagerForTest
    extends ServerManager {
        public ServerManagerForTest(MasterServices master, RegionServerList storage) {
            super(master, storage);
        }

        public Map<ServerName, ServerMetrics> getOnlineServers() {
            HashMap<ServerName, ServerMetrics> map = new HashMap<ServerName, ServerMetrics>(super.getOnlineServers());
            map.putAll(EXTRA_REGION_SERVERS);
            return map;
        }
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected ServerManager createServerManager(MasterServices master, RegionServerList storage) throws IOException {
            this.setupClusterConnection();
            return new ServerManagerForTest(master, storage);
        }
    }
}

