/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.cleaner.DirScanPool;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={MasterTests.class, SmallTests.class})
public class TestSnapshotManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotManager.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();
    MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
    ProcedureCoordinator coordinator = (ProcedureCoordinator)Mockito.mock(ProcedureCoordinator.class);
    ExecutorService pool = (ExecutorService)Mockito.mock(ExecutorService.class);
    MasterFileSystem mfs = (MasterFileSystem)Mockito.mock(MasterFileSystem.class);
    FileSystem fs;

    public TestSnapshotManager() {
        try {
            this.fs = UTIL.getTestFileSystem();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't get test filesystem", e);
        }
    }

    private SnapshotManager getNewManager() throws IOException, KeeperException {
        return this.getNewManager(UTIL.getConfiguration());
    }

    private SnapshotManager getNewManager(Configuration conf) throws IOException, KeeperException {
        return this.getNewManager(conf, 1);
    }

    private SnapshotManager getNewManager(Configuration conf, int intervalSeconds) throws IOException, KeeperException {
        Mockito.reset((Object[])new MasterServices[]{this.services});
        Mockito.when((Object)this.services.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)this.services.getMasterFileSystem()).thenReturn((Object)this.mfs);
        Mockito.when((Object)this.mfs.getFileSystem()).thenReturn((Object)this.fs);
        Mockito.when((Object)this.mfs.getRootDir()).thenReturn((Object)UTIL.getDataTestDir());
        return new SnapshotManager(this.services, this.coordinator, this.pool, intervalSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanFinishedHandler() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Configuration conf = UTIL.getConfiguration();
        try {
            conf.setLong("hbase.snapshot.sentinels.cleanup.timeoutMillis", 5000L);
            SnapshotManager manager = this.getNewManager(conf, 1);
            TakeSnapshotHandler handler = (TakeSnapshotHandler)Mockito.mock(TakeSnapshotHandler.class);
            Assert.assertFalse((String)"Manager is in process when there is no current handler", (boolean)manager.isTakingSnapshot(tableName));
            manager.setSnapshotHandlerForTesting(tableName, (SnapshotSentinel)handler);
            Mockito.when((Object)handler.isFinished()).thenReturn((Object)false);
            Assert.assertTrue((boolean)manager.isTakingAnySnapshot());
            Assert.assertTrue((String)"Manager isn't in process when handler is running", (boolean)manager.isTakingSnapshot(tableName));
            Mockito.when((Object)handler.isFinished()).thenReturn((Object)true);
            Assert.assertFalse((String)"Manager is process when handler isn't running", (boolean)manager.isTakingSnapshot(tableName));
            Assert.assertTrue((boolean)manager.isTakingAnySnapshot());
            Thread.sleep(6000L);
            Assert.assertFalse((boolean)manager.isTakingAnySnapshot());
        }
        finally {
            conf.unset("hbase.snapshot.sentinels.cleanup.timeoutMillis");
        }
    }

    @Test
    public void testInProcess() throws KeeperException, IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        SnapshotManager manager = this.getNewManager();
        TakeSnapshotHandler handler = (TakeSnapshotHandler)Mockito.mock(TakeSnapshotHandler.class);
        Assert.assertFalse((String)"Manager is in process when there is no current handler", (boolean)manager.isTakingSnapshot(tableName));
        manager.setSnapshotHandlerForTesting(tableName, (SnapshotSentinel)handler);
        Mockito.when((Object)handler.isFinished()).thenReturn((Object)false);
        Assert.assertTrue((String)"Manager isn't in process when handler is running", (boolean)manager.isTakingSnapshot(tableName));
        Mockito.when((Object)handler.isFinished()).thenReturn((Object)true);
        Assert.assertFalse((String)"Manager is process when handler isn't running", (boolean)manager.isTakingSnapshot(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotSupportConfiguration() throws Exception {
        Configuration conf = new Configuration();
        SnapshotManager manager = this.getNewManager(conf);
        Assert.assertFalse((String)"Snapshot should be disabled with no configuration", (boolean)this.isSnapshotSupported(manager));
        conf = new Configuration();
        conf.setBoolean("hbase.snapshot.enabled", true);
        manager = this.getNewManager(conf);
        Assert.assertTrue((String)"Snapshot should be enabled", (boolean)this.isSnapshotSupported(manager));
        conf = new Configuration();
        conf.setBoolean("hbase.snapshot.enabled", false);
        manager = this.getNewManager(conf);
        Assert.assertFalse((String)"Snapshot should be disabled", (boolean)this.isSnapshotSupported(manager));
        conf = new Configuration();
        conf.setStrings("hbase.master.hfilecleaner.plugins", new String[]{SnapshotHFileCleaner.class.getName(), HFileLinkCleaner.class.getName()});
        conf.setBoolean("hbase.snapshot.enabled", false);
        manager = this.getNewManager(conf);
        Assert.assertFalse((String)"Snapshot should be disabled", (boolean)this.isSnapshotSupported(manager));
        conf = new Configuration();
        conf.setStrings("hbase.master.hfilecleaner.plugins", new String[]{SnapshotHFileCleaner.class.getName(), HFileLinkCleaner.class.getName()});
        manager = this.getNewManager(conf);
        Assert.assertTrue((String)"Snapshot should be enabled, because cleaners are present", (boolean)this.isSnapshotSupported(manager));
        Path rootDir = UTIL.getDataTestDir();
        Path testSnapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)"testSnapshotSupportConfiguration", (Path)rootDir);
        this.fs.mkdirs(testSnapshotDir);
        try {
            conf = new Configuration();
            conf.setBoolean("hbase.snapshot.enabled", false);
            manager = this.getNewManager(conf);
            Assert.fail((String)"Master should not start when snapshot is disabled, but snapshots are present");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        finally {
            this.fs.delete(testSnapshotDir, true);
        }
    }

    @Test
    public void testDisableSnapshotAndNotDeleteBackReference() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hbase.snapshot.enabled", false);
        SnapshotManager manager = this.getNewManager(conf);
        String cleaners = conf.get("hbase.master.hfilecleaner.plugins");
        Assert.assertTrue((cleaners != null && cleaners.contains(HFileLinkCleaner.class.getName()) ? 1 : 0) != 0);
        Path rootDir = UTIL.getDataTestDir();
        CommonFSUtils.setRootDir((Configuration)conf, (Path)rootDir);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName tableLinkName = TableName.valueOf((String)(this.name.getMethodName() + "-link"));
        String hfileName = "1234567890";
        String familyName = "cf";
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        RegionInfo hriLink = RegionInfoBuilder.newBuilder((TableName)tableLinkName).build();
        Path archiveDir = HFileArchiveUtil.getArchivePath((Configuration)conf);
        Path archiveStoreDir = HFileArchiveUtil.getStoreArchivePath((Configuration)conf, (TableName)tableName, (String)hri.getEncodedName(), (String)familyName);
        Path familyPath = this.getFamilyDirPath(archiveDir, tableName, hri.getEncodedName(), familyName);
        Path hfilePath = new Path(familyPath, hfileName);
        this.fs.createNewFile(hfilePath);
        Path familyLinkPath = this.getFamilyDirPath(rootDir, tableLinkName, hriLink.getEncodedName(), familyName);
        HFileLink.create((Configuration)conf, (FileSystem)this.fs, (Path)familyLinkPath, (RegionInfo)hri, (String)hfileName);
        Path linkBackRefDir = HFileLink.getBackReferencesDir((Path)archiveStoreDir, (String)hfileName);
        Assert.assertTrue((boolean)this.fs.exists(linkBackRefDir));
        FileStatus[] backRefs = this.fs.listStatus(linkBackRefDir);
        Assert.assertEquals((long)1L, (long)backRefs.length);
        Path linkBackRef = backRefs[0].getPath();
        HFileCleaner cleaner = new HFileCleaner(10000, (Stoppable)Mockito.mock(Stoppable.class), conf, this.fs, archiveDir, DirScanPool.getHFileCleanerScanPool((Configuration)conf));
        cleaner.choreForTesting();
        Assert.assertTrue((boolean)this.fs.exists(linkBackRef));
        Assert.assertTrue((boolean)this.fs.exists(hfilePath));
        this.fs.rename(CommonFSUtils.getTableDir((Path)rootDir, (TableName)tableLinkName), CommonFSUtils.getTableDir((Path)archiveDir, (TableName)tableLinkName));
        cleaner.choreForTesting();
        Assert.assertFalse((String)"Link should be deleted", (boolean)this.fs.exists(linkBackRef));
        cleaner.choreForTesting();
        Assert.assertFalse((String)"HFile should be deleted", (boolean)this.fs.exists(hfilePath));
    }

    private Path getFamilyDirPath(Path rootDir, TableName table, String region, String family) {
        return new Path(new Path(CommonFSUtils.getTableDir((Path)rootDir, (TableName)table), region), family);
    }

    private boolean isSnapshotSupported(SnapshotManager manager) {
        try {
            manager.checkSnapshotSupport();
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }
}

