/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestTakeSnapshotHandler {
    private static HBaseTestingUtil UTIL;
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setup() {
        UTIL = new HBaseTestingUtil();
    }

    public TableDescriptor createTableInsertDataAndTakeSnapshot(Map<String, Object> snapshotProps) throws Exception {
        TableDescriptor descriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f")).build()).build();
        UTIL.getConnection().getAdmin().createTable(descriptor);
        Table table = UTIL.getConnection().getTable(descriptor.getTableName());
        Put put = new Put(Bytes.toBytes((String)"1"));
        put.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"v1"));
        table.put(put);
        String snapName = "snap" + this.name.getMethodName();
        UTIL.getAdmin().snapshot(snapName, descriptor.getTableName(), snapshotProps);
        TableName cloned = TableName.valueOf((String)(this.name.getMethodName() + "clone"));
        UTIL.getAdmin().cloneSnapshot(snapName, cloned);
        return descriptor;
    }

    @Test
    public void testPreparePreserveMaxFileSizeEnabled() throws Exception {
        UTIL.startMiniCluster();
        HashMap<String, Object> snapshotProps = new HashMap<String, Object>();
        snapshotProps.put("MAX_FILESIZE", Long.parseLong("21474836480"));
        TableDescriptor descriptor = this.createTableInsertDataAndTakeSnapshot(snapshotProps);
        TableName cloned = TableName.valueOf((String)(this.name.getMethodName() + "clone"));
        Assert.assertEquals((long)-1L, (long)UTIL.getAdmin().getDescriptor(descriptor.getTableName()).getMaxFileSize());
        Assert.assertEquals((long)0x500000000L, (long)UTIL.getAdmin().getDescriptor(cloned).getMaxFileSize());
    }

    @Test
    public void testPreparePreserveMaxFileSizeDisabled() throws Exception {
        UTIL.startMiniCluster();
        TableDescriptor descriptor = this.createTableInsertDataAndTakeSnapshot(null);
        TableName cloned = TableName.valueOf((String)(this.name.getMethodName() + "clone"));
        Assert.assertEquals((long)-1L, (long)UTIL.getAdmin().getDescriptor(descriptor.getTableName()).getMaxFileSize());
        Assert.assertEquals((long)-1L, (long)UTIL.getAdmin().getDescriptor(cloned).getMaxFileSize());
    }

    @After
    public void shutdown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    static {
        CLASS_RULE = HBaseClassTestRule.forClass(TestTakeSnapshotHandler.class);
    }
}

