/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;

public class MobTestUtil {
    protected static final char FIRST_CHAR = 'a';
    protected static final char LAST_CHAR = 'z';

    protected static String generateRandomString(int demoLength) {
        String base = "abcdefghijklmnopqrstuvwxyz";
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < demoLength; ++i) {
            int number = ((Random)rand).nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    protected static void writeStoreFile(StoreFileWriter writer, String caseName) throws IOException {
        MobTestUtil.writeStoreFile(writer, Bytes.toBytes((String)caseName), Bytes.toBytes((String)caseName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStoreFile(StoreFileWriter writer, byte[] fam, byte[] qualifier) throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        try {
            for (int d = 97; d <= 122; d = (int)((char)(d + 1))) {
                for (int e = 97; e <= 122; e = (int)((char)(e + 1))) {
                    byte[] b = new byte[]{(byte)d, (byte)e};
                    writer.append((Cell)new KeyValue(b, fam, qualifier, now, b));
                }
            }
        }
        finally {
            writer.close();
        }
    }

    public static void assertCellEquals(Cell firstKeyValue, Cell secondKeyValue) {
        Assert.assertArrayEquals((byte[])CellUtil.cloneRow((Cell)firstKeyValue), (byte[])CellUtil.cloneRow((Cell)secondKeyValue));
        Assert.assertArrayEquals((byte[])CellUtil.cloneFamily((Cell)firstKeyValue), (byte[])CellUtil.cloneFamily((Cell)secondKeyValue));
        Assert.assertArrayEquals((byte[])CellUtil.cloneQualifier((Cell)firstKeyValue), (byte[])CellUtil.cloneQualifier((Cell)secondKeyValue));
        Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)firstKeyValue), (byte[])CellUtil.cloneValue((Cell)secondKeyValue));
    }

    public static void assertCellsValue(Table table, Scan scan, byte[] expectedValue, int expectedCount) throws IOException {
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            List cells = res.listCells();
            for (Cell cell : cells) {
                Assert.assertArrayEquals((byte[])expectedValue, (byte[])CellUtil.cloneValue((Cell)cell));
                ++count;
            }
        }
        results.close();
        Assert.assertEquals((long)expectedCount, (long)count);
    }

    public static int countMobRows(Table table) throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        return HBaseTestingUtil.countRows(table, scan);
    }

    public static Path generateMOBFileForRegion(Configuration conf, TableName tableName, ColumnFamilyDescriptor familyDescriptor, String regionName) throws IOException {
        Date date = new Date();
        String dateStr = MobUtils.formatDate((Date)date);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path cfMOBDir = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)tableName, (String)familyDescriptor.getNameAsString());
        StoreFileWriter writer = MobUtils.createWriter((Configuration)conf, (FileSystem)fs, (ColumnFamilyDescriptor)familyDescriptor, (String)dateStr, (Path)cfMOBDir, (long)1000L, (Compression.Algorithm)Compression.Algorithm.NONE, (String)"startKey", (CacheConfig)CacheConfig.DISABLED, (Encryption.Context)Encryption.Context.NONE, (boolean)false, (String)"");
        writer.close();
        return writer.getPath();
    }
}

