/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.quotas.MasterQuotasObserver;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestMasterQuotasObserver {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterQuotasObserver.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static SpaceQuotaHelperForTests helper;
    @Rule
    public TestName testName = new TestName();

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        Connection conn;
        if (helper == null) {
            helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, new AtomicLong());
        }
        if (!(conn = TEST_UTIL.getConnection()).getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME)) {
            helper.waitForQuotaTable(conn);
        } else {
            helper.removeAllQuotas(conn);
            Assert.assertEquals((long)0L, (long)helper.listNumDefinedQuotas(conn));
        }
    }

    @Test
    public void testTableSpaceQuotaRemoved() throws Exception {
        TableName tn;
        Connection conn = TEST_UTIL.getConnection();
        Admin admin = conn.getAdmin();
        if (admin.tableExists(tn = TableName.valueOf((String)this.testName.getMethodName()))) {
            this.dropTable(admin, tn);
        }
        this.createTable(admin, tn);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)1024L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        this.dropTable(admin, tn);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
    }

    @Test
    public void testTableRPCQuotaRemoved() throws Exception {
        TableName tn;
        Connection conn = TEST_UTIL.getConnection();
        Admin admin = conn.getAdmin();
        if (admin.tableExists(tn = TableName.valueOf((String)this.testName.getMethodName()))) {
            this.dropTable(admin, tn);
        }
        this.createTable(admin, tn);
        Assert.assertEquals((long)0L, (long)this.getThrottleQuotas());
        QuotaSettings settings = QuotaSettingsFactory.throttleTable((TableName)tn, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)2L, (TimeUnit)TimeUnit.HOURS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getThrottleQuotas());
        this.dropTable(admin, tn);
        Assert.assertEquals((long)0L, (long)this.getThrottleQuotas());
    }

    @Test
    public void testTableSpaceAndRPCQuotaRemoved() throws Exception {
        TableName tn;
        Connection conn = TEST_UTIL.getConnection();
        Admin admin = conn.getAdmin();
        if (admin.tableExists(tn = TableName.valueOf((String)this.testName.getMethodName()))) {
            this.dropTable(admin, tn);
        }
        this.createTable(admin, tn);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)0L, (long)this.getThrottleQuotas());
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)1024L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        admin.setQuota(settings);
        settings = QuotaSettingsFactory.throttleTable((TableName)tn, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)2L, (TimeUnit)TimeUnit.HOURS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)1L, (long)this.getThrottleQuotas());
        settings = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tn);
        admin.setQuota(settings);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)1L, (long)this.getThrottleQuotas());
        settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)1024L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)1L, (long)this.getThrottleQuotas());
        settings = QuotaSettingsFactory.unthrottleTable((TableName)tn);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)0L, (long)this.getThrottleQuotas());
        settings = QuotaSettingsFactory.throttleTable((TableName)tn, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)2L, (TimeUnit)TimeUnit.HOURS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)1L, (long)this.getThrottleQuotas());
        this.dropTable(admin, tn);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)0L, (long)this.getThrottleQuotas());
    }

    @Test
    public void testNamespaceSpaceQuotaRemoved() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        Admin admin = conn.getAdmin();
        String ns = this.testName.getMethodName();
        if (this.namespaceExists(ns)) {
            admin.deleteNamespace(ns);
        }
        NamespaceDescriptor desc = NamespaceDescriptor.create((String)ns).build();
        admin.createNamespace(desc);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
        QuotaSettings settings = QuotaSettingsFactory.limitNamespaceSpace((String)ns, (long)1024L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        admin.deleteNamespace(ns);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
    }

    @Test
    public void testNamespaceRPCQuotaRemoved() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        Admin admin = conn.getAdmin();
        String ns = this.testName.getMethodName();
        if (this.namespaceExists(ns)) {
            admin.deleteNamespace(ns);
        }
        NamespaceDescriptor desc = NamespaceDescriptor.create((String)ns).build();
        admin.createNamespace(desc);
        Assert.assertEquals((long)0L, (long)this.getThrottleQuotas());
        QuotaSettings settings = QuotaSettingsFactory.throttleNamespace((String)ns, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)2L, (TimeUnit)TimeUnit.HOURS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getThrottleQuotas());
        admin.deleteNamespace(ns);
        Assert.assertEquals((long)0L, (long)this.getThrottleQuotas());
    }

    @Test
    public void testNamespaceSpaceAndRPCQuotaRemoved() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        Admin admin = conn.getAdmin();
        String ns = this.testName.getMethodName();
        if (this.namespaceExists(ns)) {
            admin.deleteNamespace(ns);
        }
        NamespaceDescriptor desc = NamespaceDescriptor.create((String)ns).build();
        admin.createNamespace(desc);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)0L, (long)this.getThrottleQuotas());
        QuotaSettings settings = QuotaSettingsFactory.limitNamespaceSpace((String)ns, (long)1024L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        admin.setQuota(settings);
        settings = QuotaSettingsFactory.throttleNamespace((String)ns, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)2L, (TimeUnit)TimeUnit.HOURS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)1L, (long)this.getThrottleQuotas());
        settings = QuotaSettingsFactory.removeNamespaceSpaceLimit((String)ns);
        admin.setQuota(settings);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)1L, (long)this.getThrottleQuotas());
        settings = QuotaSettingsFactory.limitNamespaceSpace((String)ns, (long)1024L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)1L, (long)this.getThrottleQuotas());
        settings = QuotaSettingsFactory.unthrottleNamespace((String)ns);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)0L, (long)this.getThrottleQuotas());
        settings = QuotaSettingsFactory.throttleNamespace((String)ns, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)2L, (TimeUnit)TimeUnit.HOURS);
        admin.setQuota(settings);
        Assert.assertEquals((long)1L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)1L, (long)this.getThrottleQuotas());
        admin.deleteNamespace(ns);
        Assert.assertEquals((long)0L, (long)this.getNumSpaceQuotas());
        Assert.assertEquals((long)0L, (long)this.getThrottleQuotas());
    }

    @Test
    public void testObserverAddedByDefault() throws Exception {
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        MasterCoprocessorHost cpHost = master.getMasterCoprocessorHost();
        Set coprocessorNames = cpHost.getCoprocessors();
        Assert.assertTrue((String)("Did not find MasterQuotasObserver in list of CPs: " + coprocessorNames), (boolean)coprocessorNames.contains(MasterQuotasObserver.class.getSimpleName()));
    }

    public boolean namespaceExists(String ns) throws IOException {
        NamespaceDescriptor[] descs;
        for (NamespaceDescriptor desc : descs = TEST_UTIL.getAdmin().listNamespaceDescriptors()) {
            if (!ns.equals(desc.getName())) continue;
            return true;
        }
        return false;
    }

    public int getNumSpaceQuotas() throws Exception {
        QuotaRetriever scanner = QuotaRetriever.open((Configuration)TEST_UTIL.getConfiguration());
        int numSpaceQuotas = 0;
        for (QuotaSettings quotaSettings : scanner) {
            if (quotaSettings.getQuotaType() != QuotaType.SPACE) continue;
            ++numSpaceQuotas;
        }
        return numSpaceQuotas;
    }

    public int getThrottleQuotas() throws Exception {
        QuotaRetriever scanner = QuotaRetriever.open((Configuration)TEST_UTIL.getConfiguration());
        int throttleQuotas = 0;
        for (QuotaSettings quotaSettings : scanner) {
            if (quotaSettings.getQuotaType() != QuotaType.THROTTLE) continue;
            ++throttleQuotas;
        }
        return throttleQuotas;
    }

    private void createTable(Admin admin, TableName tn) throws Exception {
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tn);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"F1")).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        admin.createTable(tableDescriptorBuilder.build());
    }

    private void dropTable(Admin admin, TableName tn) throws Exception {
        admin.disableTable(tn);
        admin.deleteTable(tn);
    }
}

