/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestSpaceQuotaSwitchPolicies {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceQuotaSwitchPolicies.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, new AtomicLong(0L));
        this.helper.removeAllQuotas();
    }

    @Test
    public void testSetQuotaFirstWithDisableNextNoWrites() throws Exception {
        this.setQuotaAndViolateNextSwitchPoliciesAndValidate(SpaceViolationPolicy.DISABLE, SpaceViolationPolicy.NO_WRITES);
    }

    @Test
    public void testSetQuotaFirstWithDisableNextAgainDisable() throws Exception {
        this.setQuotaAndViolateNextSwitchPoliciesAndValidate(SpaceViolationPolicy.DISABLE, SpaceViolationPolicy.DISABLE);
    }

    @Test
    public void testSetQuotaFirstWithDisableNextNoInserts() throws Exception {
        this.setQuotaAndViolateNextSwitchPoliciesAndValidate(SpaceViolationPolicy.DISABLE, SpaceViolationPolicy.NO_INSERTS);
    }

    @Test
    public void testSetQuotaFirstWithDisableNextNoWritesCompaction() throws Exception {
        this.setQuotaAndViolateNextSwitchPoliciesAndValidate(SpaceViolationPolicy.DISABLE, SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
    }

    @Test
    public void testSetQuotaFirstWithNoWritesNextWithDisable() throws Exception {
        this.setQuotaAndViolateNextSwitchPoliciesAndValidate(SpaceViolationPolicy.NO_WRITES, SpaceViolationPolicy.DISABLE);
    }

    private void setQuotaAndViolateNextSwitchPoliciesAndValidate(SpaceViolationPolicy policy1, SpaceViolationPolicy policy2) throws Exception {
        Put put = new Put(Bytes.toBytes((String)"to_reject"));
        put.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.helper.writeUntilViolationAndVerifyViolation(policy1, (Mutation)put);
        this.helper.setQuotaLimit(tn, policy2, 2L);
        if (policy1.equals((Object)SpaceViolationPolicy.DISABLE) && !policy1.equals((Object)policy2)) {
            TEST_UTIL.waitTableEnabled(tn, 20000L);
        }
        this.helper.verifyViolation(policy2, tn, (Mutation)put);
    }
}

