/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestBlocksScanned {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBlocksScanned.class);
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static byte[] COL = Bytes.toBytes((String)"col");
    private static byte[] START_KEY = Bytes.toBytes((String)"aaa");
    private static byte[] END_KEY = Bytes.toBytes((String)"zzz");
    private static int BLOCK_SIZE = 70;
    private static HBaseTestingUtil TEST_UTIL = null;
    private Configuration conf;
    private Path testDir;

    @Before
    public void setUp() throws Exception {
        TEST_UTIL = new HBaseTestingUtil();
        this.conf = TEST_UTIL.getConfiguration();
        this.testDir = TEST_UTIL.getDataTestDir("TestBlocksScanned");
    }

    @Test
    public void testBlocksScanned() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"TestBlocksScanned");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setMaxVersions(10).setBlockCacheEnabled(true).setBlocksize(BLOCK_SIZE).setCompressionType(Compression.Algorithm.NONE).build()).build();
        this._testBlocksScanned(tableDescriptor);
    }

    @Test
    public void testBlocksScannedWithEncoding() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"TestBlocksScannedWithEncoding");
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((byte[])tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setMaxVersions(10).setBlockCacheEnabled(true).setDataBlockEncoding(DataBlockEncoding.FAST_DIFF).setBlocksize(BLOCK_SIZE).setCompressionType(Compression.Algorithm.NONE).build()).build();
        this._testBlocksScanned(tableDescriptor);
    }

    private void _testBlocksScanned(TableDescriptor td) throws Exception {
        long expectDataBlockRead;
        BlockCache blockCache = BlockCacheFactory.createBlockCache((Configuration)this.conf);
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)td.getTableName()).setStartKey(START_KEY).setEndKey(END_KEY).build();
        HRegion r = HBaseTestingUtil.createRegionAndWAL(regionInfo, this.testDir, this.conf, td, blockCache);
        HTestConst.addContent((Region)r, FAMILY, COL);
        r.flush(true);
        CacheStats stats = blockCache.getStats();
        long before = stats.getHitCount() + stats.getMissCount();
        Scan scan = new Scan().withStartRow(Bytes.toBytes((String)"aaa")).withStopRow(Bytes.toBytes((String)"aaz")).setReadType(Scan.ReadType.PREAD);
        scan.addColumn(FAMILY, COL);
        scan.readVersions(1);
        RegionScannerImpl s = r.getScanner(scan);
        ArrayList results = new ArrayList();
        while (s.next(results)) {
        }
        s.close();
        int expectResultSize = 25;
        Assert.assertEquals((long)expectResultSize, (long)results.size());
        int kvPerBlock = (int)Math.ceil((double)BLOCK_SIZE / (double)KeyValueUtil.ensureKeyValue((Cell)((Cell)results.get(0))).getLength());
        Assert.assertEquals((long)2L, (long)kvPerBlock);
        long expectIndexBlockRead = expectDataBlockRead = (long)Math.ceil((double)expectResultSize / (double)kvPerBlock);
        Assert.assertEquals((long)(expectIndexBlockRead + expectDataBlockRead), (long)(stats.getHitCount() + stats.getMissCount() - before));
    }
}

