/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestCompactorMemLeak {
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final Configuration CONF = UTIL.getConfiguration();
    private static final AtomicBoolean IS_LAST_CELL_ON_HEAP = new AtomicBoolean(false);
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    @Rule
    public TestName name = new TestName();
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactorMemLeak.class);

    @BeforeClass
    public static void setUp() throws Exception {
        IS_LAST_CELL_ON_HEAP.set(false);
        CONF.setBoolean("hbase.server.allocator.pool.enabled", true);
        CONF.setFloat("hfile.block.cache.size", 0.1f);
        CONF.set("hbase.bucketcache.ioengine", "offheap");
        CONF.setFloat("hbase.bucketcache.size", 32.0f);
        CONF.set("hbase.hstore.defaultengine.compactor.class", MyCompactor.class.getName());
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IS_LAST_CELL_ON_HEAP.set(false);
        UTIL.shutdownMiniCluster();
    }

    private void assertMajorCompactionOK(TableName tableName) {
        List regions = UTIL.getHBaseCluster().getRegionServerThreads().get(0).getRegionServer().getRegions(tableName);
        Assert.assertEquals((long)regions.size(), (long)1L);
        HRegion region = (HRegion)regions.get(0);
        Assert.assertEquals((long)region.getStores().size(), (long)1L);
        HStore store = region.getStore(FAMILY);
        Assert.assertEquals((long)store.getStorefilesCount(), (long)1L);
    }

    @Test
    public void testMemLeak() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = UTIL.createTable(tableName, FAMILY);
        Put put = new Put(Bytes.toBytes((String)"row1")).addColumn(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        UTIL.getAdmin().flush(tableName);
        put = new Put(Bytes.toBytes((String)"row2")).addColumn(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        UTIL.getAdmin().flush(tableName);
        UTIL.getAdmin().majorCompact(tableName);
        Thread.sleep(6000L);
        this.assertMajorCompactionOK(tableName);
        Assert.assertTrue((boolean)IS_LAST_CELL_ON_HEAP.get());
    }

    public static class MyCompactor
    extends DefaultCompactor {
        public MyCompactor(Configuration conf, HStore store) {
            super(conf, store);
        }

        protected List<Path> commitWriter(StoreFileWriter writer, Compactor.FileDetails fd, CompactionRequestImpl request) throws IOException {
            HFileWriterImpl writerImpl = (HFileWriterImpl)writer.writer;
            Cell cell = writerImpl.getLastCell();
            IS_LAST_CELL_ON_HEAP.set(cell instanceof KeyValue.KeyOnlyKeyValue);
            return super.commitWriter(writer, fd, request);
        }
    }
}

