/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MasterTests.class, MediumTests.class})
public class TestEncryptionDisabled {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestEncryptionDisabled.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static Configuration conf = TEST_UTIL.getConfiguration();
    private static TableDescriptorBuilder tdb;

    @BeforeClass
    public static void setUp() throws Exception {
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        conf.set("hbase.crypto.enabled", "false");
        conf.set("hbase.table.sanity.checks", "true");
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testEncryptedTableShouldNotBeCreatedWhenEncryptionDisabled() throws Exception {
        tdb = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"default", (String)"TestEncryptionDisabledFail"));
        ColumnFamilyDescriptorBuilder columnFamilyDescriptorBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf"));
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        columnFamilyDescriptorBuilder.setEncryptionType(algorithm);
        tdb.setColumnFamily(columnFamilyDescriptorBuilder.build());
        this.exception.expect(DoNotRetryIOException.class);
        this.exception.expectMessage("encryption is disabled on the cluster");
        TEST_UTIL.getAdmin().createTable(tdb.build());
    }

    @Test
    public void testNonEncryptedTableShouldBeCreatedWhenEncryptionDisabled() throws Exception {
        tdb = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"default", (String)"TestEncryptionDisabledSuccess"));
        ColumnFamilyDescriptorBuilder columnFamilyDescriptorBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"cf"));
        tdb.setColumnFamily(columnFamilyDescriptorBuilder.build());
        TEST_UTIL.getAdmin().createTable(tdb.build());
        TEST_UTIL.waitTableAvailable(tdb.build().getTableName(), 5000L);
    }
}

