/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.TestHStoreFile;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestFSErrorsExposed {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFSErrorsExposed.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFSErrorsExposed.class);
    HBaseTestingUtil util = new HBaseTestingUtil();
    @Rule
    public TestName name = new TestName();

    @Test
    public void testHFileScannerThrowsErrors() throws IOException {
        Path hfilePath = new Path(new Path(this.util.getDataTestDir("internalScannerExposesErrors"), "regionname"), "familyname");
        HFileSystem hfs = (HFileSystem)this.util.getTestFileSystem();
        FaultyFileSystem faultyfs = new FaultyFileSystem(hfs.getBackingFs());
        HFileSystem fs = new HFileSystem((FileSystem)faultyfs);
        CacheConfig cacheConf = new CacheConfig(this.util.getConfiguration());
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.util.getConfiguration(), cacheConf, (FileSystem)hfs).withOutputDir(hfilePath).withFileContext(meta).build();
        TestHStoreFile.writeStoreFile(writer, Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qual"));
        HStoreFile sf = new HStoreFile((FileSystem)fs, writer.getPath(), this.util.getConfiguration(), cacheConf, BloomType.NONE, true);
        sf.initReader();
        StoreFileReader reader = sf.getReader();
        HFileScanner scanner = reader.getScanner(false, true);
        FaultyInputStream inStream = faultyfs.inStreams.get(0).get();
        Assert.assertNotNull((Object)((Object)inStream));
        scanner.seekTo();
        Assert.assertTrue((boolean)scanner.next());
        faultyfs.startFaults();
        try {
            int scanned = 0;
            while (scanner.next()) {
                ++scanned;
            }
            Assert.fail((String)"Scanner didn't throw after faults injected");
        }
        catch (IOException ioe) {
            LOG.info("Got expected exception", (Throwable)ioe);
            Assert.assertTrue((boolean)ioe.getMessage().contains("Fault"));
        }
        reader.close(true);
    }

    @Test
    public void testStoreFileScannerThrowsErrors() throws IOException {
        Path hfilePath = new Path(new Path(this.util.getDataTestDir("internalScannerExposesErrors"), "regionname"), "familyname");
        HFileSystem hfs = (HFileSystem)this.util.getTestFileSystem();
        FaultyFileSystem faultyfs = new FaultyFileSystem(hfs.getBackingFs());
        HFileSystem fs = new HFileSystem((FileSystem)faultyfs);
        CacheConfig cacheConf = new CacheConfig(this.util.getConfiguration());
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.util.getConfiguration(), cacheConf, (FileSystem)hfs).withOutputDir(hfilePath).withFileContext(meta).build();
        TestHStoreFile.writeStoreFile(writer, Bytes.toBytes((String)"cf"), Bytes.toBytes((String)"qual"));
        HStoreFile sf = new HStoreFile((FileSystem)fs, writer.getPath(), this.util.getConfiguration(), cacheConf, BloomType.NONE, true);
        List scanners = StoreFileScanner.getScannersForStoreFiles(Collections.singletonList(sf), (boolean)false, (boolean)true, (boolean)false, (boolean)false, (long)0L);
        KeyValueScanner scanner = (KeyValueScanner)scanners.get(0);
        FaultyInputStream inStream = faultyfs.inStreams.get(0).get();
        Assert.assertNotNull((Object)((Object)inStream));
        scanner.seek((Cell)KeyValue.LOWESTKEY);
        Assert.assertNotNull((Object)scanner.next());
        faultyfs.startFaults();
        try {
            int scanned = 0;
            while (scanner.next() != null) {
                ++scanned;
            }
            Assert.fail((String)"Scanner didn't throw after faults injected");
        }
        catch (IOException ioe) {
            LOG.info("Got expected exception", (Throwable)ioe);
            Assert.assertTrue((boolean)ioe.getMessage().contains("Could not iterate"));
        }
        scanner.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFullSystemBubblesFSErrors() throws Exception {
        Assume.assumeTrue((!this.util.isReadShortCircuitOn() ? 1 : 0) != 0);
        try {
            this.util.getConfiguration().setInt("hbase.client.retries.number", 1);
            this.util.getConfiguration().setInt("hbase.client.scanner.timeout.period", 90000);
            this.util.getConfiguration().setInt("hbase.lease.recovery.timeout", 10000);
            this.util.getConfiguration().setInt("hbase.lease.recovery.dfs.timeout", 1000);
            this.util.startMiniCluster(1);
            TableName tableName = TableName.valueOf((String)this.name.getMethodName());
            byte[] fam = Bytes.toBytes((String)"fam");
            Admin admin = this.util.getAdmin();
            TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])fam).setMaxVersions(1).setBlockCacheEnabled(false).build()).build();
            admin.createTable(tableDescriptor);
            try (Table table = this.util.getConnection().getTable(tableName);){
                this.util.loadTable(table, fam, false);
                this.util.flush();
                HBaseTestingUtil.countRows(table);
                this.util.getDFSCluster().shutdownDataNodes();
                try {
                    HBaseTestingUtil.countRows(table);
                    Assert.fail((String)"Did not fail to count after removing data");
                }
                catch (Exception e) {
                    LOG.info("Got expected error", (Throwable)e);
                    Assert.assertTrue((boolean)e.getMessage().contains("Could not seek"));
                }
            }
            this.util.getDFSCluster().restartDataNodes();
        }
        finally {
            SingleProcessHBaseCluster cluster = this.util.getMiniHBaseCluster();
            if (cluster != null) {
                cluster.killAll();
            }
            this.util.shutdownMiniCluster();
        }
    }

    static class FaultyInputStream
    extends FSDataInputStream {
        boolean faultsStarted = false;

        public FaultyInputStream(InputStream in) throws IOException {
            super(in);
        }

        public void startFaults() {
            this.faultsStarted = true;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            this.injectFault();
            return ((PositionedReadable)this.in).read(position, buffer, offset, length);
        }

        private void injectFault() throws IOException {
            if (this.faultsStarted) {
                throw new IOException("Fault injected");
            }
        }
    }

    static class FaultyFileSystem
    extends FilterFileSystem {
        List<SoftReference<FaultyInputStream>> inStreams = new ArrayList<SoftReference<FaultyInputStream>>();

        public FaultyFileSystem(FileSystem testFileSystem) {
            super(testFileSystem);
        }

        public FSDataInputStream open(Path p, int bufferSize) throws IOException {
            FSDataInputStream orig = this.fs.open(p, bufferSize);
            FaultyInputStream faulty = new FaultyInputStream((InputStream)orig);
            this.inStreams.add(new SoftReference<FaultyInputStream>(faulty));
            return faulty;
        }

        public void startFaults() {
            for (SoftReference<FaultyInputStream> is : this.inStreams) {
                is.get().startFaults();
            }
        }
    }
}

