/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestFlushLifeCycleTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFlushLifeCycleTracker.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final TableName NAME = TableName.valueOf((String)TestFlushLifeCycleTracker.class.getSimpleName());
    private static final byte[] CF = Bytes.toBytes((String)"CF");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"CQ");
    private HRegion region;
    private static FlushLifeCycleTracker TRACKER;
    private static volatile CountDownLatch ARRIVE;
    private static volatile CountDownLatch BLOCK;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException {
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF)).setCoprocessor(FlushObserver.class.getName()).build());
        this.region = UTIL.getHBaseCluster().getRegions(NAME).get(0);
    }

    @After
    public void tearDown() throws IOException {
        this.region = null;
        TRACKER = null;
        UTIL.deleteTable(NAME);
    }

    @Test
    public void test() throws IOException, InterruptedException {
        try (Table table = UTIL.getConnection().getTable(NAME);){
            for (int i = 0; i < 100; ++i) {
                byte[] row = Bytes.toBytes((int)i);
                table.put(new Put(row, true).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(row).setFamily(CF).setQualifier(QUALIFIER).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).setValue(Bytes.toBytes((int)i)).build()));
            }
        }
        Tracker tracker = new Tracker();
        TRACKER = tracker;
        this.region.requestFlush((FlushLifeCycleTracker)tracker);
        tracker.await();
        Assert.assertNull((Object)tracker.reason);
        Assert.assertTrue((boolean)tracker.beforeExecutionCalled);
        Assert.assertTrue((boolean)tracker.afterExecutionCalled);
        tracker = new Tracker();
        TRACKER = tracker;
        this.region.requestFlush((FlushLifeCycleTracker)tracker);
        tracker.await();
        Assert.assertNull((Object)tracker.reason);
        Assert.assertTrue((boolean)tracker.beforeExecutionCalled);
        Assert.assertTrue((boolean)tracker.afterExecutionCalled);
    }

    @Test
    public void testNotExecuted() throws IOException, InterruptedException {
        try (Table table = UTIL.getConnection().getTable(NAME);){
            for (int i = 0; i < 100; ++i) {
                byte[] row = Bytes.toBytes((int)i);
                table.put(new Put(row, true).add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(row).setFamily(CF).setQualifier(QUALIFIER).setTimestamp(Long.MAX_VALUE).setType(Cell.Type.Put).setValue(Bytes.toBytes((int)i)).build()));
            }
        }
        Tracker tracker1 = new Tracker();
        ARRIVE = new CountDownLatch(1);
        BLOCK = new CountDownLatch(1);
        this.region.requestFlush((FlushLifeCycleTracker)tracker1);
        ARRIVE.await();
        Tracker tracker2 = new Tracker();
        this.region.requestFlush((FlushLifeCycleTracker)tracker2);
        tracker2.await();
        Assert.assertNotNull((Object)tracker2.reason);
        Assert.assertFalse((boolean)tracker2.beforeExecutionCalled);
        Assert.assertFalse((boolean)tracker2.afterExecutionCalled);
        BLOCK.countDown();
        tracker1.await();
        Assert.assertNull((Object)tracker1.reason);
        Assert.assertTrue((boolean)tracker1.beforeExecutionCalled);
        Assert.assertTrue((boolean)tracker1.afterExecutionCalled);
    }

    private static final class Tracker
    implements FlushLifeCycleTracker {
        private String reason;
        private boolean beforeExecutionCalled;
        private boolean afterExecutionCalled;
        private boolean completed = false;

        private Tracker() {
        }

        public synchronized void notExecuted(String reason) {
            this.reason = reason;
            this.completed = true;
            this.notifyAll();
        }

        public void beforeExecution() {
            this.beforeExecutionCalled = true;
        }

        public synchronized void afterExecution() {
            this.afterExecutionCalled = true;
            this.completed = true;
            this.notifyAll();
        }

        public synchronized void await() throws InterruptedException {
            while (!this.completed) {
                this.wait();
            }
        }
    }

    public static final class FlushObserver
    implements RegionObserver,
    RegionCoprocessor {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preFlush(ObserverContext<RegionCoprocessorEnvironment> c, FlushLifeCycleTracker tracker) throws IOException {
            if (TRACKER != null) {
                Assert.assertSame((Object)tracker, (Object)TRACKER);
            }
        }

        public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, FlushLifeCycleTracker tracker) throws IOException {
            if (TRACKER != null) {
                Assert.assertSame((Object)tracker, (Object)TRACKER);
            }
            return scanner;
        }

        public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, FlushLifeCycleTracker tracker) throws IOException {
            if (TRACKER != null) {
                Assert.assertSame((Object)tracker, (Object)TRACKER);
            }
        }

        public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, FlushLifeCycleTracker tracker) throws IOException {
            CountDownLatch arrive;
            if (TRACKER != null) {
                Assert.assertSame((Object)tracker, (Object)TRACKER);
            }
            if ((arrive = ARRIVE) != null) {
                arrive.countDown();
                try {
                    BLOCK.await();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
    }
}

