/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import io.opentelemetry.sdk.testing.junit4.OpenTelemetryRule;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestHRegionTracing {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHRegionTracing.class);
    private static HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"qual");
    private static byte[] ROW = Bytes.toBytes((String)"row");
    private static byte[] VALUE = Bytes.toBytes((String)"value");
    @Rule
    public final OpenTelemetryRule traceRule = OpenTelemetryRule.create();
    @Rule
    public final TableNameTestRule tableNameRule = new TableNameTestRule();
    private WAL wal;
    private HRegion region;

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        UTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws IOException {
        TableName tableName = this.tableNameRule.getTableName();
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        RegionInfo info = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        this.wal = HBaseTestingUtil.createWal(UTIL.getConfiguration(), new Path(UTIL.getDataTestDir(), tableName.getNameAsString()), null);
        this.region = HRegion.createHRegion((RegionInfo)info, (Path)UTIL.getDataTestDir(), (Configuration)UTIL.getConfiguration(), (TableDescriptor)desc, (WAL)this.wal);
        this.region = UTIL.createLocalHRegion(info, desc);
    }

    @After
    public void tearDown() throws IOException {
        if (this.region != null) {
            this.region.close();
        }
        Closeables.close((Closeable)this.wal, (boolean)true);
    }

    private void assertSpan(String spanName) {
        Assert.assertTrue((boolean)this.traceRule.getSpans().stream().anyMatch(span -> {
            if (!span.getName().equals(spanName)) {
                return false;
            }
            List regionNames = (List)span.getAttributes().get(HBaseSemanticAttributes.REGION_NAMES_KEY);
            return regionNames != null && regionNames.size() == 1 && ((String)regionNames.get(0)).equals(this.region.getRegionInfo().getRegionNameAsString());
        }));
    }

    @Test
    public void testGet() throws IOException {
        this.region.get(new Get(ROW));
        this.assertSpan("Region.get");
    }

    @Test
    public void testPut() throws IOException {
        this.region.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, VALUE));
        this.assertSpan("Region.put");
        this.assertSpan("Region.getRowLock");
    }

    @Test
    public void testDelete() throws IOException {
        this.region.delete(new Delete(ROW).addColumn(FAMILY, QUALIFIER));
        this.assertSpan("Region.delete");
        this.assertSpan("Region.getRowLock");
    }

    @Test
    public void testAppend() throws IOException {
        this.region.append(new Append(ROW).addColumn(FAMILY, QUALIFIER, VALUE));
        this.assertSpan("Region.append");
        this.assertSpan("Region.getRowLock");
    }

    @Test
    public void testIncrement() throws IOException {
        this.region.increment(new Increment(ROW).addColumn(FAMILY, QUALIFIER, 1L));
        this.assertSpan("Region.increment");
        this.assertSpan("Region.getRowLock");
    }

    @Test
    public void testBatchMutate() throws IOException {
        this.region.batchMutate(new Mutation[]{new Put(ROW).addColumn(FAMILY, QUALIFIER, VALUE)});
        this.assertSpan("Region.batchMutate");
        this.assertSpan("Region.getRowLock");
    }

    @Test
    public void testCheckAndMutate() throws IOException {
        this.region.checkAndMutate(CheckAndMutate.newBuilder((byte[])ROW).ifNotExists(FAMILY, QUALIFIER).build(new Put(ROW).addColumn(FAMILY, QUALIFIER, VALUE)));
        this.assertSpan("Region.checkAndMutate");
        this.assertSpan("Region.getRowLock");
    }

    @Test
    public void testScanner() throws IOException {
        try (RegionScannerImpl scanner = this.region.getScanner(new Scan());){
            scanner.reseek(ROW);
            scanner.next(new ArrayList());
        }
        this.assertSpan("Region.getScanner");
        this.assertSpan("RegionScanner.reseek");
        this.assertSpan("RegionScanner.close");
    }
}

