/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestOpenRegionFailedMemoryLeak {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestOpenRegionFailedMemoryLeak.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestOpenRegionFailedMemoryLeak.class);
    private static HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void startCluster() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.table.sanity.checks", true);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        EnvironmentEdgeManagerTestHelper.reset();
        LOG.info("Cleaning test directory: " + TEST_UTIL.getDataTestDir());
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testOpenRegionFailedMemoryLeak() throws Exception {
        ServerName serverName = ServerName.valueOf((String)"testOpenRegionFailed", (int)100, (long)42L);
        RegionServerServices rss = (RegionServerServices)Mockito.spy((Object)TEST_UTIL.createMockRegionServerService(serverName));
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"testOpenRegionFailed")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])HBaseTestingUtil.fam1)).setValue("COPROCESSOR$1", "hdfs://test/test.jar|test||").build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)htd.getTableName()).build();
        ScheduledExecutorService executor = ((MetricsExecutor)CompatibilitySingletonFactory.getInstance(MetricsExecutor.class)).getExecutor();
        for (int i = 0; i < 20; ++i) {
            try {
                HRegion.openHRegion((RegionInfo)hri, (TableDescriptor)htd, (WAL)rss.getWAL(hri), (Configuration)TEST_UTIL.getConfiguration(), (RegionServerServices)rss, null);
                Assert.fail((String)"Should fail otherwise the test will be useless");
                continue;
            }
            catch (Throwable t) {
                LOG.info("Expected exception, continue", t);
            }
        }
        TimeUnit.SECONDS.sleep(45L);
        Field[] fields = ThreadPoolExecutor.class.getDeclaredFields();
        boolean found = false;
        for (Field field : fields) {
            if (!field.getName().equals("workQueue")) continue;
            field.setAccessible(true);
            BlockingQueue workQueue = (BlockingQueue)field.get(executor);
            Assert.assertTrue((String)("ScheduledExecutor#workQueue should equals 2, now is " + workQueue.size() + ", please check region is close"), (2 == workQueue.size() ? 1 : 0) != 0);
            found = true;
        }
        Assert.assertTrue((String)"can not find workQueue, test failed", (boolean)found);
    }
}

