/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestRegionInterrupt {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionInterrupt.class);
    private static HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionInterrupt.class);
    static final byte[] FAMILY = Bytes.toBytes((String)"info");
    static long sleepTime;
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.retries.number", 1);
        conf.setClass("hbase.hregion.impl", InterruptInterceptingHRegion.class, Region.class);
        conf.setBoolean("hbase.regionserver.close.wait.abort", true);
        long waitInterval = conf.getLong("hbase.regionserver.close.wait.interval.ms", 10000L);
        sleepTime = waitInterval * 2L;
        conf.setLong("hbase.regionserver.close.wait.time.ms", sleepTime * 2L);
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCloseInterruptScanning() throws Exception {
        TableName tableName = this.name.getTableName();
        LOG.info("Creating table " + tableName);
        try (final Table table = TEST_UTIL.createTable(tableName, FAMILY);){
            TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
            TEST_UTIL.loadTable(table, FAMILY);
            final AtomicBoolean expectedExceptionCaught = new AtomicBoolean(false);
            Thread scanner = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Scan scan = new Scan();
                    scan.addFamily(FAMILY);
                    scan.setFilter((Filter)new DelayingFilter());
                    try {
                        LOG.info("Starting scan");
                        try (ResultScanner rs = table.getScanner(scan);){
                            Result r;
                            do {
                                if ((r = rs.next()) == null) continue;
                                LOG.info("Scanned row " + Bytes.toStringBinary((byte[])r.getRow()));
                            } while (r != null);
                        }
                    }
                    catch (IOException e) {
                        LOG.info("Scanner caught exception", (Throwable)e);
                        expectedExceptionCaught.set(true);
                    }
                    finally {
                        LOG.info("Finished scan");
                    }
                }
            });
            scanner.start();
            LOG.info("Waiting for scanner to start");
            Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return DelayingFilter.isSleeping();
                }
            });
            LOG.info("Offlining table " + tableName);
            TEST_UTIL.getAdmin().disableTable(tableName);
            scanner.join();
            Assert.assertTrue((String)"Region operations were not interrupted", (boolean)InterruptInterceptingHRegion.wasInterrupted());
            Assert.assertTrue((String)"Scanner did not catch expected exception", (boolean)expectedExceptionCaught.get());
        }
    }

    @Test
    public void testCloseInterruptMutation() throws Exception {
        final TableName tableName = this.name.getTableName();
        final Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setCoprocessor(MutationDelayingCoprocessor.class.getName()).build();
        LOG.info("Creating table " + tableName);
        admin.createTable(htd);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        LOG.info("Starting writes to table " + tableName);
        int NUM_ROWS = 100;
        final AtomicBoolean expectedExceptionCaught = new AtomicBoolean(false);
        Thread inserter = new Thread(new Runnable(){

            @Override
            public void run() {
                try (BufferedMutator t = admin.getConnection().getBufferedMutator(tableName);){
                    for (int i = 0; i < 100; ++i) {
                        LOG.info("Writing row " + i + " to " + tableName);
                        byte[] value = new byte[10];
                        byte[] row = Bytes.toBytes((String)Integer.toString(i));
                        Bytes.random((byte[])value);
                        t.mutate((Mutation)new Put(row).addColumn(FAMILY, HConstants.EMPTY_BYTE_ARRAY, value));
                        t.flush();
                    }
                }
                catch (IOException e) {
                    LOG.info("Inserter caught exception", (Throwable)e);
                    expectedExceptionCaught.set(true);
                }
            }
        });
        inserter.start();
        LOG.info("Waiting for mutations to start");
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return MutationDelayingCoprocessor.isSleeping();
            }
        });
        LOG.info("Offlining table " + tableName);
        admin.disableTable(tableName);
        inserter.join();
        Assert.assertTrue((String)"Region operations were not interrupted", (boolean)InterruptInterceptingHRegion.wasInterrupted());
        Assert.assertTrue((String)"Inserter did not catch expected exception", (boolean)expectedExceptionCaught.get());
    }

    public static class MutationDelayingCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        static volatile boolean sleeping = false;

        public static boolean isSleeping() {
            return sleeping;
        }

        private void doSleep(Region.Operation op) {
            LOG.info("Starting sleep for " + op);
            sleeping = true;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.info("Interrupted during " + op);
            }
            finally {
                LOG.info("Done");
                sleeping = false;
            }
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            this.doSleep(Region.Operation.PUT);
            super.prePut(c, put, edit, durability);
        }

        public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
            this.doSleep(Region.Operation.DELETE);
            super.preDelete(c, delete, edit, durability);
        }

        public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
            this.doSleep(Region.Operation.APPEND);
            return super.preAppend(c, append);
        }

        public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
            this.doSleep(Region.Operation.INCREMENT);
            return super.preIncrement(c, increment);
        }
    }

    public static class DelayingFilter
    extends FilterBase {
        static volatile boolean sleeping = false;

        public static boolean isSleeping() {
            return sleeping;
        }

        public Filter.ReturnCode filterCell(Cell v) throws IOException {
            LOG.info("Starting sleep on " + v);
            sleeping = true;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.info("Interrupted during sleep on " + v);
            }
            finally {
                LOG.info("Done sleep on " + v);
                sleeping = false;
            }
            return Filter.ReturnCode.INCLUDE;
        }

        public static DelayingFilter parseFrom(byte[] pbBytes) throws DeserializationException {
            return new DelayingFilter();
        }
    }

    public static class InterruptInterceptingHRegion
    extends HRegion {
        private static boolean interrupted = false;

        public static boolean wasInterrupted() {
            return interrupted;
        }

        public InterruptInterceptingHRegion(Path tableDir, WAL wal, FileSystem fs, Configuration conf, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, conf, regionInfo, htd, rsServices);
        }

        public InterruptInterceptingHRegion(HRegionFileSystem fs, WAL wal, Configuration conf, TableDescriptor htd, RegionServerServices rsServices) {
            super(fs, wal, conf, htd, rsServices);
        }

        void checkInterrupt() throws NotServingRegionException, InterruptedIOException {
            try {
                super.checkInterrupt();
            }
            catch (InterruptedIOException | NotServingRegionException e) {
                interrupted = true;
                throw e;
            }
        }

        IOException throwOnInterrupt(Throwable t) {
            interrupted = true;
            return super.throwOnInterrupt(t);
        }
    }
}

