/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.FlakeyTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FlakeyTests.class, LargeTests.class})
public class TestRegionReplicaReplicationError {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicaReplicationError.class);
    private static final HBaseTestingUtil HTU = new HBaseTestingUtil();
    private static String TN = "test";
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static byte[] CQ = Bytes.toBytes((String)"cq");

    @BeforeClass
    public static void setUp() throws Exception {
        HTU.getConfiguration().setBoolean("hbase.region.replica.replication.enabled", true);
        HTU.startMiniCluster(StartTestingClusterOption.builder().rsClass(RSForTest.class).numRegionServers(3).build());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        HTU.shutdownMiniCluster();
    }

    private boolean checkReplica(Table table, int replicaId) throws IOException {
        boolean ret = true;
        for (int i = 0; i < 500; ++i) {
            Result result = table.get(new Get(Bytes.toBytes((int)i)).setReplicaId(replicaId));
            byte[] value = result.getValue(CF, CQ);
            ret &= value != null && value.length > 0 && Bytes.toInt((byte[])value) == i;
        }
        return ret;
    }

    @Test
    public void testDefaultDurability() throws IOException {
        this.doTest(false);
    }

    @Test
    public void testSkipWAL() throws IOException {
        this.doTest(true);
    }

    private void doTest(boolean skipWAL) throws IOException {
        TableName tableName = TableName.valueOf((String)(TN + (skipWAL ? "_skipWAL" : "")));
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionReplication(3).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])CF));
        if (skipWAL) {
            builder.setDurability(Durability.SKIP_WAL);
        }
        TableDescriptor td = builder.build();
        HTU.getAdmin().createTable(td);
        try (Table table = HTU.getConnection().getTable(tableName);){
            for (int i = 0; i < 500; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
            HTU.waitFor(30000L, () -> this.checkReplica(table, 2));
            HTU.waitFor(30000L, () -> this.checkReplica(table, 1));
        }
    }

    public static final class RSForTest
    extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer {
        public RSForTest(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new ErrorReplayRSRpcServices(this);
        }
    }

    public static final class ErrorReplayRSRpcServices
    extends RSRpcServices {
        private final ConcurrentHashMap<HRegion, AtomicInteger> regionToCounter = new ConcurrentHashMap();

        public ErrorReplayRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public AdminProtos.ReplicateWALEntryResponse replicateToReplica(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
            HRegion region;
            List entries = request.getEntryList();
            if (CollectionUtils.isEmpty((Collection)entries)) {
                return AdminProtos.ReplicateWALEntryResponse.getDefaultInstance();
            }
            ByteString regionName = ((AdminProtos.WALEntry)entries.get(0)).getKey().getEncodedRegionName();
            try {
                region = ((HRegionServer)this.server).getRegionByEncodedName(regionName.toStringUtf8());
            }
            catch (NotServingRegionException e) {
                throw new ServiceException((Throwable)e);
            }
            AtomicInteger counter = (AtomicInteger)ConcurrentMapUtils.computeIfAbsent(this.regionToCounter, (Object)region, () -> new AtomicInteger(0));
            if (region.getRegionInfo().getReplicaId() == 1 && counter.addAndGet(entries.size()) < 100) {
                throw new ServiceException("Inject error!");
            }
            return super.replicateToReplica(controller, request);
        }
    }
}

