/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.StartTestingClusterOption;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionServerHostname {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerHostname.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionServerHostname.class);
    private HBaseTestingUtil TEST_UTIL;
    private static final int NUM_MASTERS = 1;
    private static final int NUM_RS = 1;

    @Before
    public void setup() {
        Configuration conf = HBaseConfiguration.create();
        this.TEST_UTIL = new HBaseTestingUtil(conf);
    }

    @After
    public void teardown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testInvalidRegionServerHostnameAbortsServer() throws Exception {
        String invalidHostname = "hostAddr.invalid";
        this.TEST_UTIL.getConfiguration().set("hbase.unsafe.regionserver.hostname", invalidHostname);
        HRegionServer hrs = null;
        try {
            hrs = new HRegionServer(this.TEST_UTIL.getConfiguration());
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)iae.getMessage(), (iae.getMessage().contains("Failed resolve of " + invalidHostname) || iae.getMessage().contains("Problem binding to " + invalidHostname) ? 1 : 0) != 0);
        }
        Assert.assertNull((String)"Failed to validate against invalid hostname", (Object)hrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionServerHostname() throws Exception {
        for (NetworkInterface ni : this.getValidNetworkInterfaces()) {
            Enumeration<InetAddress> addrList = ni.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                if (addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr.isMulticastAddress() || !addr.isSiteLocalAddress()) continue;
                String hostName = addr.getHostName();
                LOG.info("Found " + hostName + " on " + ni + ", addr=" + addr);
                this.TEST_UTIL.getConfiguration().set("hbase.master.hostname", hostName);
                this.TEST_UTIL.getConfiguration().set("hbase.unsafe.regionserver.hostname", hostName);
                StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(1).numRegionServers(1).numDataNodes(1).build();
                this.TEST_UTIL.startMiniCluster(option);
                try {
                    ZKWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();
                    List servers = ZKUtil.listChildrenNoWatch((ZKWatcher)zkw, (String)zkw.getZNodePaths().rsZNode);
                    Assert.assertEquals((long)1L, (long)servers.size());
                    for (String server : servers) {
                        Assert.assertTrue((String)("From zookeeper: " + server + " hostname: " + hostName), (boolean)server.startsWith(hostName.toLowerCase(Locale.ROOT) + ","));
                    }
                    zkw.close();
                }
                finally {
                    this.TEST_UTIL.shutdownMiniCluster();
                }
            }
        }
    }

    @Test
    public void testDeprecatedConfigs() throws Exception {
        Configuration conf = this.TEST_UTIL.getConfiguration();
        new HRegionServer(conf);
        conf.setBoolean("hbase.regionserver.hostname.disable.master.reversedns", false);
        Assert.assertFalse((boolean)conf.getBoolean("hbase.unsafe.regionserver.hostname.disable.master.reversedns", true));
        conf.setBoolean("hbase.regionserver.hostname.disable.master.reversedns", true);
        Assert.assertTrue((boolean)conf.getBoolean("hbase.unsafe.regionserver.hostname.disable.master.reversedns", false));
        conf.setBoolean("hbase.unsafe.regionserver.hostname.disable.master.reversedns", true);
        Assert.assertTrue((boolean)conf.getBoolean("hbase.regionserver.hostname.disable.master.reversedns", false));
        conf.setBoolean("hbase.unsafe.regionserver.hostname.disable.master.reversedns", false);
        Assert.assertFalse((boolean)conf.getBoolean("hbase.regionserver.hostname.disable.master.reversedns", true));
        conf.setBoolean("hbase.regionserver.hostname", false);
        Assert.assertFalse((boolean)conf.getBoolean("hbase.unsafe.regionserver.hostname", true));
        conf.setBoolean("hbase.regionserver.hostname", true);
        Assert.assertTrue((boolean)conf.getBoolean("hbase.unsafe.regionserver.hostname", false));
        conf.setBoolean("hbase.unsafe.regionserver.hostname", true);
        Assert.assertTrue((boolean)conf.getBoolean("hbase.regionserver.hostname", false));
        conf.setBoolean("hbase.unsafe.regionserver.hostname", false);
        Assert.assertFalse((boolean)conf.getBoolean("hbase.regionserver.hostname", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConflictRegionServerHostnameConfigurationsAbortServer() throws Exception {
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface ni = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = ni.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                if (addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr.isMulticastAddress()) continue;
                String hostName = addr.getHostName();
                LOG.info("Found " + hostName + " on " + ni);
                this.TEST_UTIL.getConfiguration().set("hbase.master.hostname", hostName);
                this.TEST_UTIL.getConfiguration().set("hbase.unsafe.regionserver.hostname", hostName);
                this.TEST_UTIL.getConfiguration().setBoolean("hbase.unsafe.regionserver.hostname.disable.master.reversedns", true);
                try {
                    StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(1).numRegionServers(1).numDataNodes(1).build();
                    this.TEST_UTIL.startMiniCluster(option);
                }
                catch (Exception e) {
                    Throwable t1 = e.getCause();
                    Throwable t2 = t1.getCause();
                    Assert.assertTrue((String)(t1.getMessage() + " - " + t2.getMessage()), (boolean)t2.getMessage().contains("hbase.unsafe.regionserver.hostname.disable.master.reversedns and hbase.unsafe.regionserver.hostname are mutually exclusive"));
                    return;
                }
                finally {
                    this.TEST_UTIL.shutdownMiniCluster();
                }
                Assert.assertTrue((String)"Failed to validate against conflict hostname configurations", (boolean)false);
            }
        }
    }

    @Test
    public void testRegionServerHostnameReportedToMaster() throws Exception {
        this.TEST_UTIL.getConfiguration().setBoolean("hbase.unsafe.regionserver.hostname.disable.master.reversedns", true);
        StartTestingClusterOption option = StartTestingClusterOption.builder().numMasters(1).numRegionServers(1).numDataNodes(1).build();
        this.TEST_UTIL.startMiniCluster(option);
        int expectedRS = 1;
        try (ZKWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();){
            List servers = ZKUtil.listChildrenNoWatch((ZKWatcher)zkw, (String)zkw.getZNodePaths().rsZNode);
            Assert.assertEquals((long)expectedRS, (long)servers.size());
        }
    }

    private boolean ignoreNetworkInterface(NetworkInterface networkInterface) throws Exception {
        return networkInterface == null || networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp();
    }

    private List<NetworkInterface> getValidNetworkInterfaces() throws Exception {
        ArrayList<NetworkInterface> validNetworkInterfaces = new ArrayList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (this.ignoreNetworkInterface(networkInterface)) continue;
            validNetworkInterfaces.add(networkInterface);
        }
        return validNetworkInterfaces;
    }
}

