/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.protobuf.ReplicationProtobufUtil;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.regionreplication.RegionReplicationBufferManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestReplicateToReplica {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicateToReplica.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static byte[] QUAL = Bytes.toBytes((String)"qualifier");
    private static ExecutorService EXEC;
    @Rule
    public final TableNameTestRule name = new TableNameTestRule();
    private TableName tableName;
    private Path testDir;
    private TableDescriptor td;
    private RegionServerServices rss;
    private AsyncClusterConnection conn;
    private RegionReplicationBufferManager manager;
    private FlushRequester flushRequester;
    private HRegion primary;
    private HRegion secondary;
    private WALFactory walFactory;
    private boolean queueReqAndResps;
    private Queue<Pair<List<WAL.Entry>, CompletableFuture<Void>>> reqAndResps;
    private static List<Put> TO_ADD_AFTER_PREPARE_FLUSH;

    @BeforeClass
    public static void setUpBeforeClass() {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("hbase.region.read-replica.sink.flush.min-interval.secs", 1);
        conf.setBoolean("hbase.region.replica.replication.enabled", true);
        conf.setBoolean("hbase.region.replica.replication.catalog.enabled", true);
        conf.setClass("hbase.hregion.impl", HRegionForTest.class, HRegion.class);
        EXEC = new ExecutorService("test");
        EXEC.startExecutorService(new ExecutorService.ExecutorConfig(EXEC).setCorePoolSize(1).setExecutorType(ExecutorType.RS_COMPACTED_FILES_DISCHARGER));
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
    }

    @AfterClass
    public static void tearDownAfterClass() {
        EXEC.shutdown();
        UTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws IOException {
        TO_ADD_AFTER_PREPARE_FLUSH = new ArrayList<Put>();
        this.tableName = this.name.getTableName();
        this.testDir = UTIL.getDataTestDir(this.tableName.getNameAsString());
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.rootdir", this.testDir.toString());
        this.td = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).setRegionReplication(2).setRegionMemStoreReplication(true).build();
        this.reqAndResps = new ArrayDeque<Pair<List<WAL.Entry>, CompletableFuture<Void>>>();
        this.queueReqAndResps = true;
        this.conn = (AsyncClusterConnection)Mockito.mock(AsyncClusterConnection.class);
        Mockito.when((Object)this.conn.replicate((RegionInfo)ArgumentMatchers.any(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenAnswer(i -> {
            if (this.queueReqAndResps) {
                List entries = (List)i.getArgument(1, List.class);
                CompletableFuture future = new CompletableFuture();
                this.reqAndResps.add((Pair<List<WAL.Entry>, CompletableFuture<Void>>)Pair.newPair((Object)entries, future));
                return future;
            }
            return CompletableFuture.completedFuture(null);
        });
        this.flushRequester = (FlushRequester)Mockito.mock(FlushRequester.class);
        this.rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        Mockito.when((Object)this.rss.getServerName()).thenReturn((Object)ServerName.valueOf((String)"foo", (int)1, (long)1L));
        Mockito.when((Object)this.rss.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)this.rss.getRegionServerAccounting()).thenReturn((Object)new RegionServerAccounting(conf));
        Mockito.when((Object)this.rss.getExecutorService()).thenReturn((Object)EXEC);
        Mockito.when((Object)this.rss.getAsyncClusterConnection()).thenReturn((Object)this.conn);
        Mockito.when((Object)this.rss.getFlushRequester()).thenReturn((Object)this.flushRequester);
        this.manager = new RegionReplicationBufferManager(this.rss);
        Mockito.when((Object)this.rss.getRegionReplicationBufferManager()).thenReturn((Object)this.manager);
        RegionInfo primaryHri = RegionInfoBuilder.newBuilder((TableName)this.td.getTableName()).build();
        RegionInfo secondaryHri = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)primaryHri, (int)1);
        this.walFactory = new WALFactory(conf, UUID.randomUUID().toString());
        WAL wal = this.walFactory.getWAL(primaryHri);
        this.primary = HRegion.createHRegion((RegionInfo)primaryHri, (Path)this.testDir, (Configuration)conf, (TableDescriptor)this.td, (WAL)wal);
        this.primary.close();
        this.primary = HRegion.openHRegion((Path)this.testDir, (RegionInfo)primaryHri, (TableDescriptor)this.td, (WAL)wal, (Configuration)conf, (RegionServerServices)this.rss, null);
        this.secondary = HRegion.openHRegion((RegionInfo)secondaryHri, (TableDescriptor)this.td, null, (Configuration)conf, (RegionServerServices)this.rss, null);
        Mockito.when((Object)this.rss.getRegions()).then(i -> Arrays.asList(this.primary, this.secondary));
        this.replicateAll();
    }

    @After
    public void tearDown() throws IOException {
        this.queueReqAndResps = false;
        this.failAll();
        HBaseTestingUtil.closeRegionAndWAL(this.primary);
        HBaseTestingUtil.closeRegionAndWAL(this.secondary);
        if (this.walFactory != null) {
            this.walFactory.close();
        }
    }

    private HRegion.FlushResult flushPrimary() throws IOException {
        return this.primary.flushcache(true, true, FlushLifeCycleTracker.DUMMY);
    }

    private void replicate(Pair<List<WAL.Entry>, CompletableFuture<Void>> pair) throws IOException {
        Pair params = ReplicationProtobufUtil.buildReplicateWALEntryRequest((WAL.Entry[])((List)pair.getFirst()).toArray(new WAL.Entry[0]), (byte[])this.secondary.getRegionInfo().getEncodedNameAsBytes(), null, null, null);
        for (AdminProtos.WALEntry entry : ((AdminProtos.ReplicateWALEntryRequest)params.getFirst()).getEntryList()) {
            this.secondary.replayWALEntry(entry, (CellScanner)params.getSecond());
        }
        ((CompletableFuture)pair.getSecond()).complete(null);
    }

    private void replicateOne() throws IOException {
        this.replicate(this.reqAndResps.remove());
    }

    private void replicateAll() throws IOException {
        Pair<List<WAL.Entry>, CompletableFuture<Void>> pair;
        while ((pair = this.reqAndResps.poll()) != null) {
            this.replicate(pair);
        }
    }

    private void failOne() {
        ((CompletableFuture)this.reqAndResps.remove().getSecond()).completeExceptionally(new IOException("Inject error"));
    }

    private void failAll() {
        Pair<List<WAL.Entry>, CompletableFuture<Void>> pair;
        while ((pair = this.reqAndResps.poll()) != null) {
            ((CompletableFuture)pair.getSecond()).completeExceptionally(new IOException("Inject error"));
        }
    }

    @Test
    public void testNormalReplicate() throws IOException {
        byte[] row = Bytes.toBytes((int)0);
        this.primary.put(new Put(row).addColumn(FAMILY, QUAL, Bytes.toBytes((int)1)));
        this.replicateOne();
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])this.secondary.get(new Get(row)).getValue(FAMILY, QUAL)));
    }

    @Test
    public void testNormalFlush() throws IOException {
        byte[] row = Bytes.toBytes((int)0);
        this.primary.put(new Put(row).addColumn(FAMILY, QUAL, Bytes.toBytes((int)1)));
        TO_ADD_AFTER_PREPARE_FLUSH.add(new Put(row).addColumn(FAMILY, QUAL, Bytes.toBytes((int)2)));
        this.flushPrimary();
        this.replicateAll();
        Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])this.secondary.get(new Get(row)).getValue(FAMILY, QUAL)));
        Assert.assertEquals((long)this.primary.getMemStoreDataSize(), (long)this.secondary.getMemStoreDataSize());
    }

    @Test
    public void testErrorBeforeFlushStart() throws IOException {
        byte[] row = Bytes.toBytes((int)0);
        this.primary.put(new Put(row).addColumn(FAMILY, QUAL, Bytes.toBytes((int)1)));
        this.failOne();
        ((FlushRequester)Mockito.verify((Object)this.flushRequester, (VerificationMode)Mockito.times((int)1))).requestFlush((HRegion)ArgumentMatchers.any(), ArgumentMatchers.anyList(), (FlushLifeCycleTracker)ArgumentMatchers.any());
        TO_ADD_AFTER_PREPARE_FLUSH.add(new Put(row).addColumn(FAMILY, QUAL, Bytes.toBytes((int)2)));
        this.flushPrimary();
        this.replicateAll();
        Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])this.secondary.get(new Get(row)).getValue(FAMILY, QUAL)));
        Assert.assertEquals((long)this.primary.getMemStoreDataSize(), (long)this.secondary.getMemStoreDataSize());
    }

    @Test
    public void testErrorAfterFlushStartBeforeFlushCommit() throws IOException {
        this.primary.put(new Put(Bytes.toBytes((int)0)).addColumn(FAMILY, QUAL, Bytes.toBytes((int)1)));
        this.replicateAll();
        TO_ADD_AFTER_PREPARE_FLUSH.add(new Put(Bytes.toBytes((int)1)).addColumn(FAMILY, QUAL, Bytes.toBytes((int)2)));
        this.flushPrimary();
        this.replicateOne();
        this.failOne();
        ((FlushRequester)Mockito.verify((Object)this.flushRequester, (VerificationMode)Mockito.times((int)1))).requestFlush((HRegion)ArgumentMatchers.any(), ArgumentMatchers.anyList(), (FlushLifeCycleTracker)ArgumentMatchers.any());
        this.primary.put(new Put(Bytes.toBytes((int)2)).addColumn(FAMILY, QUAL, Bytes.toBytes((int)3)));
        this.flushPrimary();
        this.replicateAll();
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((long)(i + 1), (long)Bytes.toInt((byte[])this.secondary.get(new Get(Bytes.toBytes((int)i))).getValue(FAMILY, QUAL)));
        }
        Assert.assertEquals((long)0L, (long)this.secondary.getMemStoreDataSize());
    }

    @Test
    public void testCatchUpWithCannotFlush() throws IOException, InterruptedException {
        byte[] row = Bytes.toBytes((int)0);
        this.primary.put(new Put(row).addColumn(FAMILY, QUAL, Bytes.toBytes((int)1)));
        this.failOne();
        ((FlushRequester)Mockito.verify((Object)this.flushRequester, (VerificationMode)Mockito.times((int)1))).requestFlush((HRegion)ArgumentMatchers.any(), ArgumentMatchers.anyList(), (FlushLifeCycleTracker)ArgumentMatchers.any());
        this.flushPrimary();
        this.failAll();
        Thread.sleep(2000L);
        ((FlushRequester)Mockito.verify((Object)this.flushRequester, (VerificationMode)Mockito.times((int)2))).requestFlush((HRegion)ArgumentMatchers.any(), ArgumentMatchers.anyList(), (FlushLifeCycleTracker)ArgumentMatchers.any());
        HRegion.FlushResult result = this.flushPrimary();
        Assert.assertEquals((Object)HRegion.FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY, (Object)result.getResult());
        Assert.assertFalse((boolean)this.secondary.get(new Get(row).setCheckExistenceOnly(true)).getExists());
        this.replicateOne();
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])this.secondary.get(new Get(row)).getValue(FAMILY, QUAL)));
    }

    @Test
    public void testCatchUpWithReopen() throws IOException {
        byte[] row = Bytes.toBytes((int)0);
        this.primary.put(new Put(row).addColumn(FAMILY, QUAL, Bytes.toBytes((int)1)));
        this.failOne();
        this.primary.close();
        Assert.assertFalse((boolean)this.secondary.get(new Get(row).setCheckExistenceOnly(true)).getExists());
        this.primary = HRegion.openHRegion((Path)this.testDir, (RegionInfo)this.primary.getRegionInfo(), (TableDescriptor)this.td, (WAL)this.primary.getWAL(), (Configuration)UTIL.getConfiguration(), (RegionServerServices)this.rss, null);
        this.replicateAll();
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])this.secondary.get(new Get(row)).getValue(FAMILY, QUAL)));
    }

    public static final class HRegionForTest
    extends HRegion {
        public HRegionForTest(HRegionFileSystem fs, WAL wal, Configuration confParam, TableDescriptor htd, RegionServerServices rsServices) {
            super(fs, wal, confParam, htd, rsServices);
        }

        public HRegionForTest(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, RegionInfo regionInfo, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        protected HRegion.PrepareFlushResult internalPrepareFlushCache(WAL wal, long myseqid, Collection<HStore> storesToFlush, MonitoredTask status, boolean writeFlushWalMarker, FlushLifeCycleTracker tracker) throws IOException {
            HRegion.PrepareFlushResult result = super.internalPrepareFlushCache(wal, myseqid, storesToFlush, status, writeFlushWalMarker, tracker);
            for (Put put : TO_ADD_AFTER_PREPARE_FLUSH) {
                this.put(put);
            }
            TO_ADD_AFTER_PREPARE_FLUSH.clear();
            return result;
        }
    }
}

