/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRequestsPerSecondMetric {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRequestsPerSecondMetric.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static final long METRICS_PERIOD = 2000L;
    private static Configuration conf;

    @BeforeClass
    public static void setup() throws Exception {
        conf = UTIL.getConfiguration();
        conf.setLong("hbase.regionserver.metrics.period", 2000L);
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void teardown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testNoNegativeSignAtRequestsPerSecond() throws IOException, InterruptedException {
        TableName TABLENAME = TableName.valueOf((String)"t");
        String FAMILY = "f";
        Admin admin = UTIL.getAdmin();
        UTIL.createMultiRegionTable(TABLENAME, "f".getBytes(), 25);
        Table table = admin.getConnection().getTable(TABLENAME);
        ServerName serverName = (ServerName)admin.getRegionServers().iterator().next();
        HRegionServer regionServer = UTIL.getMiniHBaseCluster().getRegionServer(serverName);
        MetricsRegionServerWrapperImpl metricsWrapper = new MetricsRegionServerWrapperImpl(regionServer);
        MetricsRegionServerWrapperImpl.RegionServerMetricsWrapperRunnable metricsServer = new MetricsRegionServerWrapperImpl.RegionServerMetricsWrapperRunnable(metricsWrapper);
        metricsServer.run();
        UTIL.loadRandomRows(table, "f".getBytes(), 1, 2000);
        Thread.sleep(2000L);
        metricsServer.run();
        admin.disableTable(TABLENAME);
        Thread.sleep(2000L);
        metricsServer.run();
        Assert.assertTrue((metricsWrapper.getRequestsPerSecond() > -1.0 ? 1 : 0) != 0);
    }
}

