/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestScannerRPCScanMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScannerRPCScanMetrics.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestScannerRPCScanMetrics.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static final byte[] VALUE = Bytes.toBytes((String)"testValue");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.regionserver.impl", new String[]{RegionServerWithScanMetrics.class.getName()});
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testScannerRPCScanMetrics() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splits = new byte[][]{Bytes.toBytes((String)"row-4")};
        Table ht = TEST_UTIL.createTable(tableName, FAMILY, (byte[][])splits);
        byte[] r0 = Bytes.toBytes((String)"row-0");
        byte[] r1 = Bytes.toBytes((String)"row-1");
        byte[] r2 = Bytes.toBytes((String)"row-2");
        byte[] r3 = Bytes.toBytes((String)"row-3");
        this.putToTable(ht, r0);
        this.putToTable(ht, r1);
        this.putToTable(ht, r2);
        this.putToTable(ht, r3);
        LOG.info("Wrote our four table entries");
        Scan scan1 = new Scan();
        scan1.withStartRow(r0);
        scan1.withStopRow(Bytes.toBytes((String)"row-4"));
        this.scanNextIterate(ht, scan1);
        Scan scan2 = new Scan();
        scan2.withStartRow(r1);
        this.scanNextIterate(ht, scan2);
        Scan scan3 = new Scan();
        scan3.withStopRow(Bytes.toBytes((String)"row-5"));
        this.scanNextIterate(ht, scan3);
        Scan scan4 = new Scan();
        scan4.withStartRow(r1);
        scan4.withStopRow(r2);
        this.scanNextIterate(ht, scan4);
        Scan dummyScan = new Scan();
        this.scanNextIterate(ht, dummyScan);
        RSRpcServices testClusterRSRPCServices = (RSRpcServices)TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRpcServices();
        Assert.assertEquals((long)4L, (long)testClusterRSRPCServices.rpcFullScanRequestCount.intValue());
    }

    private void putToTable(Table ht, byte[] rowkey) throws IOException {
        Put put = new Put(rowkey);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
    }

    private void scanNextIterate(Table ht, Scan scan) throws Exception {
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        while (result != null) {
            result = scanner.next();
        }
        scanner.close();
    }

    private static class RSRPCServicesWithScanMetrics
    extends RSRpcServices {
        public long getScanRequestCount() {
            return this.rpcScanRequestCount.longValue();
        }

        public long getFullScanRequestCount() {
            return this.rpcFullScanRequestCount.longValue();
        }

        public RSRPCServicesWithScanMetrics(HRegionServer rs) throws IOException {
            super(rs);
        }
    }

    private static class RegionServerWithScanMetrics
    extends SingleProcessHBaseCluster.MiniHBaseClusterRegionServer {
        public RegionServerWithScanMetrics(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRPCServices() throws IOException {
            return new RSRPCServicesWithScanMetrics(this);
        }
    }
}

