/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, MediumTests.class})
public class TestSecureBulkLoadManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSecureBulkLoadManager.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSecureBulkLoadManager.class);
    private static TableName TABLE = TableName.valueOf((byte[])Bytes.toBytes((String)"TestSecureBulkLoadManager"));
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static byte[] COLUMN = Bytes.toBytes((String)"column");
    private static byte[] key1 = Bytes.toBytes((String)"row1");
    private static byte[] key2 = Bytes.toBytes((String)"row2");
    private static byte[] key3 = Bytes.toBytes((String)"row3");
    private static byte[] value1 = Bytes.toBytes((String)"t1");
    private static byte[] value3 = Bytes.toBytes((String)"t3");
    private static byte[] SPLIT_ROWKEY = key2;
    private Thread ealierBulkload;
    private Thread laterBulkload;
    protected Boolean useFileBasedSFT;
    protected static final HBaseTestingUtil testUtil = new HBaseTestingUtil();
    private static Configuration conf = testUtil.getConfiguration();

    public TestSecureBulkLoadManager(Boolean useFileBasedSFT) {
        this.useFileBasedSFT = useFileBasedSFT;
    }

    @Parameterized.Parameters
    public static Collection<Boolean> data() {
        Boolean[] data = new Boolean[]{false, true};
        return Arrays.asList(data);
    }

    @Before
    public void setUp() throws Exception {
        if (this.useFileBasedSFT.booleanValue()) {
            conf.set("hbase.store.file-tracker.impl", "org.apache.hadoop.hbase.regionserver.storefiletracker.FileBasedStoreFileTracker");
        } else {
            conf.unset("hbase.store.file-tracker.impl");
        }
        testUtil.startMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        testUtil.shutdownMiniCluster();
        testUtil.cleanupTestDir();
    }

    @Test
    public void testForRaceCondition() throws Exception {
        Consumer<HRegion> fsCreatedListener = new Consumer<HRegion>(){

            @Override
            public void accept(HRegion hRegion) {
                if (hRegion.getRegionInfo().containsRow(key3)) {
                    Threads.shutdown((Thread)TestSecureBulkLoadManager.this.ealierBulkload);
                }
            }
        };
        testUtil.getMiniHBaseCluster().getRegionServerThreads().get(0).getRegionServer().getSecureBulkLoadManager().setFsCreatedListener((Consumer)fsCreatedListener);
        testUtil.createTable(TABLE, FAMILY, Bytes.toByteArrays((byte[])SPLIT_ROWKEY));
        Path rootdir = testUtil.getMiniHBaseCluster().getRegionServerThreads().get(0).getRegionServer().getDataRootDir();
        final Path dir1 = new Path(rootdir, "dir1");
        this.prepareHFile(dir1, key1, value1);
        final Path dir2 = new Path(rootdir, "dir2");
        this.prepareHFile(dir2, key3, value3);
        final AtomicReference t1Exception = new AtomicReference();
        final AtomicReference t2Exception = new AtomicReference();
        this.ealierBulkload = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestSecureBulkLoadManager.this.doBulkloadWithoutRetry(dir1);
                }
                catch (Exception e) {
                    LOG.error("bulk load failed .", (Throwable)e);
                    t1Exception.set(e);
                }
            }
        });
        this.laterBulkload = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestSecureBulkLoadManager.this.doBulkloadWithoutRetry(dir2);
                }
                catch (Exception e) {
                    LOG.error("bulk load failed .", (Throwable)e);
                    t2Exception.set(e);
                }
            }
        });
        this.ealierBulkload.start();
        this.laterBulkload.start();
        Threads.shutdown((Thread)this.ealierBulkload);
        Threads.shutdown((Thread)this.laterBulkload);
        Assert.assertNull(t1Exception.get());
        Assert.assertNull(t2Exception.get());
        Get get1 = new Get(key1);
        Get get3 = new Get(key3);
        Table t = testUtil.getConnection().getTable(TABLE);
        Result r = t.get(get1);
        Assert.assertArrayEquals((byte[])r.getValue(FAMILY, COLUMN), (byte[])value1);
        r = t.get(get3);
        Assert.assertArrayEquals((byte[])r.getValue(FAMILY, COLUMN), (byte[])value3);
    }

    private void doBulkloadWithoutRetry(Path dir) throws Exception {
        BulkLoadHFilesTool h = new BulkLoadHFilesTool(conf){

            protected void bulkLoadPhase(AsyncClusterConnection conn, TableName tableName, Deque<BulkLoadHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, BulkLoadHFiles.LoadQueueItem> regionGroups, boolean copyFiles, Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
                super.bulkLoadPhase(conn, tableName, queue, regionGroups, copyFiles, item2RegionMap);
                throw new MyExceptionToAvoidRetry();
            }
        };
        try {
            h.bulkLoad(TABLE, dir);
            Assert.fail((String)"MyExceptionToAvoidRetry is expected");
        }
        catch (MyExceptionToAvoidRetry myExceptionToAvoidRetry) {
            // empty catch block
        }
    }

    private void prepareHFile(Path dir, byte[] key, byte[] value) throws Exception {
        TableDescriptor desc = testUtil.getAdmin().getDescriptor(TABLE);
        ColumnFamilyDescriptor family = desc.getColumnFamily(FAMILY);
        Compression.Algorithm compression = HFile.DEFAULT_COMPRESSION_ALGORITHM;
        CacheConfig writerCacheConf = new CacheConfig(conf, family, null, ByteBuffAllocator.HEAP);
        writerCacheConf.setCacheDataOnWrite(false);
        HFileContext hFileContext = new HFileContextBuilder().withIncludesMvcc(false).withIncludesTags(true).withCompression(compression).withCompressTags(family.isCompressTags()).withChecksumType(StoreUtils.getChecksumType((Configuration)conf)).withBytesPerCheckSum(StoreUtils.getBytesPerChecksum((Configuration)conf)).withBlockSize(family.getBlocksize()).withHBaseCheckSum(true).withDataBlockEncoding(family.getDataBlockEncoding()).withEncryptionContext(Encryption.Context.NONE).withCreateTime(EnvironmentEdgeManager.currentTime()).build();
        StoreFileWriter.Builder builder = new StoreFileWriter.Builder(conf, writerCacheConf, dir.getFileSystem(conf)).withOutputDir(new Path(dir, family.getNameAsString())).withBloomType(family.getBloomFilterType()).withMaxKeyCount(Integer.MAX_VALUE).withFileContext(hFileContext);
        StoreFileWriter writer = builder.build();
        Put put = new Put(key);
        put.addColumn(FAMILY, COLUMN, value);
        for (Cell c : put.get(FAMILY, COLUMN)) {
            writer.append(c);
        }
        writer.close();
    }

    class MyExceptionToAvoidRetry
    extends DoNotRetryIOException {
        private static final long serialVersionUID = -6802760664998771151L;

        MyExceptionToAvoidRetry() {
        }
    }
}

