/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.querymatcher.AbstractTestScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.UserScanQueryMatcher;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestUserScanQueryMatcher
extends AbstractTestScanQueryMatcher {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestUserScanQueryMatcher.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestUserScanQueryMatcher.class);

    @Test
    public void testNeverIncludeFakeCell() throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)this.scan, (ScanInfo)new ScanInfo(this.conf, this.fam2, 10, 1, this.ttl, KeepDeletedCells.FALSE, 65536L, 0L, this.rowComparator, false), (NavigableSet)((NavigableSet)this.get.getFamilyMap().get(this.fam2)), (long)(now - this.ttl), (long)now, null);
        KeyValue kv = new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data);
        Cell cell = PrivateCellUtil.createLastOnRowCol((Cell)kv);
        qm.setToNewRow((Cell)kv);
        ScanQueryMatcher.MatchCode code = qm.match(cell);
        Assert.assertFalse((code.compareTo((Enum)ScanQueryMatcher.MatchCode.SEEK_NEXT_COL) != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMatchExplicitColumns() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>(6);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)this.scan, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 1, this.ttl, KeepDeletedCells.FALSE, 65536L, 0L, this.rowComparator, false), (NavigableSet)((NavigableSet)this.get.getFamilyMap().get(this.fam2)), (long)(now - this.ttl), (long)now, null);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>(6);
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, 1L, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(memstore.size());
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setToNewRow((Cell)k);
        for (KeyValue kv : memstore) {
            actual.add(qm.match((Cell)kv));
        }
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            LOG.debug("expected " + expected.get(i) + ", actual " + actual.get(i));
            Assert.assertEquals(expected.get(i), actual.get(i));
        }
    }

    @Test
    public void testMatch_Wildcard() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>(6);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)this.scan, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 1, this.ttl, KeepDeletedCells.FALSE, 65536L, 0L, this.rowComparator, false), null, (long)(now - this.ttl), (long)now, null);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>(6);
        memstore.add(new KeyValue(this.row1, this.fam2, this.col1, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col3, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col4, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam2, this.col5, 1L, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, 1L, this.data));
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(memstore.size());
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setToNewRow((Cell)k);
        for (KeyValue kv : memstore) {
            actual.add(qm.match((Cell)kv));
        }
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            LOG.debug("expected " + expected.get(i) + ", actual " + actual.get(i));
            Assert.assertEquals(expected.get(i), actual.get(i));
        }
    }

    @Test
    public void testMatch_ExpiredExplicit() throws IOException {
        long testTTL = 1000L;
        ScanQueryMatcher.MatchCode[] expected = new ScanQueryMatcher.MatchCode[]{ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW, ScanQueryMatcher.MatchCode.DONE};
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)this.scan, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 1, testTTL, KeepDeletedCells.FALSE, 65536L, 0L, this.rowComparator, false), (NavigableSet)((NavigableSet)this.get.getFamilyMap().get(this.fam2)), (long)(now - testTTL), (long)now, null);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        KeyValue k = kvs[0];
        qm.setToNewRow((Cell)k);
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match((Cell)kv));
        }
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            LOG.debug("expected " + expected[i] + ", actual " + actual.get(i));
            Assert.assertEquals((Object)expected[i], actual.get(i));
        }
    }

    @Test
    public void testMatch_ExpiredWildcard() throws IOException {
        long testTTL = 1000L;
        ScanQueryMatcher.MatchCode[] expected = new ScanQueryMatcher.MatchCode[]{ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.INCLUDE, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.DONE};
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)this.scan, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 1, testTTL, KeepDeletedCells.FALSE, 65536L, 0L, this.rowComparator, false), null, (long)(now - testTTL), (long)now, null);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(this.row1, this.fam2, this.col1, now - 100L, this.data), new KeyValue(this.row1, this.fam2, this.col2, now - 50L, this.data), new KeyValue(this.row1, this.fam2, this.col3, now - 5000L, this.data), new KeyValue(this.row1, this.fam2, this.col4, now - 500L, this.data), new KeyValue(this.row1, this.fam2, this.col5, now - 10000L, this.data), new KeyValue(this.row2, this.fam1, this.col1, now - 10L, this.data)};
        KeyValue k = kvs[0];
        qm.setToNewRow((Cell)k);
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(kvs.length);
        for (KeyValue kv : kvs) {
            actual.add(qm.match((Cell)kv));
        }
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            LOG.debug("expected " + expected[i] + ", actual " + actual.get(i));
            Assert.assertEquals((Object)expected[i], actual.get(i));
        }
    }

    @Test
    public void testMatchWhenFilterReturnsIncludeAndSeekNextRow() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.DONE);
        Scan scanWithFilter = new Scan(this.scan).setFilter((Filter)new AlwaysIncludeAndSeekNextRowFilter());
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)scanWithFilter, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 1, this.ttl, KeepDeletedCells.FALSE, 65536L, 0L, this.rowComparator, false), (NavigableSet)((NavigableSet)this.get.getFamilyMap().get(this.fam2)), (long)(now - this.ttl), (long)now, null);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam2, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row2, this.fam1, this.col1, this.data));
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(memstore.size());
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setToNewRow((Cell)k);
        for (KeyValue kv : memstore) {
            actual.add(qm.match((Cell)kv));
        }
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            LOG.debug("expected " + expected.get(i) + ", actual " + actual.get(i));
            Assert.assertEquals(expected.get(i), actual.get(i));
        }
    }

    @Test
    public void testMergeFilterResponseCase1() throws IOException {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW);
        Scan scanWithFilter = new Scan(this.scan).setFilter((Filter)new AlwaysIncludeFilter()).readVersions(2);
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)scanWithFilter, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 3, this.ttl, KeepDeletedCells.FALSE, 65536L, 0L, this.rowComparator, false), (NavigableSet)((NavigableSet)this.get.getFamilyMap().get(this.fam2)), (long)(now - this.ttl), (long)now, null);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam1, this.col5, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam1, this.col5, 2L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam1, this.col5, 3L, this.data));
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setToNewRow((Cell)k);
        for (int i = 0; i < memstore.size(); ++i) {
            Assert.assertEquals(expected.get(i), (Object)qm.match((Cell)memstore.get(i)));
        }
        scanWithFilter = new Scan(this.scan).setFilter((Filter)new AlwaysIncludeFilter()).readVersions(1);
        qm = UserScanQueryMatcher.create((Scan)scanWithFilter, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 2, this.ttl, KeepDeletedCells.FALSE, 65536L, 0L, this.rowComparator, false), (NavigableSet)((NavigableSet)this.get.getFamilyMap().get(this.fam2)), (long)(now - this.ttl), (long)now, null);
        ArrayList<KeyValue> memstore2 = new ArrayList<KeyValue>();
        memstore2.add(new KeyValue(this.row2, this.fam1, this.col2, 1L, this.data));
        memstore2.add(new KeyValue(this.row2, this.fam1, this.col2, 2L, this.data));
        k = (KeyValue)memstore2.get(0);
        qm.setToNewRow((Cell)k);
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.INCLUDE, (Object)qm.match((Cell)memstore2.get(0)));
        Assert.assertEquals((Object)ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, (Object)qm.match((Cell)memstore2.get(1)));
    }

    @Test
    public void testMergeFilterResponseCase2() throws Exception {
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>();
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        Scan scanWithFilter = new Scan(this.scan).setFilter((Filter)new AlwaysIncludeFilter()).readVersions(3);
        long now = EnvironmentEdgeManager.currentTime();
        UserScanQueryMatcher qm = UserScanQueryMatcher.create((Scan)scanWithFilter, (ScanInfo)new ScanInfo(this.conf, this.fam2, 0, 5, this.ttl, KeepDeletedCells.FALSE, 65536L, 0L, this.rowComparator, false), (NavigableSet)((NavigableSet)this.get.getFamilyMap().get(this.fam2)), (long)(now - this.ttl), (long)now, null);
        ArrayList<KeyValue> memstore = new ArrayList<KeyValue>();
        memstore.add(new KeyValue(this.row1, this.fam1, this.col2, 1L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam1, this.col2, 2L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam1, this.col2, 3L, this.data));
        memstore.add(new KeyValue(this.row1, this.fam1, this.col2, 4L, this.data));
        KeyValue k = (KeyValue)memstore.get(0);
        qm.setToNewRow((Cell)k);
        for (int i = 0; i < memstore.size(); ++i) {
            Assert.assertEquals(expected.get(i), (Object)qm.match((Cell)memstore.get(i)));
        }
        Cell lastCell = (Cell)memstore.get(memstore.size() - 1);
        Cell nextCell = qm.getKeyForNextColumn(lastCell);
        Assert.assertArrayEquals((byte[])nextCell.getQualifierArray(), (byte[])this.col4);
    }

    private static class AlwaysIncludeFilter
    extends FilterBase {
        private AlwaysIncludeFilter() {
        }

        public Filter.ReturnCode filterCell(Cell c) {
            return Filter.ReturnCode.INCLUDE;
        }
    }

    private static class AlwaysIncludeAndSeekNextRowFilter
    extends FilterBase {
        private AlwaysIncludeAndSeekNextRowFilter() {
        }

        public Filter.ReturnCode filterCell(Cell c) {
            return Filter.ReturnCode.INCLUDE_AND_SEEK_NEXT_ROW;
        }
    }
}

