/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.AbstractTestFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestAsyncFSWAL
extends AbstractTestFSWAL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncFSWAL.class);
    private static EventLoopGroup GROUP;
    private static Class<? extends Channel> CHANNEL_CLASS;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        GROUP = new NioEventLoopGroup(1, new ThreadFactoryBuilder().setNameFormat("TestAsyncFSWAL-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
        CHANNEL_CLASS = NioSocketChannel.class;
        AbstractTestFSWAL.setUpBeforeClass();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractTestFSWAL.tearDownAfterClass();
        GROUP.shutdownGracefully();
    }

    @Override
    protected AbstractFSWAL<?> newWAL(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws IOException {
        AsyncFSWAL wal = new AsyncFSWAL(fs, null, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, null, null, GROUP, CHANNEL_CLASS, StreamSlowMonitor.create((Configuration)conf, (String)"monitor"));
        wal.init();
        return wal;
    }

    @Override
    protected AbstractFSWAL<?> newSlowWAL(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, final Runnable action) throws IOException {
        AsyncFSWAL wal = new AsyncFSWAL(fs, null, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, null, null, GROUP, CHANNEL_CLASS, StreamSlowMonitor.create((Configuration)conf, (String)"monitor")){

            protected void atHeadOfRingBufferEventHandlerAppend() {
                action.run();
                super.atHeadOfRingBufferEventHandlerAppend();
            }
        };
        wal.init();
        return wal;
    }

    @Test
    public void testBrokenWriter() throws Exception {
        RegionServerServices services = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)CONF);
        final TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"table")).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"row")).build();
        final RegionInfo ri = RegionInfoBuilder.newBuilder((TableName)td.getTableName()).build();
        final MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        final TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : td.getColumnFamilyNames()) {
            scopes.put(fam, 0);
        }
        final long timestamp = EnvironmentEdgeManager.currentTime();
        String testName = this.currentTest.getMethodName();
        final AtomicInteger failedCount = new AtomicInteger(0);
        try (LogRoller roller = new LogRoller(services);
             final AsyncFSWAL wal = new AsyncFSWAL(FS, null, CommonFSUtils.getWALRootDir((Configuration)CONF), DIR.toString(), testName, CONF, null, true, null, null, null, null, GROUP, CHANNEL_CLASS, StreamSlowMonitor.create((Configuration)CONF, (String)"monitorForSuffix")){

            protected WALProvider.AsyncWriter createWriterInstance(FileSystem fs, Path path) throws IOException {
                final WALProvider.AsyncWriter writer = super.createWriterInstance(fs, path);
                return new WALProvider.AsyncWriter(){

                    public void close() throws IOException {
                        writer.close();
                    }

                    public long getLength() {
                        return writer.getLength();
                    }

                    public long getSyncedLength() {
                        return writer.getSyncedLength();
                    }

                    public CompletableFuture<Long> sync(boolean forceSync) {
                        CompletableFuture result = writer.sync(forceSync);
                        if (failedCount.incrementAndGet() < 1000) {
                            CompletableFuture<Long> future = new CompletableFuture<Long>();
                            FutureUtils.addListener((CompletableFuture)result, (r, e) -> future.completeExceptionally(new IOException("Inject Error")));
                            return future;
                        }
                        return result;
                    }

                    public void append(WAL.Entry entry) {
                        writer.append(entry);
                    }
                };
            }
        };){
            wal.init();
            roller.addWAL((WAL)wal);
            roller.start();
            int numThreads = 10;
            final AtomicReference error = new AtomicReference();
            Thread[] threads = new Thread[numThreads];
            int i = 0;
            while (i < 10) {
                final int index = i++;
                threads[index] = new Thread("Write-Thread-" + index){

                    @Override
                    public void run() {
                        byte[] row = Bytes.toBytes((String)("row" + index));
                        WALEdit cols = new WALEdit();
                        cols.add((Cell)new KeyValue(row, row, row, timestamp + (long)index, row));
                        WALKeyImpl key = new WALKeyImpl(ri.getEncodedNameAsBytes(), td.getTableName(), -1L, timestamp, WALKey.EMPTY_UUIDS, 0L, 0L, mvcc, scopes);
                        try {
                            wal.append(ri, key, cols, true);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        try {
                            wal.sync();
                        }
                        catch (IOException e) {
                            error.set(e);
                        }
                    }
                };
            }
            for (Thread t : threads) {
                t.start();
            }
            for (Thread t : threads) {
                t.join();
            }
            Assert.assertNull(error.get());
        }
    }
}

