/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.TestBulkLoadReplication;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.zookeeper.Watcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public final class TestNamespaceReplicationWithBulkLoadedData
extends TestBulkLoadReplication {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNamespaceReplicationWithBulkLoadedData.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestNamespaceReplicationWithBulkLoadedData.class);
    private static final HBaseTestingUtil UTIL4 = new HBaseTestingUtil();
    private static final String PEER4_CLUSTER_ID = "peer4";
    private static final String PEER4_NS = "ns_peer1";
    private static final String PEER4_NS_TABLE = "ns_peer2";
    private static final Configuration CONF4 = UTIL4.getConfiguration();
    private static final String NS1 = "ns1";
    private static final String NS2 = "ns2";
    private static final TableName NS1_TABLE = TableName.valueOf((String)"ns1:t1_syncup");
    private static final TableName NS2_TABLE = TableName.valueOf((String)"ns2:t2_syncup");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestNamespaceReplicationWithBulkLoadedData.setupBulkLoadConfigsForCluster(CONF4, PEER4_CLUSTER_ID);
        TestNamespaceReplicationWithBulkLoadedData.setupConfig(UTIL4, "/4");
        TestBulkLoadReplication.setUpBeforeClass();
        TestNamespaceReplicationWithBulkLoadedData.startFourthCluster();
    }

    private static void startFourthCluster() throws Exception {
        LOG.info("Setup Zk to same one from UTIL1 and UTIL2 and UTIL3");
        UTIL4.setZkCluster(UTIL1.getZkCluster());
        UTIL4.startMiniCluster(NUM_SLAVES1);
        TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setMaxVersions(100).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])noRepfamName)).build();
        Connection connection4 = ConnectionFactory.createConnection((Configuration)CONF4);
        try (Admin admin4 = connection4.getAdmin();){
            admin4.createTable(table, HBaseTestingUtil.KEYS_FOR_HBA_CREATE_TABLE);
        }
        UTIL4.waitUntilAllRegionsAssigned(tableName);
    }

    @Override
    @Before
    public void setUpBase() throws Exception {
        super.setUpBase();
        TableDescriptor table1 = TableDescriptorBuilder.newBuilder((TableName)NS1_TABLE).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])noRepfamName)).build();
        TableDescriptor table2 = TableDescriptorBuilder.newBuilder((TableName)NS2_TABLE).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])noRepfamName)).build();
        Admin admin1 = UTIL1.getAdmin();
        admin1.createNamespace(NamespaceDescriptor.create((String)NS1).build());
        admin1.createNamespace(NamespaceDescriptor.create((String)NS2).build());
        admin1.createTable(table1);
        admin1.createTable(table2);
        Admin admin2 = UTIL2.getAdmin();
        admin2.createNamespace(NamespaceDescriptor.create((String)NS1).build());
        admin2.createNamespace(NamespaceDescriptor.create((String)NS2).build());
        admin2.createTable(table1);
        admin2.createTable(table2);
        Admin admin3 = UTIL3.getAdmin();
        admin3.createNamespace(NamespaceDescriptor.create((String)NS1).build());
        admin3.createNamespace(NamespaceDescriptor.create((String)NS2).build());
        admin3.createTable(table1);
        admin3.createTable(table2);
        Admin admin4 = UTIL4.getAdmin();
        admin4.createNamespace(NamespaceDescriptor.create((String)NS1).build());
        admin4.createNamespace(NamespaceDescriptor.create((String)NS2).build());
        admin4.createTable(table1);
        admin4.createTable(table2);
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(NS1);
        ReplicationPeerConfig rpc4_ns = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL4.getClusterKey()).setReplicateAllUserTables(false).setNamespaces(namespaces).build();
        admin1.addReplicationPeer(PEER4_NS, rpc4_ns);
        HashMap<TableName, Object> tableCFsMap = new HashMap<TableName, Object>();
        tableCFsMap.put(NS2_TABLE, null);
        ReplicationPeerConfig rpc4_ns_table = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL4.getClusterKey()).setReplicateAllUserTables(false).setTableCFsMap(tableCFsMap).build();
        admin1.addReplicationPeer(PEER4_NS_TABLE, rpc4_ns_table);
    }

    @Override
    @After
    public void tearDownBase() throws Exception {
        super.tearDownBase();
        TableDescriptor table1 = TableDescriptorBuilder.newBuilder((TableName)NS1_TABLE).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])noRepfamName)).build();
        TableDescriptor table2 = TableDescriptorBuilder.newBuilder((TableName)NS2_TABLE).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])famName).setScope(1).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])noRepfamName)).build();
        Admin admin1 = UTIL1.getAdmin();
        admin1.disableTable(table1.getTableName());
        admin1.deleteTable(table1.getTableName());
        admin1.disableTable(table2.getTableName());
        admin1.deleteTable(table2.getTableName());
        admin1.deleteNamespace(NS1);
        admin1.deleteNamespace(NS2);
        Admin admin2 = UTIL2.getAdmin();
        admin2.disableTable(table1.getTableName());
        admin2.deleteTable(table1.getTableName());
        admin2.disableTable(table2.getTableName());
        admin2.deleteTable(table2.getTableName());
        admin2.deleteNamespace(NS1);
        admin2.deleteNamespace(NS2);
        Admin admin3 = UTIL3.getAdmin();
        admin3.disableTable(table1.getTableName());
        admin3.deleteTable(table1.getTableName());
        admin3.disableTable(table2.getTableName());
        admin3.deleteTable(table2.getTableName());
        admin3.deleteNamespace(NS1);
        admin3.deleteNamespace(NS2);
        Admin admin4 = UTIL4.getAdmin();
        admin4.disableTable(table1.getTableName());
        admin4.deleteTable(table1.getTableName());
        admin4.disableTable(table2.getTableName());
        admin4.deleteTable(table2.getTableName());
        admin4.deleteNamespace(NS1);
        admin4.deleteNamespace(NS2);
        UTIL1.getAdmin().removeReplicationPeer(PEER4_NS);
        UTIL1.getAdmin().removeReplicationPeer(PEER4_NS_TABLE);
    }

    @Override
    @Test
    public void testBulkLoadReplicationActiveActive() throws Exception {
        Table peer1TestTable = UTIL1.getConnection().getTable(TestReplicationBase.tableName);
        Table peer2TestTable = UTIL2.getConnection().getTable(TestReplicationBase.tableName);
        Table peer3TestTable = UTIL3.getConnection().getTable(TestReplicationBase.tableName);
        Table notPeerTable = UTIL4.getConnection().getTable(TestReplicationBase.tableName);
        Table ns1Table = UTIL4.getConnection().getTable(NS1_TABLE);
        Table ns2Table = UTIL4.getConnection().getTable(NS2_TABLE);
        byte[] row = Bytes.toBytes((String)"002_ns_peer");
        byte[] value = Bytes.toBytes((String)"v2");
        this.bulkLoadOnCluster(ns1Table.getName(), row, value, UTIL1);
        TestNamespaceReplicationWithBulkLoadedData.waitForReplication(ns1Table, 1, 50);
        this.assertTableHasValue(ns1Table, row, value);
        row = Bytes.toBytes((String)"003_ns_table_peer");
        value = Bytes.toBytes((String)"v2");
        this.bulkLoadOnCluster(ns2Table.getName(), row, value, UTIL1);
        TestNamespaceReplicationWithBulkLoadedData.waitForReplication(ns2Table, 1, 50);
        this.assertTableHasValue(ns2Table, row, value);
        row = Bytes.toBytes((String)"001_nopeer");
        value = Bytes.toBytes((String)"v1");
        this.assertBulkLoadConditions(tableName, row, value, UTIL1, peer1TestTable, peer2TestTable, peer3TestTable);
        this.assertTableNoValue(notPeerTable, row, value);
        MiniZooKeeperCluster zkCluster = UTIL1.getZkCluster();
        ZKWatcher watcher = new ZKWatcher(UTIL1.getConfiguration(), "TestZnodeHFiles-refs", null);
        RecoverableZooKeeper zk = RecoverableZooKeeper.connect((Configuration)UTIL1.getConfiguration(), (Watcher)watcher);
        ReplicationQueueStorage replicationQueueStorage = ReplicationStorageFactory.getReplicationQueueStorage((Connection)UTIL1.getConnection(), (Configuration)UTIL1.getConfiguration());
        Set hfiles = replicationQueueStorage.getAllHFileRefs();
        Assert.assertTrue((boolean)hfiles.isEmpty());
    }
}

