/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.replication.SyncReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestSyncReplicationStandbyKillMaster
extends SyncReplicationTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestSyncReplicationStandbyKillMaster.class);
    private final long SLEEP_TIME = 2000L;
    private final int COUNT = 1000;
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSyncReplicationStandbyKillMaster.class);

    @Test
    public void testStandbyKillMaster() throws Exception {
        MasterFileSystem mfs = UTIL2.getHBaseCluster().getMaster().getMasterFileSystem();
        Path remoteWALDir = this.getRemoteWALDir(mfs, PEER_ID);
        Assert.assertFalse((boolean)mfs.getWALFileSystem().exists(remoteWALDir));
        UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.STANDBY);
        Assert.assertTrue((boolean)mfs.getWALFileSystem().exists(remoteWALDir));
        UTIL1.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.ACTIVE);
        UTIL1.getAdmin().disableReplicationPeer(PEER_ID);
        this.write(UTIL1, 0, 1000);
        UTIL1.shutdownMiniCluster();
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(2000L);
                UTIL2.getMiniHBaseCluster().getMaster().stop("Stop master for test");
            }
            catch (Exception e) {
                LOG.error("Failed to stop master", (Throwable)e);
            }
        });
        t.start();
        try {
            UTIL2.getAdmin().transitReplicationPeerSyncReplicationState(PEER_ID, SyncReplicationState.DOWNGRADE_ACTIVE);
        }
        catch (Exception e) {
            LOG.error("Failed to transit standby cluster to " + SyncReplicationState.DOWNGRADE_ACTIVE);
        }
        while (UTIL2.getAdmin().getReplicationPeerSyncReplicationState(PEER_ID) != SyncReplicationState.DOWNGRADE_ACTIVE) {
            Thread.sleep(2000L);
        }
        this.verify(UTIL2, 0, 1000);
    }
}

