/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.replication.DisablePeerProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerImpl;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRefreshPeerWhileRegionServerRestarts
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRefreshPeerWhileRegionServerRestarts.class);
    private static CountDownLatch ARRIVE;
    private static CountDownLatch RESUME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestart() throws Exception {
        CountDownLatch arrive;
        UTIL1.getMiniHBaseCluster().getConfiguration().setClass("hbase.regionserver.impl", RegionServerForTest.class, HRegionServer.class);
        ARRIVE = arrive = new CountDownLatch(1);
        RESUME = new CountDownLatch(1);
        Future regionServerFuture = ForkJoinPool.commonPool().submit(() -> UTIL1.getMiniHBaseCluster().startRegionServer().getRegionServer());
        ARRIVE.await();
        Future future = hbaseAdmin.disableReplicationPeerAsync("2");
        try {
            UTIL1.waitFor(30000L, () -> {
                for (Procedure proc : UTIL1.getMiniHBaseCluster().getMaster().getProcedures()) {
                    if (!(proc instanceof DisablePeerProcedure)) continue;
                    return ((DisablePeerProcedure)proc).getCurrentStateId() == 8;
                }
                return false;
            });
        }
        finally {
            RESUME.countDown();
        }
        future.get();
        ReplicationPeerImpl peer = ((HRegionServer)regionServerFuture.get()).getReplicationSourceService().getReplicationPeers().getPeer("2");
        Assert.assertEquals((Object)ReplicationPeer.PeerState.DISABLED, (Object)peer.getPeerState());
    }

    public static final class RegionServerForTest
    extends HRegionServer {
        public RegionServerForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected void tryRegionServerReport(long reportStartTime, long reportEndTime) throws IOException {
            if (ARRIVE != null) {
                ARRIVE.countDown();
                ARRIVE = null;
                try {
                    RESUME.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.tryRegionServerReport(reportStartTime, reportEndTime);
        }
    }
}

