/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryStream;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryStreamTestBase;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;

public abstract class TestWALEntryStreamDifferentCounts
extends WALEntryStreamTestBase {
    @Parameterized.Parameter(value=0)
    public int nbRows;
    @Parameterized.Parameter(value=1)
    public int walEditKVs;
    @Parameterized.Parameter(value=2)
    public boolean isCompressionEnabled;

    @Parameterized.Parameters(name="{index}: nbRows={0}, walEditKVs={1}, isCompressionEnabled={2}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int nbRows : new int[]{1500, 60000}) {
            for (int walEditKVs : new int[]{1, 100}) {
                for (boolean isCompressionEnabled : new boolean[]{false, true}) {
                    params.add(new Object[]{nbRows, walEditKVs, isCompressionEnabled});
                }
            }
        }
        return params;
    }

    @Before
    public void setUp() throws IOException {
        CONF.setBoolean("hbase.regionserver.wal.enablecompression", this.isCompressionEnabled);
        this.initWAL();
    }

    @Test
    public void testDifferentCounts() throws Exception {
        this.mvcc.advanceTo(1L);
        for (int i = 0; i < this.nbRows; ++i) {
            this.appendToLogAndSync(this.walEditKVs);
        }
        this.log.rollWriter();
        try (WALEntryStream entryStream = new WALEntryStream(this.logQueue, (FileSystem)fs, CONF, 0L, (WALFileLengthProvider)this.log, new MetricsSource("1"), "fake-wal-group-id");){
            int i = 0;
            while (entryStream.hasNext() == WALEntryStream.HasNext.YES) {
                Assert.assertNotNull((Object)entryStream.next());
                ++i;
            }
            Assert.assertEquals((long)this.nbRows, (long)i);
            Assert.assertEquals((Object)WALEntryStream.HasNext.RETRY, (Object)entryStream.hasNext());
        }
    }
}

