/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminClient;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManagerImpl;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RSGroupProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RSGroupTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RSGroupTests.class, MediumTests.class})
public class TestMigrateRSGroupInfo
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMigrateRSGroupInfo.class);
    private static String TABLE_NAME_PREFIX = "Table_";
    private static int NUM_TABLES = 10;
    private static byte[] FAMILY = Bytes.toBytes((String)"family");
    private static RSGroupAdminClient RS_GROUP_ADMIN_CLIENT;
    private static CountDownLatch RESUME;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        TEST_UTIL.getConfiguration().setBoolean("hbase.balancer.rsgroup.enabled", false);
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName());
        TestMigrateRSGroupInfo.setUpTestBeforeClass();
        RS_GROUP_ADMIN_CLIENT = new RSGroupAdminClient(TEST_UTIL.getConnection());
        for (int i = 0; i < NUM_TABLES; ++i) {
            TEST_UTIL.createTable(TableName.valueOf((String)(TABLE_NAME_PREFIX + i)), FAMILY);
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestMigrateRSGroupInfo.tearDownAfterClass();
    }

    @Test
    public void testMigrate() throws IOException, InterruptedException {
        RSGroupInfo info;
        int i;
        String groupName = TestMigrateRSGroupInfo.getNameWithoutIndex(this.name.getMethodName());
        this.addGroup(groupName, TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads().size() - 1);
        RSGroupInfo rsGroupInfo = ADMIN.getRSGroup(groupName);
        Assert.assertTrue((boolean)rsGroupInfo.getTables().isEmpty());
        for (int i2 = 0; i2 < NUM_TABLES; ++i2) {
            rsGroupInfo.addTable(TableName.valueOf((String)(TABLE_NAME_PREFIX + i2)));
        }
        try (Table table = TEST_UTIL.getConnection().getTable(RSGroupInfoManagerImpl.RSGROUP_TABLE_NAME);){
            RSGroupProtos.RSGroupInfo proto = ProtobufUtil.toProtoGroupInfo((RSGroupInfo)rsGroupInfo);
            Put p = new Put(Bytes.toBytes((String)rsGroupInfo.getName()));
            p.addColumn(RSGroupInfoManagerImpl.META_FAMILY_BYTES, RSGroupInfoManagerImpl.META_QUALIFIER_BYTES, proto.toByteArray());
            table.put(p);
        }
        TEST_UTIL.getMiniHBaseCluster().stopMaster(0).join();
        RESUME = new CountDownLatch(1);
        TEST_UTIL.getMiniHBaseCluster().startMaster();
        TEST_UTIL.invalidateConnection();
        RS_GROUP_ADMIN_CLIENT = new RSGroupAdminClient(TEST_UTIL.getConnection());
        TEST_UTIL.waitFor(30000L, () -> {
            try {
                RS_GROUP_ADMIN_CLIENT.getRSGroupInfoOfTable(TableName.valueOf((String)(TABLE_NAME_PREFIX + 0)));
                return true;
            }
            catch (IOException e) {
                return false;
            }
        });
        for (i = 0; i < NUM_TABLES; ++i) {
            info = RS_GROUP_ADMIN_CLIENT.getRSGroupInfoOfTable(TableName.valueOf((String)(TABLE_NAME_PREFIX + i)));
            Assert.assertEquals((Object)rsGroupInfo.getName(), (Object)info.getName());
            Assert.assertEquals((long)NUM_TABLES, (long)info.getTables().size());
        }
        RESUME.countDown();
        TEST_UTIL.waitFor(60000L, () -> {
            for (int i = 0; i < NUM_TABLES; ++i) {
                TableDescriptor td;
                try {
                    td = TEST_UTIL.getAdmin().getDescriptor(TableName.valueOf((String)(TABLE_NAME_PREFIX + i)));
                }
                catch (IOException e) {
                    return false;
                }
                if (rsGroupInfo.getName().equals(td.getRegionServerGroup().orElse(null))) continue;
                return false;
            }
            return true;
        });
        TEST_UTIL.waitFor(30000L, () -> {
            try (Table table = TEST_UTIL.getConnection().getTable(RSGroupInfoManagerImpl.RSGROUP_TABLE_NAME);){
                Result result = table.get(new Get(Bytes.toBytes((String)rsGroupInfo.getName())));
                RSGroupProtos.RSGroupInfo proto = RSGroupProtos.RSGroupInfo.parseFrom((byte[])result.getValue(RSGroupInfoManagerImpl.META_FAMILY_BYTES, RSGroupInfoManagerImpl.META_QUALIFIER_BYTES));
                RSGroupInfo gi = ProtobufUtil.toGroupInfo((RSGroupProtos.RSGroupInfo)proto);
                boolean bl = gi.getTables().isEmpty();
                return bl;
            }
        });
        TEST_UTIL.waitFor(30000L, () -> Thread.getAllStackTraces().keySet().stream().noneMatch(t -> t.getName().equals("Migrate-RSGroup-Tables")));
        for (i = 0; i < NUM_TABLES; ++i) {
            info = RS_GROUP_ADMIN_CLIENT.getRSGroupInfoOfTable(TableName.valueOf((String)(TABLE_NAME_PREFIX + i)));
            Assert.assertEquals((Object)rsGroupInfo.getName(), (Object)info.getName());
            Assert.assertEquals((long)NUM_TABLES, (long)info.getTables().size());
        }
    }

    static {
        RESUME = new CountDownLatch(1);
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException, KeeperException {
            super(conf);
        }

        public TableDescriptors getTableDescriptors() {
            if (RESUME != null) {
                for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                    if (!element.getMethodName().equals("migrate")) continue;
                    try {
                        RESUME.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    RESUME = null;
                    break;
                }
            }
            return super.getTableDescriptors();
        }
    }
}

