/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.LogEntry;
import org.apache.hadoop.hbase.client.NormalizeTableFilterParams;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ServerType;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotView;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManagerImpl;
import org.apache.hadoop.hbase.rsgroup.RSGroupUtil;
import org.apache.hadoop.hbase.security.access.GetUserPermissionsRequest;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RSGroupProtos;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;

@InterfaceAudience.Private
public class VerifyingRSGroupAdmin
implements Admin,
Closeable {
    private final Connection conn;
    private final Admin admin;
    private final ZKWatcher zkw;

    public VerifyingRSGroupAdmin(Configuration conf) throws IOException {
        this.conn = ConnectionFactory.createConnection((Configuration)conf);
        this.admin = this.conn.getAdmin();
        this.zkw = new ZKWatcher(conf, this.getClass().getSimpleName(), null);
    }

    public int getOperationTimeout() {
        return this.admin.getOperationTimeout();
    }

    public int getSyncWaitTimeout() {
        return this.admin.getSyncWaitTimeout();
    }

    public void abort(String why, Throwable e) {
        this.admin.abort(why, e);
    }

    public boolean isAborted() {
        return this.admin.isAborted();
    }

    public Connection getConnection() {
        return this.admin.getConnection();
    }

    public boolean tableExists(TableName tableName) throws IOException {
        return this.admin.tableExists(tableName);
    }

    public List<TableDescriptor> listTableDescriptors() throws IOException {
        return this.admin.listTableDescriptors();
    }

    public List<TableDescriptor> listTableDescriptors(boolean includeSysTables) throws IOException {
        return this.admin.listTableDescriptors(includeSysTables);
    }

    public List<TableDescriptor> listTableDescriptors(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.admin.listTableDescriptors(pattern, includeSysTables);
    }

    public List<TableDescriptor> listTableDescriptorsByState(boolean isEnabled) throws IOException {
        return this.admin.listTableDescriptorsByState(isEnabled);
    }

    public TableName[] listTableNames() throws IOException {
        return this.admin.listTableNames();
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.admin.listTableNames(pattern, includeSysTables);
    }

    public List<TableName> listTableNamesByState(boolean isEnabled) throws IOException {
        return this.admin.listTableNamesByState(isEnabled);
    }

    public TableDescriptor getDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        return this.admin.getDescriptor(tableName);
    }

    public void createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        this.admin.createTable(desc, startKey, endKey, numRegions);
    }

    public Future<Void> createTableAsync(TableDescriptor desc) throws IOException {
        return this.admin.createTableAsync(desc);
    }

    public Future<Void> createTableAsync(TableDescriptor desc, byte[][] splitKeys) throws IOException {
        return this.admin.createTableAsync(desc, splitKeys);
    }

    public Future<Void> deleteTableAsync(TableName tableName) throws IOException {
        return this.admin.deleteTableAsync(tableName);
    }

    public Future<Void> truncateTableAsync(TableName tableName, boolean preserveSplits) throws IOException {
        return this.admin.truncateTableAsync(tableName, preserveSplits);
    }

    public Future<Void> enableTableAsync(TableName tableName) throws IOException {
        return this.admin.enableTableAsync(tableName);
    }

    public Future<Void> disableTableAsync(TableName tableName) throws IOException {
        return this.admin.disableTableAsync(tableName);
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.admin.isTableEnabled(tableName);
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.admin.isTableDisabled(tableName);
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.admin.isTableAvailable(tableName);
    }

    public Future<Void> addColumnFamilyAsync(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        return this.admin.addColumnFamilyAsync(tableName, columnFamily);
    }

    public Future<Void> deleteColumnFamilyAsync(TableName tableName, byte[] columnFamily) throws IOException {
        return this.admin.deleteColumnFamilyAsync(tableName, columnFamily);
    }

    public Future<Void> modifyColumnFamilyAsync(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        return this.admin.modifyColumnFamilyAsync(tableName, columnFamily);
    }

    public List<RegionInfo> getRegions(ServerName serverName) throws IOException {
        return this.admin.getRegions(serverName);
    }

    public void flush(TableName tableName) throws IOException {
        this.admin.flush(tableName);
    }

    public void flush(TableName tableName, byte[] columnFamily) throws IOException {
        this.admin.flush(tableName, columnFamily);
    }

    public void flush(TableName tableName, List<byte[]> columnFamilies) throws IOException {
        this.admin.flush(tableName, columnFamilies);
    }

    public void flushRegion(byte[] regionName) throws IOException {
        this.admin.flushRegion(regionName);
    }

    public void flushRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.admin.flushRegion(regionName, columnFamily);
    }

    public void flushRegionServer(ServerName serverName) throws IOException {
        this.admin.flushRegionServer(serverName);
    }

    public void compact(TableName tableName) throws IOException {
        this.admin.compact(tableName);
    }

    public void compactRegion(byte[] regionName) throws IOException {
        this.admin.compactRegion(regionName);
    }

    public void compact(TableName tableName, byte[] columnFamily) throws IOException {
        this.admin.compact(tableName, columnFamily);
    }

    public void compactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.admin.compactRegion(regionName, columnFamily);
    }

    public void compact(TableName tableName, CompactType compactType) throws IOException, InterruptedException {
        this.admin.compact(tableName, compactType);
    }

    public void compact(TableName tableName, byte[] columnFamily, CompactType compactType) throws IOException, InterruptedException {
        this.admin.compact(tableName, columnFamily, compactType);
    }

    public void majorCompact(TableName tableName) throws IOException {
        this.admin.majorCompact(tableName);
    }

    public void majorCompactRegion(byte[] regionName) throws IOException {
        this.admin.majorCompactRegion(regionName);
    }

    public void majorCompact(TableName tableName, byte[] columnFamily) throws IOException {
        this.admin.majorCompact(tableName, columnFamily);
    }

    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.admin.majorCompactRegion(regionName, columnFamily);
    }

    public void majorCompact(TableName tableName, CompactType compactType) throws IOException, InterruptedException {
        this.admin.majorCompact(tableName, compactType);
    }

    public void majorCompact(TableName tableName, byte[] columnFamily, CompactType compactType) throws IOException, InterruptedException {
        this.admin.majorCompact(tableName, columnFamily, compactType);
    }

    public Map<ServerName, Boolean> compactionSwitch(boolean switchState, List<String> serverNamesList) throws IOException {
        return this.admin.compactionSwitch(switchState, serverNamesList);
    }

    public void compactRegionServer(ServerName serverName) throws IOException {
        this.admin.compactRegionServer(serverName);
    }

    public void majorCompactRegionServer(ServerName serverName) throws IOException {
        this.admin.majorCompactRegionServer(serverName);
    }

    public void move(byte[] encodedRegionName) throws IOException {
        this.admin.move(encodedRegionName);
    }

    public void move(byte[] encodedRegionName, ServerName destServerName) throws IOException {
        this.admin.move(encodedRegionName, destServerName);
    }

    public void assign(byte[] regionName) throws IOException {
        this.admin.assign(regionName);
    }

    public void unassign(byte[] regionName) throws IOException {
        this.admin.unassign(regionName);
    }

    public void offline(byte[] regionName) throws IOException {
        this.admin.offline(regionName);
    }

    public boolean balancerSwitch(boolean onOrOff, boolean synchronous) throws IOException {
        return this.admin.balancerSwitch(onOrOff, synchronous);
    }

    public BalanceResponse balance(BalanceRequest request) throws IOException {
        return this.admin.balance(request);
    }

    public boolean isBalancerEnabled() throws IOException {
        return this.admin.isBalancerEnabled();
    }

    public CacheEvictionStats clearBlockCache(TableName tableName) throws IOException {
        return this.admin.clearBlockCache(tableName);
    }

    public boolean normalize(NormalizeTableFilterParams ntfp) throws IOException {
        return this.admin.normalize(ntfp);
    }

    public boolean isNormalizerEnabled() throws IOException {
        return this.admin.isNormalizerEnabled();
    }

    public boolean normalizerSwitch(boolean on) throws IOException {
        return this.admin.normalizerSwitch(on);
    }

    public boolean catalogJanitorSwitch(boolean onOrOff) throws IOException {
        return this.admin.catalogJanitorSwitch(onOrOff);
    }

    public int runCatalogJanitor() throws IOException {
        return this.admin.runCatalogJanitor();
    }

    public boolean isCatalogJanitorEnabled() throws IOException {
        return this.admin.isCatalogJanitorEnabled();
    }

    public boolean cleanerChoreSwitch(boolean onOrOff) throws IOException {
        return this.admin.cleanerChoreSwitch(onOrOff);
    }

    public boolean runCleanerChore() throws IOException {
        return this.admin.runCleanerChore();
    }

    public boolean isCleanerChoreEnabled() throws IOException {
        return this.admin.isCleanerChoreEnabled();
    }

    public Future<Void> mergeRegionsAsync(byte[][] nameofRegionsToMerge, boolean forcible) throws IOException {
        return this.admin.mergeRegionsAsync(nameofRegionsToMerge, forcible);
    }

    public void split(TableName tableName) throws IOException {
        this.admin.split(tableName);
    }

    public void split(TableName tableName, byte[] splitPoint) throws IOException {
        this.admin.split(tableName, splitPoint);
    }

    public Future<Void> splitRegionAsync(byte[] regionName) throws IOException {
        return this.admin.splitRegionAsync(regionName);
    }

    public Future<Void> splitRegionAsync(byte[] regionName, byte[] splitPoint) throws IOException {
        return this.admin.splitRegionAsync(regionName, splitPoint);
    }

    public void truncateRegion(byte[] regionName) throws IOException {
        this.admin.truncateRegion(regionName);
    }

    public Future<Void> truncateRegionAsync(byte[] regionName) throws IOException {
        return this.admin.truncateRegionAsync(regionName);
    }

    public Future<Void> modifyTableAsync(TableDescriptor td) throws IOException {
        return this.modifyTableAsync(td, true);
    }

    public Future<Void> modifyTableAsync(TableDescriptor td, boolean reopenRegions) throws IOException {
        return this.admin.modifyTableAsync(td, reopenRegions);
    }

    public void shutdown() throws IOException {
        this.admin.shutdown();
    }

    public void stopMaster() throws IOException {
        this.admin.stopMaster();
    }

    public boolean isMasterInMaintenanceMode() throws IOException {
        return this.admin.isMasterInMaintenanceMode();
    }

    public void stopRegionServer(String hostnamePort) throws IOException {
        this.admin.stopRegionServer(hostnamePort);
    }

    public ClusterMetrics getClusterMetrics(EnumSet<ClusterMetrics.Option> options) throws IOException {
        return this.admin.getClusterMetrics(options);
    }

    public List<RegionMetrics> getRegionMetrics(ServerName serverName) throws IOException {
        return this.admin.getRegionMetrics(serverName);
    }

    public List<RegionMetrics> getRegionMetrics(ServerName serverName, TableName tableName) throws IOException {
        return this.admin.getRegionMetrics(serverName, tableName);
    }

    public Configuration getConfiguration() {
        return this.admin.getConfiguration();
    }

    public Future<Void> createNamespaceAsync(NamespaceDescriptor descriptor) throws IOException {
        return this.admin.createNamespaceAsync(descriptor);
    }

    public Future<Void> modifyNamespaceAsync(NamespaceDescriptor descriptor) throws IOException {
        return this.admin.modifyNamespaceAsync(descriptor);
    }

    public Future<Void> deleteNamespaceAsync(String name) throws IOException {
        return this.admin.deleteNamespaceAsync(name);
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        return this.admin.getNamespaceDescriptor(name);
    }

    public String[] listNamespaces() throws IOException {
        return this.admin.listNamespaces();
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        return this.admin.listNamespaceDescriptors();
    }

    public List<TableDescriptor> listTableDescriptorsByNamespace(byte[] name) throws IOException {
        return this.admin.listTableDescriptorsByNamespace(name);
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        return this.admin.listTableNamesByNamespace(name);
    }

    public List<RegionInfo> getRegions(TableName tableName) throws IOException {
        return this.admin.getRegions(tableName);
    }

    @Override
    public void close() {
        this.admin.close();
    }

    public List<TableDescriptor> listTableDescriptors(List<TableName> tableNames) throws IOException {
        return this.admin.listTableDescriptors(tableNames);
    }

    public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) throws IOException {
        return this.admin.abortProcedureAsync(procId, mayInterruptIfRunning);
    }

    public String getProcedures() throws IOException {
        return this.admin.getProcedures();
    }

    public String getLocks() throws IOException {
        return this.admin.getLocks();
    }

    public void rollWALWriter(ServerName serverName) throws IOException, FailedLogCloseException {
        this.admin.rollWALWriter(serverName);
    }

    public CompactionState getCompactionState(TableName tableName) throws IOException {
        return this.admin.getCompactionState(tableName);
    }

    public CompactionState getCompactionState(TableName tableName, CompactType compactType) throws IOException {
        return this.admin.getCompactionState(tableName, compactType);
    }

    public CompactionState getCompactionStateForRegion(byte[] regionName) throws IOException {
        return this.admin.getCompactionStateForRegion(regionName);
    }

    public long getLastMajorCompactionTimestamp(TableName tableName) throws IOException {
        return this.admin.getLastMajorCompactionTimestamp(tableName);
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
        return this.admin.getLastMajorCompactionTimestampForRegion(regionName);
    }

    public void snapshot(SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.admin.snapshot(snapshot);
    }

    public Future<Void> snapshotAsync(SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        return this.admin.snapshotAsync(snapshot);
    }

    public boolean isSnapshotFinished(SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        return this.admin.isSnapshotFinished(snapshot);
    }

    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        this.admin.restoreSnapshot(snapshotName);
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot, boolean restoreAcl) throws IOException, RestoreSnapshotException {
        this.admin.restoreSnapshot(snapshotName, takeFailSafeSnapshot, restoreAcl);
    }

    public Future<Void> cloneSnapshotAsync(String snapshotName, TableName tableName, boolean restoreAcl, String customSFT) throws IOException, TableExistsException, RestoreSnapshotException {
        return this.admin.cloneSnapshotAsync(snapshotName, tableName, restoreAcl, customSFT);
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        this.admin.execProcedure(signature, instance, props);
    }

    public byte[] execProcedureWithReturn(String signature, String instance, Map<String, String> props) throws IOException {
        return this.admin.execProcedureWithReturn(signature, instance, props);
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        return this.admin.isProcedureFinished(signature, instance, props);
    }

    public List<SnapshotDescription> listSnapshots() throws IOException {
        return this.admin.listSnapshots();
    }

    public List<SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        return this.admin.listSnapshots(pattern);
    }

    public List<SnapshotDescription> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        return this.admin.listTableSnapshots(tableNamePattern, snapshotNamePattern);
    }

    public void deleteSnapshot(String snapshotName) throws IOException {
        this.admin.deleteSnapshot(snapshotName);
    }

    public void deleteSnapshots(Pattern pattern) throws IOException {
        this.admin.deleteSnapshots(pattern);
    }

    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        this.admin.deleteTableSnapshots(tableNamePattern, snapshotNamePattern);
    }

    public void setQuota(QuotaSettings quota) throws IOException {
        this.admin.setQuota(quota);
    }

    public List<QuotaSettings> getQuota(QuotaFilter filter) throws IOException {
        return this.admin.getQuota(filter);
    }

    public CoprocessorRpcChannel coprocessorService() {
        return this.admin.coprocessorService();
    }

    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        return this.admin.coprocessorService(serverName);
    }

    public void updateConfiguration(ServerName server) throws IOException {
        this.admin.updateConfiguration(server);
    }

    public void updateConfiguration() throws IOException {
        this.admin.updateConfiguration();
    }

    public void updateConfiguration(String groupName) throws IOException {
        this.admin.updateConfiguration(groupName);
    }

    public List<SecurityCapability> getSecurityCapabilities() throws IOException {
        return this.admin.getSecurityCapabilities();
    }

    public boolean splitSwitch(boolean enabled, boolean synchronous) throws IOException {
        return this.admin.splitSwitch(enabled, synchronous);
    }

    public boolean mergeSwitch(boolean enabled, boolean synchronous) throws IOException {
        return this.admin.mergeSwitch(enabled, synchronous);
    }

    public boolean isSplitEnabled() throws IOException {
        return this.admin.isSplitEnabled();
    }

    public boolean isMergeEnabled() throws IOException {
        return this.admin.isMergeEnabled();
    }

    public Future<Void> addReplicationPeerAsync(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) throws IOException {
        return this.admin.addReplicationPeerAsync(peerId, peerConfig, enabled);
    }

    public Future<Void> removeReplicationPeerAsync(String peerId) throws IOException {
        return this.admin.removeReplicationPeerAsync(peerId);
    }

    public Future<Void> enableReplicationPeerAsync(String peerId) throws IOException {
        return this.admin.enableReplicationPeerAsync(peerId);
    }

    public Future<Void> disableReplicationPeerAsync(String peerId) throws IOException {
        return this.admin.disableReplicationPeerAsync(peerId);
    }

    public ReplicationPeerConfig getReplicationPeerConfig(String peerId) throws IOException {
        return this.admin.getReplicationPeerConfig(peerId);
    }

    public Future<Void> updateReplicationPeerConfigAsync(String peerId, ReplicationPeerConfig peerConfig) throws IOException {
        return this.admin.updateReplicationPeerConfigAsync(peerId, peerConfig);
    }

    public List<ReplicationPeerDescription> listReplicationPeers() throws IOException {
        return this.admin.listReplicationPeers();
    }

    public List<ReplicationPeerDescription> listReplicationPeers(Pattern pattern) throws IOException {
        return this.admin.listReplicationPeers(pattern);
    }

    public Future<Void> transitReplicationPeerSyncReplicationStateAsync(String peerId, SyncReplicationState state) throws IOException {
        return this.admin.transitReplicationPeerSyncReplicationStateAsync(peerId, state);
    }

    public boolean isReplicationPeerEnabled(String peerId) throws IOException {
        return this.admin.isReplicationPeerEnabled(peerId);
    }

    public void decommissionRegionServers(List<ServerName> servers, boolean offload) throws IOException {
        this.admin.decommissionRegionServers(servers, offload);
    }

    public List<ServerName> listDecommissionedRegionServers() throws IOException {
        return this.admin.listDecommissionedRegionServers();
    }

    public void recommissionRegionServer(ServerName server, List<byte[]> encodedRegionNames) throws IOException {
        this.admin.recommissionRegionServer(server, encodedRegionNames);
    }

    public List<TableCFs> listReplicatedTableCFs() throws IOException {
        return this.admin.listReplicatedTableCFs();
    }

    public void enableTableReplication(TableName tableName) throws IOException {
        this.admin.enableTableReplication(tableName);
    }

    public void disableTableReplication(TableName tableName) throws IOException {
        this.admin.disableTableReplication(tableName);
    }

    public void clearCompactionQueues(ServerName serverName, Set<String> queues) throws IOException, InterruptedException {
        this.admin.clearCompactionQueues(serverName, queues);
    }

    public List<ServerName> clearDeadServers(List<ServerName> servers) throws IOException {
        return this.admin.clearDeadServers(servers);
    }

    public void cloneTableSchema(TableName tableName, TableName newTableName, boolean preserveSplits) throws IOException {
        this.admin.cloneTableSchema(tableName, newTableName, preserveSplits);
    }

    public boolean switchRpcThrottle(boolean enable) throws IOException {
        return this.admin.switchRpcThrottle(enable);
    }

    public boolean isRpcThrottleEnabled() throws IOException {
        return this.admin.isRpcThrottleEnabled();
    }

    public boolean exceedThrottleQuotaSwitch(boolean enable) throws IOException {
        return this.admin.exceedThrottleQuotaSwitch(enable);
    }

    public Map<TableName, Long> getSpaceQuotaTableSizes() throws IOException {
        return this.admin.getSpaceQuotaTableSizes();
    }

    public Map<TableName, ? extends SpaceQuotaSnapshotView> getRegionServerSpaceQuotaSnapshots(ServerName serverName) throws IOException {
        return this.admin.getRegionServerSpaceQuotaSnapshots(serverName);
    }

    public SpaceQuotaSnapshotView getCurrentSpaceQuotaSnapshot(String namespace) throws IOException {
        return this.admin.getCurrentSpaceQuotaSnapshot(namespace);
    }

    public SpaceQuotaSnapshotView getCurrentSpaceQuotaSnapshot(TableName tableName) throws IOException {
        return this.admin.getCurrentSpaceQuotaSnapshot(tableName);
    }

    public void grant(UserPermission userPermission, boolean mergeExistingPermissions) throws IOException {
        this.admin.grant(userPermission, mergeExistingPermissions);
    }

    public void revoke(UserPermission userPermission) throws IOException {
        this.admin.revoke(userPermission);
    }

    public List<UserPermission> getUserPermissions(GetUserPermissionsRequest getUserPermissionsRequest) throws IOException {
        return this.admin.getUserPermissions(getUserPermissionsRequest);
    }

    public List<Boolean> hasUserPermissions(String userName, List<Permission> permissions) throws IOException {
        return this.admin.hasUserPermissions(userName, permissions);
    }

    public boolean snapshotCleanupSwitch(boolean on, boolean synchronous) throws IOException {
        return this.admin.snapshotCleanupSwitch(on, synchronous);
    }

    public boolean isSnapshotCleanupEnabled() throws IOException {
        return this.admin.isSnapshotCleanupEnabled();
    }

    public void addRSGroup(String groupName) throws IOException {
        this.admin.addRSGroup(groupName);
        this.verify();
    }

    public RSGroupInfo getRSGroup(String groupName) throws IOException {
        return this.admin.getRSGroup(groupName);
    }

    public RSGroupInfo getRSGroup(Address hostPort) throws IOException {
        return this.admin.getRSGroup(hostPort);
    }

    public RSGroupInfo getRSGroup(TableName tableName) throws IOException {
        return this.admin.getRSGroup(tableName);
    }

    public List<RSGroupInfo> listRSGroups() throws IOException {
        return this.admin.listRSGroups();
    }

    public List<TableName> listTablesInRSGroup(String groupName) throws IOException {
        return this.admin.listTablesInRSGroup(groupName);
    }

    public Pair<List<String>, List<TableName>> getConfiguredNamespacesAndTablesInRSGroup(String groupName) throws IOException {
        return this.admin.getConfiguredNamespacesAndTablesInRSGroup(groupName);
    }

    public void removeRSGroup(String groupName) throws IOException {
        this.admin.removeRSGroup(groupName);
        this.verify();
    }

    public void removeServersFromRSGroup(Set<Address> servers) throws IOException {
        this.admin.removeServersFromRSGroup(servers);
        this.verify();
    }

    public void moveServersToRSGroup(Set<Address> servers, String targetGroup) throws IOException {
        this.admin.moveServersToRSGroup(servers, targetGroup);
        this.verify();
    }

    public void setRSGroup(Set<TableName> tables, String groupName) throws IOException {
        this.admin.setRSGroup(tables, groupName);
        this.verify();
    }

    public BalanceResponse balanceRSGroup(String groupName, BalanceRequest request) throws IOException {
        return this.admin.balanceRSGroup(groupName, request);
    }

    public void renameRSGroup(String oldName, String newName) throws IOException {
        this.admin.renameRSGroup(oldName, newName);
        this.verify();
    }

    public void updateRSGroupConfig(String groupName, Map<String, String> configuration) throws IOException {
        this.admin.updateRSGroupConfig(groupName, configuration);
        this.verify();
    }

    public List<LogEntry> getLogEntries(Set<ServerName> serverNames, String logType, ServerType serverType, int limit, Map<String, Object> filterParams) throws IOException {
        return this.admin.getLogEntries(serverNames, logType, serverType, limit, filterParams);
    }

    private void verify() throws IOException {
        RSGroupInfo rsGroupInfo;
        Object sn2;
        HashMap groupMap = Maps.newHashMap();
        HashSet zList = Sets.newHashSet();
        ArrayList tds = new ArrayList();
        Admin admin = this.conn.getAdmin();
        Iterator iterator = null;
        try {
            tds.addAll(admin.listTableDescriptors());
            tds.addAll(admin.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME));
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (admin != null) {
                if (iterator != null) {
                    try {
                        admin.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    admin.close();
                }
            }
        }
        TreeSet lives = Sets.newTreeSet();
        for (Object sn2 : this.conn.getAdmin().getClusterMetrics().getLiveServerMetrics().keySet()) {
            lives.add(sn2.getAddress());
        }
        for (Object sn2 : this.conn.getAdmin().listDecommissionedRegionServers()) {
            lives.remove(sn2.getAddress());
        }
        Table table = this.conn.getTable(RSGroupInfoManagerImpl.RSGROUP_TABLE_NAME);
        sn2 = null;
        try (ResultScanner scanner2 = table.getScanner(new Scan());){
            Result result;
            block33: while ((result = scanner2.next()) != null) {
                RSGroupProtos.RSGroupInfo proto = RSGroupProtos.RSGroupInfo.parseFrom((byte[])result.getValue(RSGroupInfoManagerImpl.META_FAMILY_BYTES, RSGroupInfoManagerImpl.META_QUALIFIER_BYTES));
                rsGroupInfo = ProtobufUtil.toGroupInfo((RSGroupProtos.RSGroupInfo)proto);
                groupMap.put(proto.getName(), RSGroupUtil.fillTables((RSGroupInfo)rsGroupInfo, tds));
                Iterator iterator2 = rsGroupInfo.getServers().iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block33;
                    Address address = (Address)iterator2.next();
                    lives.remove(address);
                }
                break;
            }
        }
        catch (Throwable scanner2) {
            sn2 = scanner2;
            throw scanner2;
        }
        finally {
            if (table != null) {
                if (sn2 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable scanner2) {
                        ((Throwable)sn2).addSuppressed(scanner2);
                    }
                } else {
                    table.close();
                }
            }
        }
        TreeSet tables = Sets.newTreeSet();
        for (TableDescriptor td : this.conn.getAdmin().listTableDescriptors(Pattern.compile(".*"), true)) {
            String groupName = td.getRegionServerGroup().orElse("default");
            if (!groupName.equals("default")) continue;
            tables.add(td.getTableName());
        }
        groupMap.put("default", new RSGroupInfo("default", (Set)lives, (Set)tables));
        Assert.assertEquals((Object)Sets.newHashSet(groupMap.values()), (Object)Sets.newHashSet((Iterable)this.admin.listRSGroups()));
        try {
            String groupBasePath = ZNodePaths.joinZNode((String)this.zkw.getZNodePaths().baseZNode, (String[])new String[]{"rsgroup"});
            for (String znode : ZKUtil.listChildrenNoWatch((ZKWatcher)this.zkw, (String)groupBasePath)) {
                byte[] data = ZKUtil.getData((ZKWatcher)this.zkw, (String)ZNodePaths.joinZNode((String)groupBasePath, (String[])new String[]{znode}));
                if (data.length <= 0) continue;
                ProtobufUtil.expectPBMagicPrefix((byte[])data);
                ByteArrayInputStream bis = new ByteArrayInputStream(data, ProtobufUtil.lengthOfPBMagic(), data.length);
                rsGroupInfo = ProtobufUtil.toGroupInfo((RSGroupProtos.RSGroupInfo)RSGroupProtos.RSGroupInfo.parseFrom((InputStream)bis));
                zList.add(RSGroupUtil.fillTables((RSGroupInfo)rsGroupInfo, tds));
            }
            groupMap.remove("default");
            Assert.assertEquals((long)zList.size(), (long)groupMap.size());
            for (RSGroupInfo rsGroupInfo2 : zList) {
                Assert.assertTrue((boolean)((RSGroupInfo)groupMap.get(rsGroupInfo2.getName())).equals((Object)rsGroupInfo2));
            }
        }
        catch (KeeperException e) {
            throw new IOException("ZK verification failed", e);
        }
        catch (DeserializationException e) {
            throw new IOException("ZK verification failed", e);
        }
        catch (InterruptedException e) {
            throw new IOException("ZK verification failed", e);
        }
    }

    public List<Boolean> clearSlowLogResponses(Set<ServerName> serverNames) throws IOException {
        return this.admin.clearSlowLogResponses(serverNames);
    }

    public Future<Void> modifyColumnFamilyStoreFileTrackerAsync(TableName tableName, byte[] family, String dstSFT) throws IOException {
        return this.admin.modifyColumnFamilyStoreFileTrackerAsync(tableName, family, dstSFT);
    }

    public Future<Void> modifyTableStoreFileTrackerAsync(TableName tableName, String dstSFT) throws IOException {
        return this.admin.modifyTableStoreFileTrackerAsync(tableName, dstSFT);
    }

    public void flushMasterStore() throws IOException {
        this.admin.flushMasterStore();
    }

    public List<String> getCachedFilesList(ServerName serverName) throws IOException {
        return this.admin.getCachedFilesList(serverName);
    }

    public boolean replicationPeerModificationSwitch(boolean on, boolean drainProcedures) throws IOException {
        return this.admin.replicationPeerModificationSwitch(on, drainProcedures);
    }

    public boolean isReplicationPeerModificationEnabled() throws IOException {
        return this.admin.isReplicationPeerModificationEnabled();
    }
}

