/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestScanEarlyTermination
extends SecureTestUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScanEarlyTermination.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestScanEarlyTermination.class);
    @Rule
    public TableNameTestRule testTable = new TableNameTestRule();
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();
    private static final byte[] TEST_FAMILY1 = Bytes.toBytes((String)"f1");
    private static final byte[] TEST_FAMILY2 = Bytes.toBytes((String)"f2");
    private static final byte[] TEST_ROW = Bytes.toBytes((String)"testrow");
    private static final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
    private static final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
    private static final byte[] ZERO = Bytes.toBytes((long)0L);
    private static Configuration conf;
    private static User USER_OWNER;
    private static User USER_OTHER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.metahandler.count", 10);
        TestScanEarlyTermination.enableSecurity(conf);
        TestScanEarlyTermination.verifyConfiguration(conf);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        AccessController ac = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        cpHost.createEnvironment((MasterCoprocessor)ac, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost();
        rsHost.createEnvironment((RegionServerCoprocessor)ac, 0, 1, conf);
        TEST_UTIL.waitTableEnabled(PermissionStorage.ACL_TABLE_NAME);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_OTHER = User.createUserForTesting((Configuration)conf, (String)"other", (String[])new String[0]);
        TestScanEarlyTermination.grantGlobal(TEST_UTIL, USER_OWNER.getShortName(), Permission.Action.CREATE);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)this.testTable.getTableName()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])TEST_FAMILY1).setMaxVersions(10).build()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])TEST_FAMILY2).setMaxVersions(10).build()).setValue("hbase.security.access.early_out", "true").build();
        TestScanEarlyTermination.createTable(TEST_UTIL, USER_OWNER, tableDescriptor);
        TEST_UTIL.waitUntilAllRegionsAssigned(this.testTable.getTableName());
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.testTable.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info("Test deleted table " + this.testTable.getTableName());
        }
        Assert.assertEquals((long)0L, (long)PermissionStorage.getTablePermissions((Configuration)conf, (TableName)this.testTable.getTableName()).size());
    }

    @Test
    public void testEarlyScanTermination() throws Exception {
        TestScanEarlyTermination.grantOnTable(TEST_UTIL, USER_OTHER.getShortName(), this.testTable.getTableName(), TEST_FAMILY1, null, Permission.Action.READ);
        TestScanEarlyTermination.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Configuration configuration = conf;
                TEST_UTIL;
                configuration.set("testkey", HBaseTestingUtil.getRandomUUID().toString());
                Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                Table t = connection.getTable(TestScanEarlyTermination.this.testTable.getTableName());
                try {
                    Put put = new Put(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1, ZERO);
                    t.put(put);
                    put = new Put(TEST_ROW).addColumn(TEST_FAMILY2, TEST_Q1, ZERO);
                    put.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(put);
                    put = new Put(TEST_ROW).addColumn(TEST_FAMILY2, TEST_Q2, ZERO);
                    put.setACL(USER_OTHER.getShortName(), new Permission());
                    t.put(put);
                }
                finally {
                    t.close();
                    connection.close();
                }
                return null;
            }
        }, USER_OWNER);
        TestScanEarlyTermination.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Configuration configuration = conf;
                TEST_UTIL;
                configuration.set("testkey", HBaseTestingUtil.getRandomUUID().toString());
                Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                Table t = connection.getTable(TestScanEarlyTermination.this.testTable.getTableName());
                try {
                    Scan scan = new Scan().addFamily(TEST_FAMILY1);
                    Result result = t.getScanner(scan).next();
                    if (result != null) {
                        Assert.assertTrue((String)"Improper exclusion", (boolean)result.containsColumn(TEST_FAMILY1, TEST_Q1));
                        Assert.assertFalse((String)"Improper inclusion", (boolean)result.containsColumn(TEST_FAMILY2, TEST_Q1));
                        List list = result.listCells();
                        return list;
                    }
                    Object var5_6 = null;
                    return var5_6;
                }
                finally {
                    t.close();
                    connection.close();
                }
            }
        }, USER_OTHER);
        TestScanEarlyTermination.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Configuration configuration = conf;
                TEST_UTIL;
                configuration.set("testkey", HBaseTestingUtil.getRandomUUID().toString());
                Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                Table t = connection.getTable(TestScanEarlyTermination.this.testTable.getTableName());
                try {
                    Scan scan = new Scan();
                    Result result = t.getScanner(scan).next();
                    if (result != null) {
                        Assert.assertTrue((String)"Improper exclusion", (boolean)result.containsColumn(TEST_FAMILY1, TEST_Q1));
                        Assert.assertFalse((String)"Improper inclusion", (boolean)result.containsColumn(TEST_FAMILY2, TEST_Q1));
                        List list = result.listCells();
                        return list;
                    }
                    Object var5_6 = null;
                    return var5_6;
                }
                finally {
                    t.close();
                    connection.close();
                }
            }
        }, USER_OTHER);
        TestScanEarlyTermination.verifyDenied(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Configuration configuration = conf;
                TEST_UTIL;
                configuration.set("testkey", HBaseTestingUtil.getRandomUUID().toString());
                Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                Table t = connection.getTable(TestScanEarlyTermination.this.testTable.getTableName());
                try {
                    Scan scan = new Scan().addFamily(TEST_FAMILY2);
                    Result result = t.getScanner(scan).next();
                    if (result != null) {
                        List list = result.listCells();
                        return list;
                    }
                    Object var5_6 = null;
                    return var5_6;
                }
                finally {
                    t.close();
                    connection.close();
                }
            }
        }, USER_OTHER);
        TestScanEarlyTermination.grantOnTable(TEST_UTIL, USER_OTHER.getShortName(), this.testTable.getTableName(), TEST_FAMILY2, TEST_Q2, Permission.Action.READ);
        TestScanEarlyTermination.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Configuration configuration = conf;
                TEST_UTIL;
                configuration.set("testkey", HBaseTestingUtil.getRandomUUID().toString());
                Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                Table t = connection.getTable(TestScanEarlyTermination.this.testTable.getTableName());
                try {
                    Scan scan = new Scan();
                    Result result = t.getScanner(scan).next();
                    if (result != null) {
                        Assert.assertTrue((String)"Improper exclusion", (boolean)result.containsColumn(TEST_FAMILY1, TEST_Q1));
                        Assert.assertFalse((String)"Improper inclusion", (boolean)result.containsColumn(TEST_FAMILY2, TEST_Q1));
                        Assert.assertTrue((String)"Improper exclusion", (boolean)result.containsColumn(TEST_FAMILY2, TEST_Q2));
                        List list = result.listCells();
                        return list;
                    }
                    Object var5_6 = null;
                    return var5_6;
                }
                finally {
                    t.close();
                    connection.close();
                }
            }
        }, USER_OTHER);
    }
}

