/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AuthManager;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestTablePermissions {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTablePermissions.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestTablePermissions.class);
    private static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    private static ZKWatcher ZKW;
    private static final Abortable ABORTABLE;
    private static String TEST_NAMESPACE;
    private static String TEST_NAMESPACE2;
    private static TableName TEST_TABLE;
    private static TableName TEST_TABLE2;
    private static byte[] TEST_FAMILY;
    private static byte[] TEST_QUALIFIER;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        SecureTestUtil.enableSecurity(conf);
        UTIL.startMiniCluster();
        UTIL.waitTableEnabled(PermissionStorage.ACL_TABLE_NAME);
        UTIL.waitTableAvailable(TableName.valueOf((String)"hbase:acl"));
        ZKW = new ZKWatcher(UTIL.getConfiguration(), "TestTablePermissions", ABORTABLE);
        UTIL.createTable(TEST_TABLE, TEST_FAMILY);
        UTIL.createTable(TEST_TABLE2, TEST_FAMILY);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
             Table table = connection.getTable(PermissionStorage.ACL_TABLE_NAME);){
            PermissionStorage.removeTablePermissions((Configuration)conf, (TableName)TEST_TABLE, (Table)table);
            PermissionStorage.removeTablePermissions((Configuration)conf, (TableName)TEST_TABLE2, (Table)table);
            PermissionStorage.removeTablePermissions((Configuration)conf, (TableName)PermissionStorage.ACL_TABLE_NAME, (Table)table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserPermission(Configuration conf, UserPermission userPerm, Table t) throws IOException {
        try {
            PermissionStorage.addUserPermission((Configuration)conf, (UserPermission)userPerm, (Table)t);
        }
        finally {
            t.close();
        }
    }

    @Test
    public void testBasicWrite() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
            this.addUserPermission(conf, new UserPermission("george", Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}).build()), connection.getTable(PermissionStorage.ACL_TABLE_NAME));
            this.addUserPermission(conf, new UserPermission("hubert", Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ}).build()), connection.getTable(PermissionStorage.ACL_TABLE_NAME));
            this.addUserPermission(conf, new UserPermission("humphrey", Permission.newBuilder((TableName)TEST_TABLE).withFamily(TEST_FAMILY).withQualifier(TEST_QUALIFIER).withActions(new Permission.Action[]{Permission.Action.READ}).build()), connection.getTable(PermissionStorage.ACL_TABLE_NAME));
        }
        ListMultimap perms = PermissionStorage.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE);
        List userPerms = perms.get((Object)"george");
        Assert.assertNotNull((String)"Should have permissions for george", (Object)userPerms);
        Assert.assertEquals((String)"Should have 1 permission for george", (long)1L, (long)userPerms.size());
        Assert.assertEquals((Object)Permission.Scope.TABLE, (Object)((UserPermission)userPerms.get(0)).getAccessScope());
        TablePermission permission = (TablePermission)((UserPermission)userPerms.get(0)).getPermission();
        Assert.assertEquals((String)("Permission should be for " + TEST_TABLE), (Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertNull((String)"Column family should be empty", (Object)permission.getFamily());
        Assert.assertNotNull((Object)permission.getActions());
        Assert.assertEquals((long)2L, (long)permission.getActions().length);
        List<Permission.Action> actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains(Permission.Action.READ));
        Assert.assertTrue((boolean)actions.contains(Permission.Action.WRITE));
        userPerms = perms.get((Object)"hubert");
        Assert.assertNotNull((String)"Should have permissions for hubert", (Object)userPerms);
        Assert.assertEquals((String)"Should have 1 permission for hubert", (long)1L, (long)userPerms.size());
        Assert.assertEquals((Object)Permission.Scope.TABLE, (Object)((UserPermission)userPerms.get(0)).getAccessScope());
        permission = (TablePermission)((UserPermission)userPerms.get(0)).getPermission();
        Assert.assertEquals((String)("Permission should be for " + TEST_TABLE), (Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertNull((String)"Column family should be empty", (Object)permission.getFamily());
        Assert.assertNotNull((Object)permission.getActions());
        Assert.assertEquals((long)1L, (long)permission.getActions().length);
        actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains(Permission.Action.READ));
        Assert.assertFalse((boolean)actions.contains(Permission.Action.WRITE));
        userPerms = perms.get((Object)"humphrey");
        Assert.assertNotNull((String)"Should have permissions for humphrey", (Object)userPerms);
        Assert.assertEquals((String)"Should have 1 permission for humphrey", (long)1L, (long)userPerms.size());
        Assert.assertEquals((Object)Permission.Scope.TABLE, (Object)((UserPermission)userPerms.get(0)).getAccessScope());
        permission = (TablePermission)((UserPermission)userPerms.get(0)).getPermission();
        Assert.assertEquals((String)("Permission should be for " + TEST_TABLE), (Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertTrue((String)("Permission should be for family " + Bytes.toString((byte[])TEST_FAMILY)), (boolean)Bytes.equals((byte[])TEST_FAMILY, (byte[])permission.getFamily()));
        Assert.assertTrue((String)("Permission should be for qualifier " + Bytes.toString((byte[])TEST_QUALIFIER)), (boolean)Bytes.equals((byte[])TEST_QUALIFIER, (byte[])permission.getQualifier()));
        Assert.assertNotNull((Object)permission.getActions());
        Assert.assertEquals((long)1L, (long)permission.getActions().length);
        actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains(Permission.Action.READ));
        Assert.assertFalse((boolean)actions.contains(Permission.Action.WRITE));
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
             Table table = connection.getTable(PermissionStorage.ACL_TABLE_NAME);){
            PermissionStorage.addUserPermission((Configuration)conf, (UserPermission)new UserPermission("hubert", Permission.newBuilder((TableName)TEST_TABLE2).withActions(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}).build()), (Table)table);
        }
        Map allPerms = PermissionStorage.loadAll((Configuration)conf);
        Assert.assertEquals((String)"Full permission map should have entries for both test tables", (long)2L, (long)allPerms.size());
        userPerms = ((ListMultimap)allPerms.get(TEST_TABLE.getName())).get((Object)"hubert");
        Assert.assertNotNull((Object)userPerms);
        Assert.assertEquals((long)1L, (long)userPerms.size());
        Assert.assertEquals((Object)Permission.Scope.TABLE, (Object)((UserPermission)userPerms.get(0)).getAccessScope());
        permission = (TablePermission)((UserPermission)userPerms.get(0)).getPermission();
        Assert.assertEquals((Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertEquals((long)1L, (long)permission.getActions().length);
        Assert.assertEquals((Object)Permission.Action.READ, (Object)permission.getActions()[0]);
        userPerms = ((ListMultimap)allPerms.get(TEST_TABLE2.getName())).get((Object)"hubert");
        Assert.assertNotNull((Object)userPerms);
        Assert.assertEquals((long)1L, (long)userPerms.size());
        Assert.assertEquals((Object)Permission.Scope.TABLE, (Object)((UserPermission)userPerms.get(0)).getAccessScope());
        permission = (TablePermission)((UserPermission)userPerms.get(0)).getPermission();
        Assert.assertEquals((Object)TEST_TABLE2, (Object)permission.getTableName());
        Assert.assertEquals((long)2L, (long)permission.getActions().length);
        actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains(Permission.Action.READ));
        Assert.assertTrue((boolean)actions.contains(Permission.Action.WRITE));
    }

    @Test
    public void testPersistence() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
            this.addUserPermission(conf, new UserPermission("albert", Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ}).build()), connection.getTable(PermissionStorage.ACL_TABLE_NAME));
            this.addUserPermission(conf, new UserPermission("betty", Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}).build()), connection.getTable(PermissionStorage.ACL_TABLE_NAME));
            this.addUserPermission(conf, new UserPermission("clark", Permission.newBuilder((TableName)TEST_TABLE).withFamily(TEST_FAMILY).withActions(new Permission.Action[]{Permission.Action.READ}).build()), connection.getTable(PermissionStorage.ACL_TABLE_NAME));
            this.addUserPermission(conf, new UserPermission("dwight", Permission.newBuilder((TableName)TEST_TABLE).withFamily(TEST_FAMILY).withQualifier(TEST_QUALIFIER).withActions(new Permission.Action[]{Permission.Action.WRITE}).build()), connection.getTable(PermissionStorage.ACL_TABLE_NAME));
        }
        ListMultimap preperms = PermissionStorage.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE);
        Table table = UTIL.getConnection().getTable(TEST_TABLE);
        table.put(new Put(Bytes.toBytes((String)"row1")).addColumn(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((String)"v1")));
        table.put(new Put(Bytes.toBytes((String)"row2")).addColumn(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((String)"v2")));
        Admin admin = UTIL.getAdmin();
        try {
            admin.split(TEST_TABLE);
        }
        catch (IOException e) {
            LOG.debug("region is not splittable, because " + e);
        }
        Thread.sleep(10000L);
        ListMultimap postperms = PermissionStorage.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE);
        this.checkMultimapEqual((ListMultimap<String, UserPermission>)preperms, (ListMultimap<String, UserPermission>)postperms);
    }

    @Test
    public void testSerialization() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        ListMultimap<String, UserPermission> permissions = this.createPermissions();
        byte[] permsData = PermissionStorage.writePermissionsAsBytes(permissions, (Configuration)conf);
        ListMultimap copy = PermissionStorage.readUserPermission((byte[])permsData, (Configuration)conf);
        this.checkMultimapEqual(permissions, (ListMultimap<String, UserPermission>)copy);
    }

    private ListMultimap<String, UserPermission> createPermissions() {
        ArrayListMultimap permissions = ArrayListMultimap.create();
        permissions.put((Object)"george", (Object)new UserPermission("george", Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ}).build()));
        permissions.put((Object)"george", (Object)new UserPermission("george", Permission.newBuilder((TableName)TEST_TABLE).withFamily(TEST_FAMILY).withActions(new Permission.Action[]{Permission.Action.WRITE}).build()));
        permissions.put((Object)"george", (Object)new UserPermission("george", Permission.newBuilder((TableName)TEST_TABLE2).withActions(new Permission.Action[]{Permission.Action.READ}).build()));
        permissions.put((Object)"hubert", (Object)new UserPermission("hubert", Permission.newBuilder((TableName)TEST_TABLE2).withActions(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}).build()));
        permissions.put((Object)"bruce", (Object)new UserPermission("bruce", Permission.newBuilder((String)TEST_NAMESPACE).withActions(new Permission.Action[]{Permission.Action.READ}).build()));
        return permissions;
    }

    public void checkMultimapEqual(ListMultimap<String, UserPermission> first, ListMultimap<String, UserPermission> second) {
        Assert.assertEquals((long)first.size(), (long)second.size());
        for (String key : first.keySet()) {
            List firstPerms = first.get((Object)key);
            List secondPerms = second.get((Object)key);
            Assert.assertNotNull((Object)secondPerms);
            Assert.assertEquals((long)firstPerms.size(), (long)secondPerms.size());
            LOG.info("First permissions: " + firstPerms.toString());
            LOG.info("Second permissions: " + secondPerms.toString());
            for (UserPermission p : firstPerms) {
                Assert.assertTrue((String)("Permission " + p.toString() + " not found"), (boolean)secondPerms.contains(p));
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        Permission p1 = Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        Permission p2 = Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}).build();
        p2 = Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ}).build();
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = Permission.newBuilder((TableName)TEST_TABLE).withFamily(TEST_FAMILY).withActions(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}).build();
        p2 = Permission.newBuilder((TableName)TEST_TABLE).withFamily(TEST_FAMILY).withActions(new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ}).build();
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = Permission.newBuilder((TableName)TEST_TABLE).withFamily(TEST_FAMILY).withQualifier(TEST_QUALIFIER).withActions(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}).build();
        p2 = Permission.newBuilder((TableName)TEST_TABLE).withFamily(TEST_FAMILY).withQualifier(TEST_QUALIFIER).withActions(new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ}).build();
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        p2 = Permission.newBuilder((TableName)TEST_TABLE).withFamily(TEST_FAMILY).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p1 = Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        p2 = Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.WRITE}).build();
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p2 = Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}).build();
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p1 = Permission.newBuilder((TableName)TEST_TABLE).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        p2 = Permission.newBuilder((TableName)TEST_TABLE2).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p1 = Permission.newBuilder((String)TEST_NAMESPACE).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        p2 = Permission.newBuilder((String)TEST_NAMESPACE).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        Assert.assertEquals((Object)p1, (Object)p2);
        p1 = Permission.newBuilder((String)TEST_NAMESPACE).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        p2 = Permission.newBuilder((String)TEST_NAMESPACE2).withActions(new Permission.Action[]{Permission.Action.READ}).build();
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
    }

    @Test
    public void testGlobalPermission() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
            this.addUserPermission(conf, new UserPermission("user1", Permission.newBuilder().withActions(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}).build()), connection.getTable(PermissionStorage.ACL_TABLE_NAME));
            this.addUserPermission(conf, new UserPermission("user2", Permission.newBuilder().withActions(new Permission.Action[]{Permission.Action.CREATE}).build()), connection.getTable(PermissionStorage.ACL_TABLE_NAME));
            this.addUserPermission(conf, new UserPermission("user3", Permission.newBuilder().withActions(new Permission.Action[]{Permission.Action.ADMIN, Permission.Action.READ, Permission.Action.CREATE}).build()), connection.getTable(PermissionStorage.ACL_TABLE_NAME));
        }
        ListMultimap perms = PermissionStorage.getTablePermissions((Configuration)conf, null);
        List user1Perms = perms.get((Object)"user1");
        Assert.assertEquals((String)"Should have 1 permission for user1", (long)1L, (long)user1Perms.size());
        Assert.assertEquals((String)"user1 should have WRITE permission", (Object[])new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}, (Object[])((UserPermission)user1Perms.get(0)).getPermission().getActions());
        List user2Perms = perms.get((Object)"user2");
        Assert.assertEquals((String)"Should have 1 permission for user2", (long)1L, (long)user2Perms.size());
        Assert.assertEquals((String)"user2 should have CREATE permission", (Object[])new Permission.Action[]{Permission.Action.CREATE}, (Object[])((UserPermission)user2Perms.get(0)).getPermission().getActions());
        List user3Perms = perms.get((Object)"user3");
        Assert.assertEquals((String)"Should have 1 permission for user3", (long)1L, (long)user3Perms.size());
        Assert.assertEquals((String)"user3 should have ADMIN, READ, CREATE permission", (Object[])new Permission.Action[]{Permission.Action.READ, Permission.Action.CREATE, Permission.Action.ADMIN}, (Object[])((UserPermission)user3Perms.get(0)).getPermission().getActions());
    }

    @Test
    public void testAuthManager() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        AuthManager authManager = new AuthManager(conf);
        User currentUser = User.getCurrent();
        Assert.assertTrue((boolean)authManager.authorizeUserGlobal(currentUser, Permission.Action.ADMIN));
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
            for (int i = 1; i <= 50; ++i) {
                this.addUserPermission(conf, new UserPermission("testauth" + i, Permission.newBuilder().withActions(new Permission.Action[]{Permission.Action.ADMIN, Permission.Action.READ, Permission.Action.WRITE}).build()), connection.getTable(PermissionStorage.ACL_TABLE_NAME));
                Assert.assertTrue((String)("Failed current user auth check on iter " + i), (boolean)authManager.authorizeUserGlobal(currentUser, Permission.Action.ADMIN));
            }
        }
    }

    static {
        ABORTABLE = new Abortable(){
            private final AtomicBoolean abort = new AtomicBoolean(false);

            public void abort(String why, Throwable e) {
                LOG.info(why, e);
                this.abort.set(true);
            }

            public boolean isAborted() {
                return this.abort.get();
            }
        };
        TEST_NAMESPACE = "perms_test_ns";
        TEST_NAMESPACE2 = "perms_test_ns2";
        TEST_TABLE = TableName.valueOf((String)"perms_test");
        TEST_TABLE2 = TableName.valueOf((String)"perms_test2");
        TEST_FAMILY = Bytes.toBytes((String)"f1");
        TEST_QUALIFIER = Bytes.toBytes((String)"col1");
    }
}

