/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRestoreFlushSnapshotFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRestoreFlushSnapshotFromClient.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRestoreFlushSnapshotFromClient.class);
    protected static final HBaseTestingUtil UTIL = new HBaseTestingUtil();
    protected final byte[] FAMILY = Bytes.toBytes((String)"cf");
    protected String snapshotName0;
    protected String snapshotName1;
    protected String snapshotName2;
    protected int snapshot0Rows;
    protected int snapshot1Rows;
    protected TableName tableName;
    protected Admin admin;

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestRestoreFlushSnapshotFromClient.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(3);
    }

    protected static void setupConf(Configuration conf) {
        UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        UTIL.getConfiguration().setLong("hbase.snapshot.region.timeout", 600000L);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    protected void createTable() throws Exception {
        SnapshotTestingUtils.createTable(UTIL, this.tableName, new byte[][]{this.FAMILY});
    }

    @Before
    public void setup() throws Exception {
        this.admin = UTIL.getAdmin();
        long tid = EnvironmentEdgeManager.currentTime();
        this.tableName = TableName.valueOf((String)("testtb-" + tid));
        this.snapshotName0 = "snaptb0-" + tid;
        this.snapshotName1 = "snaptb1-" + tid;
        this.snapshotName2 = "snaptb2-" + tid;
        this.createTable();
        SnapshotTestingUtils.loadData(UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        Table table = UTIL.getConnection().getTable(this.tableName);
        this.snapshot0Rows = this.countRows(table, new byte[0][]);
        LOG.info("=== before snapshot with 500 rows");
        this.logFSTree();
        this.admin.snapshot(this.snapshotName0, this.tableName, SnapshotType.FLUSH);
        LOG.info("=== after snapshot with 500 rows");
        this.logFSTree();
        SnapshotTestingUtils.loadData(UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        this.snapshot1Rows = this.countRows(table, new byte[0][]);
        LOG.info("=== before snapshot with 1000 rows");
        this.logFSTree();
        this.admin.snapshot(this.snapshotName1, this.tableName, SnapshotType.FLUSH);
        LOG.info("=== after snapshot with 1000 rows");
        this.logFSTree();
        table.close();
    }

    @After
    public void tearDown() throws Exception {
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @Test
    public void testTakeFlushSnapshot() throws IOException {
    }

    @Test
    public void testRestoreSnapshot() throws IOException {
        this.verifyRowCount(UTIL, this.tableName, this.snapshot1Rows);
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.logFSTree();
        this.admin.enableTable(this.tableName);
        LOG.info("=== after restore with 500 row snapshot");
        this.logFSTree();
        this.verifyRowCount(UTIL, this.tableName, this.snapshot0Rows);
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName1);
        this.admin.enableTable(this.tableName);
        this.verifyRowCount(UTIL, this.tableName, this.snapshot1Rows);
    }

    @Test(expected=SnapshotDoesNotExistException.class)
    public void testCloneNonExistentSnapshot() throws IOException, InterruptedException {
        String snapshotName = "random-snapshot-" + EnvironmentEdgeManager.currentTime();
        TableName tableName = TableName.valueOf((String)("random-table-" + EnvironmentEdgeManager.currentTime()));
        this.admin.cloneSnapshot(snapshotName, tableName);
    }

    @Test
    public void testCloneSnapshot() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)("clonedtb-" + EnvironmentEdgeManager.currentTime()));
        this.testCloneSnapshot(clonedTableName, this.snapshotName0, this.snapshot0Rows);
        this.testCloneSnapshot(clonedTableName, this.snapshotName1, this.snapshot1Rows);
    }

    private void testCloneSnapshot(TableName tableName, String snapshotName, int snapshotRows) throws IOException, InterruptedException {
        this.admin.cloneSnapshot(snapshotName, tableName);
        this.verifyRowCount(UTIL, tableName, snapshotRows);
        UTIL.deleteTable(tableName);
    }

    @Test
    public void testRestoreSnapshotOfCloned() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)("clonedtb-" + EnvironmentEdgeManager.currentTime()));
        this.admin.cloneSnapshot(this.snapshotName0, clonedTableName);
        this.verifyRowCount(UTIL, clonedTableName, this.snapshot0Rows);
        this.admin.snapshot(this.snapshotName2, clonedTableName, SnapshotType.FLUSH);
        UTIL.deleteTable(clonedTableName);
        this.admin.cloneSnapshot(this.snapshotName2, clonedTableName);
        this.verifyRowCount(UTIL, clonedTableName, this.snapshot0Rows);
        UTIL.deleteTable(clonedTableName);
    }

    private void logFSTree() throws IOException {
        UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem().logFileSystemState(LOG);
    }

    protected void verifyRowCount(HBaseTestingUtil util, TableName tableName, long expectedRows) throws IOException {
        SnapshotTestingUtils.verifyRowCount(util, tableName, expectedRows);
    }

    protected int countRows(Table table, byte[] ... families) throws IOException {
        return HBaseTestingUtil.countRows(table, families);
    }
}

