/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServer
implements Server {
    private static final Logger LOG = LoggerFactory.getLogger(MockServer.class);
    static final ServerName NAME = ServerName.valueOf((String)"MockServer", (int)123, (long)123456789L);
    protected volatile boolean stopped = false;
    protected volatile boolean aborted = false;

    public void abort(String why, Throwable e) {
        LOG.error(HBaseMarkers.FATAL, "Abort {} why={}", new Object[]{this.getServerName(), why, e});
        this.stop(why);
        this.aborted = true;
    }

    public void stop(String why) {
        LOG.debug("Stop {} why={}", (Object)this.getServerName(), (Object)why);
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Configuration getConfiguration() {
        throw new UnsupportedOperationException();
    }

    public ZKWatcher getZooKeeper() {
        throw new UnsupportedOperationException();
    }

    public CoordinatedStateManager getCoordinatedStateManager() {
        throw new UnsupportedOperationException();
    }

    public Connection getConnection() {
        throw new UnsupportedOperationException();
    }

    public ServerName getServerName() {
        return NAME;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public ChoreService getChoreService() {
        throw new UnsupportedOperationException();
    }

    public FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    public boolean isStopping() {
        return false;
    }

    public Connection createConnection(Configuration conf) throws IOException {
        throw new UnsupportedOperationException();
    }

    public AsyncClusterConnection getAsyncClusterConnection() {
        throw new UnsupportedOperationException();
    }
}

