/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestFSTableDescriptors {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFSTableDescriptors.class);
    private static final HBaseCommonTestingUtil UTIL = new HBaseCommonTestingUtil();
    private static final Logger LOG = LoggerFactory.getLogger(TestFSTableDescriptors.class);
    @Rule
    public TestName name = new TestName();
    private Path testDir;

    @Before
    public void setUp() {
        this.testDir = UTIL.getDataTestDir(this.name.getMethodName());
    }

    @AfterClass
    public static void tearDownAfterClass() {
        UTIL.cleanupTestDir();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegexAgainstOldStyleTableInfo() {
        Path p = new Path(this.testDir, ".tableinfo");
        int i = FSTableDescriptors.getTableInfoSequenceIdAndFileLength((Path)p).sequenceId;
        Assert.assertEquals((long)0L, (long)i);
        p = new Path(this.testDir, "abc");
        FSTableDescriptors.getTableInfoSequenceIdAndFileLength((Path)p);
    }

    @Test
    public void testCreateAndUpdate() throws IOException {
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors fstd = new FSTableDescriptors(fs, this.testDir);
        Assert.assertTrue((boolean)fstd.createTableDescriptor(htd));
        Assert.assertFalse((boolean)fstd.createTableDescriptor(htd));
        Path tableInfoDir = new Path(CommonFSUtils.getTableDir((Path)this.testDir, (TableName)htd.getTableName()), ".tabledesc");
        FileStatus[] statuses = fs.listStatus(tableInfoDir);
        Assert.assertEquals((String)("statuses.length=" + statuses.length), (long)1L, (long)statuses.length);
        for (int i = 0; i < 10; ++i) {
            fstd.update(htd);
        }
        statuses = fs.listStatus(tableInfoDir);
        Assert.assertEquals((long)1L, (long)statuses.length);
    }

    @Test
    public void testSequenceIdAdvancesOnTableInfo() throws IOException {
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors fstd = new FSTableDescriptors(fs, this.testDir);
        Path previousPath = null;
        int previousSeqId = -1;
        for (int i = 0; i < 10; ++i) {
            Path path = fstd.updateTableDescriptor(htd);
            int seqId = FSTableDescriptors.getTableInfoSequenceIdAndFileLength((Path)path).sequenceId;
            if (previousPath != null) {
                Assert.assertTrue((!fs.exists(previousPath) ? 1 : 0) != 0);
                Assert.assertEquals((long)(previousSeqId + 1), (long)seqId);
            }
            previousPath = path;
            previousSeqId = seqId;
        }
    }

    @Test
    public void testFormatTableInfoSequenceId() {
        Path p0 = this.assertWriteAndReadSequenceId(0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append("0");
        }
        Assert.assertEquals((Object)(".tableinfo." + sb.toString() + ".0"), (Object)p0.getName());
        Path p2 = this.assertWriteAndReadSequenceId(2);
        Path p10000 = this.assertWriteAndReadSequenceId(10000);
        Path p = new Path(p0.getParent(), ".tableinfo");
        FileStatus fs = new FileStatus(0L, false, 0, 0L, 0L, p);
        FileStatus fs0 = new FileStatus(0L, false, 0, 0L, 0L, p0);
        FileStatus fs2 = new FileStatus(0L, false, 0, 0L, 0L, p2);
        FileStatus fs10000 = new FileStatus(0L, false, 0, 0L, 0L, p10000);
        Comparator comparator = FSTableDescriptors.TABLEINFO_FILESTATUS_COMPARATOR;
        Assert.assertTrue((comparator.compare(fs, fs0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(fs0, fs2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(fs2, fs10000) > 0 ? 1 : 0) != 0);
    }

    private Path assertWriteAndReadSequenceId(int i) {
        Path p = new Path(this.testDir, FSTableDescriptors.getTableInfoFileName((int)i, (byte[])HConstants.EMPTY_BYTE_ARRAY));
        int ii = FSTableDescriptors.getTableInfoSequenceIdAndFileLength((Path)p).sequenceId;
        Assert.assertEquals((long)i, (long)ii);
        return p;
    }

    @Test
    public void testRemoves() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors htds = new FSTableDescriptors(fs, this.testDir);
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        htds.update(htd);
        Assert.assertNotNull((Object)htds.remove(htd.getTableName()));
        Assert.assertNull((Object)htds.remove(htd.getTableName()));
    }

    @Test
    public void testReadingHTDFromFS() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        FSTableDescriptors fstd = new FSTableDescriptors(fs, this.testDir);
        fstd.createTableDescriptor(htd);
        TableDescriptor td2 = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)fs, (Path)this.testDir, (TableName)htd.getTableName());
        Assert.assertTrue((boolean)htd.equals(td2));
    }

    @Test
    public void testTableDescriptors() throws IOException, InterruptedException {
        int i;
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors htds = new FSTableDescriptors(fs, this.testDir){

            public TableDescriptor get(TableName tablename) {
                LOG.info(tablename + ", cachehits=" + this.cachehits);
                return super.get(tablename);
            }
        };
        int count = 10;
        for (i = 0; i < 10; ++i) {
            htds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(this.name.getMethodName() + i))).build());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf((String)(this.name.getMethodName() + i))) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf((String)(this.name.getMethodName() + i))) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(this.name.getMethodName() + i)));
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)("" + i)));
            htds.update(builder.build());
        }
        Thread.sleep(100L);
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf((String)(this.name.getMethodName() + i))) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf((String)(this.name.getMethodName() + i))) != null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)40L, (long)htds.invocations);
        Assert.assertTrue((String)("expected=20, actual=" + htds.cachehits), (htds.cachehits >= 20L ? 1 : 0) != 0);
    }

    @Test
    public void testTableDescriptorsNoCache() throws IOException, InterruptedException {
        int i;
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptorsTest htds = new FSTableDescriptorsTest(fs, this.testDir, false);
        int count = 10;
        for (i = 0; i < 10; ++i) {
            htds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(this.name.getMethodName() + i))).build());
        }
        for (i = 0; i < 20; ++i) {
            Assert.assertNotNull((String)"Expected HTD, got null instead", (Object)htds.get(TableName.valueOf((String)(this.name.getMethodName() + i % 2))));
        }
        for (i = 0; i < 10; ++i) {
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(this.name.getMethodName() + i)));
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)("" + i)));
            htds.update(builder.build());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertNotNull((String)"Expected HTD, got null instead", (Object)htds.get(TableName.valueOf((String)(this.name.getMethodName() + i))));
            Assert.assertTrue((String)("Column Family " + i + " missing"), (boolean)htds.get(TableName.valueOf((String)(this.name.getMethodName() + i))).hasColumnFamily(Bytes.toBytes((String)("" + i))));
        }
        Assert.assertEquals((long)40L, (long)htds.invocations);
        Assert.assertEquals((String)("expected=0, actual=" + htds.cachehits), (long)0L, (long)htds.cachehits);
    }

    @Test
    public void testGetAll() throws IOException, InterruptedException {
        String name = "testGetAll";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptorsTest htds = new FSTableDescriptorsTest(fs, this.testDir);
        int count = 4;
        for (int i = 0; i < 4; ++i) {
            htds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)("testGetAll" + i))).build());
        }
        htds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).build());
        Assert.assertEquals((String)("getAll() didn't return all TableDescriptors, expected: 5 got: " + htds.getAll().size()), (long)5L, (long)htds.getAll().size());
    }

    @Test
    public void testParallelGetAll() throws IOException, InterruptedException {
        String name = "testParallelGetAll";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptorsTest htds = new FSTableDescriptorsTest(fs, this.testDir, true, 20);
        int count = 100;
        for (int i = 0; i < 100; ++i) {
            htds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)("testParallelGetAll" + i))).build());
        }
        htds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).build());
        int getTableDescriptorSize = htds.getAll().size();
        Assert.assertEquals((String)("getAll() didn't return all TableDescriptors, expected: 101 got: " + getTableDescriptorSize), (long)101L, (long)getTableDescriptorSize);
        getTableDescriptorSize = htds.getAll().size();
        Assert.assertEquals((String)("getAll() didn't return all TableDescriptors with cache, expected: 101 got: " + getTableDescriptorSize), (long)101L, (long)getTableDescriptorSize);
    }

    @Test
    public void testGetAllOrdering() throws Exception {
        String[] tableNames;
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptorsTest tds = new FSTableDescriptorsTest(fs, this.testDir);
        for (String tableName : tableNames = new String[]{"foo", "bar", "foo:bar", "bar:foo"}) {
            tds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).build());
        }
        Map tables = tds.getAll();
        tables.remove(TableName.META_TABLE_NAME.getNameAsString());
        Assert.assertEquals((long)4L, (long)tables.size());
        String[] tableNamesOrdered = new String[]{"bar:foo", "default:bar", "default:foo", "foo:bar"};
        int i = 0;
        for (Map.Entry entry : tables.entrySet()) {
            Assert.assertEquals((Object)tableNamesOrdered[i], entry.getKey());
            Assert.assertEquals((Object)tableNamesOrdered[i], (Object)((TableDescriptor)entry.getValue()).getTableName().getNameWithNamespaceInclAsString());
            ++i;
        }
    }

    @Test
    public void testCacheConsistency() throws IOException, InterruptedException {
        int i;
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptorsTest chtds = new FSTableDescriptorsTest(fs, this.testDir);
        FSTableDescriptorsTest nonchtds = new FSTableDescriptorsTest(fs, this.testDir, false);
        int count = 10;
        for (i = 0; i < 10; ++i) {
            nonchtds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(this.name.getMethodName() + i))).build());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((chtds.get(TableName.valueOf((String)(this.name.getMethodName() + i))) != null ? 1 : 0) != 0);
        }
        Assert.assertTrue((nonchtds.getAll().size() == chtds.getAll().size() ? 1 : 0) != 0);
        TableName random = TableName.valueOf((String)"random");
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)random).build();
        nonchtds.createTableDescriptor(htd);
        Assert.assertEquals((long)nonchtds.getAll().size(), (long)(chtds.getAll().size() + 1));
        for (Map.Entry entry : chtds.getAll().entrySet()) {
            String t = (String)entry.getKey();
            TableDescriptor nchtd = (TableDescriptor)entry.getValue();
            Assert.assertTrue((String)("expected " + htd.toString() + " got: " + chtds.get(TableName.valueOf((String)t)).toString()), (boolean)nchtd.equals(chtds.get(TableName.valueOf((String)t))));
        }
        Assert.assertNotNull((Object)nonchtds.get(random));
        Assert.assertNull((Object)chtds.get(random));
    }

    @Test
    public void testNoSuchTable() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors htds = new FSTableDescriptors(fs, this.testDir);
        Assert.assertNull((String)"There shouldn't be any HTD for this table", (Object)htds.get(TableName.valueOf((String)"NoSuchTable")));
    }

    @Test
    public void testUpdates() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors htds = new FSTableDescriptors(fs, this.testDir);
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        htds.update(htd);
        htds.update(htd);
        htds.update(htd);
    }

    @Test
    public void testTableInfoFileStatusComparator() {
        FileStatus bare = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp", ".tableinfo"));
        FileStatus future = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp/tablinfo." + EnvironmentEdgeManager.currentTime()));
        FileStatus farFuture = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp/tablinfo." + EnvironmentEdgeManager.currentTime() + 1000));
        FileStatus[] alist = new FileStatus[]{bare, future, farFuture};
        FileStatus[] blist = new FileStatus[]{bare, farFuture, future};
        FileStatus[] clist = new FileStatus[]{farFuture, bare, future};
        Comparator c = FSTableDescriptors.TABLEINFO_FILESTATUS_COMPARATOR;
        Arrays.sort(alist, c);
        Arrays.sort(blist, c);
        Arrays.sort(clist, c);
        for (int i = 0; i < alist.length; ++i) {
            Assert.assertTrue((boolean)alist[i].equals((Object)blist[i]));
            Assert.assertTrue((boolean)blist[i].equals((Object)clist[i]));
            Assert.assertTrue((boolean)clist[i].equals((Object)(i == 0 ? farFuture : (i == 1 ? future : bare))));
        }
    }

    @Test
    public void testReadingInvalidDirectoryFromFS() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        try {
            new FSTableDescriptors(fs, CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration())).get(TableName.valueOf((String)".tmp"));
            Assert.fail((String)"Shouldn't be able to read a table descriptor for the archive directory.");
        }
        catch (Exception e) {
            LOG.debug("Correctly got error when reading a table descriptor from the archive directory: " + e.getMessage());
        }
    }

    @Test
    public void testCreateTableDescriptorUpdatesIfExistsAlready() throws IOException {
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors fstd = new FSTableDescriptors(fs, this.testDir);
        Assert.assertTrue((boolean)fstd.createTableDescriptor(htd));
        Assert.assertFalse((boolean)fstd.createTableDescriptor(htd));
        htd = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setValue(Bytes.toBytes((String)"mykey"), Bytes.toBytes((String)"myValue")).build();
        Assert.assertTrue((boolean)fstd.createTableDescriptor(htd));
        Path tableDir = CommonFSUtils.getTableDir((Path)this.testDir, (TableName)htd.getTableName());
        Assert.assertEquals((Object)htd, (Object)FSTableDescriptors.getTableDescriptorFromFs((FileSystem)fs, (Path)tableDir));
    }

    @Test
    public void testIgnoreBrokenTableDescriptorFiles() throws IOException {
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"cf")).build();
        TableDescriptor newHtd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"cf2")).build();
        Assert.assertNotEquals((Object)newHtd, (Object)htd);
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors fstd = new FSTableDescriptors(fs, this.testDir, false, false);
        fstd.update(htd);
        byte[] bytes = TableDescriptorBuilder.toByteArray((TableDescriptor)newHtd);
        Path tableDir = CommonFSUtils.getTableDir((Path)this.testDir, (TableName)htd.getTableName());
        Path tableInfoDir = new Path(tableDir, ".tabledesc");
        FileStatus[] statuses = fs.listStatus(tableInfoDir);
        Assert.assertEquals((long)1L, (long)statuses.length);
        int seqId = FSTableDescriptors.getTableInfoSequenceIdAndFileLength((Path)statuses[0].getPath()).sequenceId + 1;
        Path brokenFile = new Path(tableInfoDir, FSTableDescriptors.getTableInfoFileName((int)seqId, (byte[])bytes));
        try (FSDataOutputStream out = fs.create(brokenFile);){
            out.write(bytes, 0, bytes.length / 2);
        }
        Assert.assertTrue((boolean)fs.exists(brokenFile));
        TableDescriptor getTd = fstd.get(htd.getTableName());
        Assert.assertEquals((Object)htd, (Object)getTd);
        Assert.assertFalse((boolean)fs.exists(brokenFile));
    }

    private static class FSTableDescriptorsTest
    extends FSTableDescriptors {
        public FSTableDescriptorsTest(FileSystem fs, Path rootdir) {
            this(fs, rootdir, true);
        }

        public FSTableDescriptorsTest(FileSystem fs, Path rootdir, boolean usecache) {
            super(fs, rootdir, false, usecache);
        }

        public FSTableDescriptorsTest(FileSystem fs, Path rootdir, boolean usecache, int tableDescriptorParallelLoadThreads) {
            super(fs, rootdir, false, usecache, tableDescriptorParallelLoadThreads);
        }

        public TableDescriptor get(TableName tablename) {
            LOG.info((super.isUsecache() ? "Cached" : "Non-Cached") + " TableDescriptor.get() on " + tablename + ", cachehits=" + this.cachehits);
            return super.get(tablename);
        }
    }
}

