/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.compaction.MajorCompactorTTL;
import org.apache.hadoop.hbase.util.compaction.TestMajorCompactor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMajorCompactorTTL
extends TestMajorCompactor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMajorCompactorTTL.class);
    @Rule
    public TestName name = new TestName();

    @Override
    @Before
    public void setUp() throws Exception {
        this.utility = new HBaseTestingUtil();
        this.utility.getConfiguration().setInt("hbase.hfile.compaction.discharger.interval", 10);
        this.utility.startMiniCluster();
        this.admin = this.utility.getAdmin();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.utility.shutdownMiniCluster();
    }

    @Override
    @Test
    public void testCompactingATable() throws Exception {
        TableName tableName = this.createTable(this.name.getMethodName());
        Thread.sleep(10000L);
        int numberOfRegions = this.admin.getRegions(tableName).size();
        int numHFiles = this.utility.getNumHFiles(tableName, FAMILY);
        Assert.assertTrue((numberOfRegions < numHFiles ? 1 : 0) != 0);
        this.modifyTTL(tableName);
        MajorCompactorTTL compactor = new MajorCompactorTTL(this.utility.getConfiguration(), this.admin.getDescriptor(tableName), 1, 200L);
        compactor.initializeWorkQueues();
        compactor.compactAllRegions();
        compactor.shutdown();
        numberOfRegions = this.admin.getRegions(tableName).size();
        numHFiles = this.utility.getNumHFiles(tableName, FAMILY);
        Assert.assertEquals((long)numberOfRegions, (long)numHFiles);
    }

    protected void modifyTTL(TableName tableName) throws IOException, InterruptedException {
        this.admin.disableTable(tableName);
        this.utility.waitTableDisabled(tableName.getName());
        TableDescriptor descriptor = this.admin.getDescriptor(tableName);
        ColumnFamilyDescriptor colDesc = descriptor.getColumnFamily(FAMILY);
        ColumnFamilyDescriptorBuilder cFDB = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)colDesc);
        cFDB.setTimeToLive(5);
        this.admin.modifyColumnFamily(tableName, cFDB.build());
        this.admin.enableTable(tableName);
        this.utility.waitTableEnabled(tableName);
    }

    protected TableName createTable(String name) throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)name);
        this.utility.createMultiRegionTable(tableName, FAMILY, 5);
        this.utility.waitTableAvailable(tableName);
        Connection connection = this.utility.getConnection();
        Table table = connection.getTable(tableName);
        for (int i = 0; i < 5; ++i) {
            this.utility.loadRandomRows(table, FAMILY, 50, 100);
            this.utility.flush(tableName);
        }
        table.close();
        return tableName;
    }
}

