/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SingleProcessHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestWALSplitWithDeletedTableData {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALSplitWithDeletedTableData.class);
    private static final HBaseTestingUtil TEST_UTIL = new HBaseTestingUtil();

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testWALSplitWithDeletedTableData() throws Exception {
        byte[][] rks;
        byte[] CFNAME = Bytes.toBytes((String)"f1");
        byte[] QNAME = Bytes.toBytes((String)"q1");
        byte[] VALUE = Bytes.toBytes((String)"v1");
        TableName t1 = TableName.valueOf((String)"t1");
        TableName t2 = TableName.valueOf((String)"t2");
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d")};
        TableDescriptorBuilder htdBuilder1 = TableDescriptorBuilder.newBuilder((TableName)t1);
        htdBuilder1.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CFNAME).build());
        Table tab1 = TEST_UTIL.createTable(htdBuilder1.build(), (byte[][])splitRows);
        TableDescriptorBuilder htdBuilder2 = TableDescriptorBuilder.newBuilder((TableName)t2);
        htdBuilder2.setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CFNAME).build());
        Table tab2 = TEST_UTIL.createTable(htdBuilder2.build(), (byte[][])splitRows);
        ArrayList<Put> puts = new ArrayList<Put>(4);
        for (byte[] rk : rks = new byte[][]{Bytes.toBytes((String)"ac"), Bytes.toBytes((String)"ba"), Bytes.toBytes((String)"ca"), Bytes.toBytes((String)"dd")}) {
            puts.add(new Put(rk).addColumn(CFNAME, QNAME, VALUE));
        }
        tab1.put(puts);
        tab2.put(puts);
        SingleProcessHBaseCluster cluster = TEST_UTIL.getMiniHBaseCluster();
        TEST_UTIL.deleteTable(t1);
        Path tableDir = CommonFSUtils.getWALTableDir((Configuration)TEST_UTIL.getConfiguration(), (TableName)t1);
        Assert.assertFalse((boolean)TEST_UTIL.getDFSCluster().getFileSystem().exists(tableDir));
        ServerName rs1 = cluster.getRegionServer(1).getServerName();
        cluster.killRegionServer(rs1);
        cluster.waitForRegionServerToStop(rs1, 60000L);
        Assert.assertEquals((long)1L, (long)cluster.getNumLiveRegionServers());
        Thread.sleep(1000L);
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        Assert.assertFalse((boolean)TEST_UTIL.getDFSCluster().getFileSystem().exists(tableDir));
        for (byte[] rk : rks) {
            Result result = tab2.get(new Get(rk));
            Assert.assertFalse((boolean)result.isEmpty());
            Cell cell = result.getColumnLatestCell(CFNAME, QNAME);
            Assert.assertNotNull((Object)cell);
            Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)cell, (byte[])VALUE));
        }
    }
}

