/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.AvlUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestAvlUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAvlUtil.class);
    private static final TestAvlKeyComparator KEY_COMPARATOR = new TestAvlKeyComparator();

    @Test
    public void testAvlTreeCrud() {
        int key;
        int i;
        int MAX_KEY = 99999999;
        int NELEM = 10000;
        TreeMap treeMap = new TreeMap();
        TestAvlNode root = null;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (i = 0; i < 10000; ++i) {
            key = ((Random)rand).nextInt(99999999);
            if (AvlUtil.AvlTree.get(root, (Object)key, (AvlUtil.AvlKeyComparator)KEY_COMPARATOR) != null) {
                --i;
                continue;
            }
            root = (TestAvlNode)AvlUtil.AvlTree.insert(root, (AvlUtil.AvlNode)new TestAvlNode(key));
            treeMap.put(key, null);
            for (Integer keyX : treeMap.keySet()) {
                TestAvlNode node = (TestAvlNode)AvlUtil.AvlTree.get((AvlUtil.AvlNode)root, (Object)keyX, (AvlUtil.AvlKeyComparator)KEY_COMPARATOR);
                Assert.assertNotNull((Object)((Object)node));
                Assert.assertEquals((long)keyX.intValue(), (long)node.getKey());
            }
        }
        for (i = 0; i < 10000; ++i) {
            key = ((Random)rand).nextInt(99999999);
            TestAvlNode node = (TestAvlNode)AvlUtil.AvlTree.get(root, (Object)key, (AvlUtil.AvlKeyComparator)KEY_COMPARATOR);
            if (!treeMap.containsKey(key)) {
                Assert.assertNull((Object)((Object)node));
                continue;
            }
            treeMap.remove(key);
            Assert.assertEquals((long)key, (long)node.getKey());
            root = (TestAvlNode)AvlUtil.AvlTree.remove((AvlUtil.AvlNode)root, (Object)key, (AvlUtil.AvlKeyComparator)KEY_COMPARATOR);
            for (Integer keyX : treeMap.keySet()) {
                node = (TestAvlNode)AvlUtil.AvlTree.get((AvlUtil.AvlNode)root, (Object)keyX, (AvlUtil.AvlKeyComparator)KEY_COMPARATOR);
                Assert.assertNotNull((Object)((Object)node));
                Assert.assertEquals((long)keyX.intValue(), (long)node.getKey());
            }
        }
    }

    @Test
    public void testAvlTreeVisitor() {
        boolean MIN_KEY = false;
        int MAX_KEY = 50;
        TestAvlNode root = null;
        for (int i = 50; i >= 0; --i) {
            root = (TestAvlNode)AvlUtil.AvlTree.insert(root, (AvlUtil.AvlNode)new TestAvlNode(i));
        }
        AvlUtil.AvlTree.visit(root, (AvlUtil.AvlNodeVisitor)new AvlUtil.AvlNodeVisitor<TestAvlNode>(){
            private int prevKey = -1;

            public boolean visitNode(TestAvlNode node) {
                Assert.assertEquals((long)this.prevKey, (long)(node.getKey() - 1));
                Assert.assertTrue((node.getKey() >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((node.getKey() <= 50 ? 1 : 0) != 0);
                this.prevKey = node.getKey();
                return node.getKey() <= 50;
            }
        });
    }

    @Test
    public void testAvlTreeIterSeekFirst() {
        boolean MIN_KEY = true;
        int MAX_KEY = 50;
        TestAvlNode root = null;
        for (int i = 1; i < 50; ++i) {
            root = (TestAvlNode)AvlUtil.AvlTree.insert(root, (AvlUtil.AvlNode)new TestAvlNode(i));
        }
        AvlUtil.AvlTreeIterator iter = new AvlUtil.AvlTreeIterator(root);
        Assert.assertTrue((boolean)iter.hasNext());
        long prevKey = 0L;
        while (iter.hasNext()) {
            TestAvlNode node = (TestAvlNode)iter.next();
            Assert.assertEquals((long)(prevKey + 1L), (long)node.getKey());
            prevKey = node.getKey();
        }
        Assert.assertEquals((long)49L, (long)prevKey);
    }

    @Test
    public void testAvlTreeIterSeekTo() {
        int i;
        boolean MIN_KEY = true;
        int MAX_KEY = 50;
        TestAvlNode root = null;
        for (i = 1; i < 50; i += 2) {
            root = (TestAvlNode)AvlUtil.AvlTree.insert(root, (AvlUtil.AvlNode)new TestAvlNode(i));
        }
        for (i = 0; i < 51; ++i) {
            AvlUtil.AvlTreeIterator iter = new AvlUtil.AvlTreeIterator((AvlUtil.AvlNode)root, (Object)i, (AvlUtil.AvlKeyComparator)KEY_COMPARATOR);
            if (i >= 50) {
                Assert.assertFalse((boolean)iter.hasNext());
                break;
            }
            Assert.assertTrue((boolean)iter.hasNext());
            TestAvlNode node = (TestAvlNode)iter.next();
            Assert.assertEquals((long)(i % 2 == 0 ? (long)(i + 1) : (long)i), (long)node.getKey());
            long prevKey = node.getKey();
            while (iter.hasNext()) {
                node = (TestAvlNode)iter.next();
                Assert.assertTrue(((long)node.getKey() > prevKey ? 1 : 0) != 0);
                prevKey = node.getKey();
            }
        }
    }

    @Test
    public void testAvlIterableListCrud() {
        int i;
        int i2;
        int NITEMS = 10;
        TestLinkedAvlNode prependHead = null;
        TestLinkedAvlNode appendHead = null;
        for (int i3 = 0; i3 <= 10; ++i3) {
            TestLinkedAvlNode pNode = new TestLinkedAvlNode(i3);
            Assert.assertFalse((boolean)AvlUtil.AvlIterableList.isLinked((AvlUtil.AvlLinkedNode)pNode));
            prependHead = (TestLinkedAvlNode)AvlUtil.AvlIterableList.prepend(prependHead, (AvlUtil.AvlLinkedNode)pNode);
            Assert.assertTrue((boolean)AvlUtil.AvlIterableList.isLinked((AvlUtil.AvlLinkedNode)pNode));
            TestLinkedAvlNode aNode = new TestLinkedAvlNode(i3);
            Assert.assertFalse((boolean)AvlUtil.AvlIterableList.isLinked((AvlUtil.AvlLinkedNode)aNode));
            appendHead = (TestLinkedAvlNode)AvlUtil.AvlIterableList.append((AvlUtil.AvlLinkedNode)appendHead, (AvlUtil.AvlLinkedNode)aNode);
            Assert.assertTrue((boolean)AvlUtil.AvlIterableList.isLinked((AvlUtil.AvlLinkedNode)aNode));
        }
        TestLinkedAvlNode pNode = prependHead;
        TestLinkedAvlNode aNode = appendHead;
        for (i2 = 0; i2 <= 10; ++i2) {
            Assert.assertEquals((long)(10 - i2), (long)pNode.getKey());
            pNode = (TestLinkedAvlNode)AvlUtil.AvlIterableList.readNext((AvlUtil.AvlLinkedNode)pNode);
            Assert.assertEquals((long)i2, (long)aNode.getKey());
            aNode = (TestLinkedAvlNode)AvlUtil.AvlIterableList.readNext((AvlUtil.AvlLinkedNode)aNode);
        }
        pNode = (TestLinkedAvlNode)AvlUtil.AvlIterableList.readPrev(prependHead);
        aNode = (TestLinkedAvlNode)AvlUtil.AvlIterableList.readPrev(appendHead);
        for (i2 = 0; i2 <= 10; ++i2) {
            Assert.assertEquals((long)i2, (long)pNode.getKey());
            pNode = (TestLinkedAvlNode)AvlUtil.AvlIterableList.readPrev((AvlUtil.AvlLinkedNode)pNode);
            Assert.assertEquals((long)(10 - i2), (long)aNode.getKey());
            aNode = (TestLinkedAvlNode)AvlUtil.AvlIterableList.readPrev((AvlUtil.AvlLinkedNode)aNode);
        }
        TestLinkedAvlNode node = (TestLinkedAvlNode)AvlUtil.AvlIterableList.appendList((AvlUtil.AvlLinkedNode)prependHead, (AvlUtil.AvlLinkedNode)appendHead);
        for (i = 10; i >= 0; --i) {
            Assert.assertEquals((long)i, (long)node.getKey());
            node = (TestLinkedAvlNode)AvlUtil.AvlIterableList.readNext((AvlUtil.AvlLinkedNode)node);
        }
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((long)i, (long)node.getKey());
            node = (TestLinkedAvlNode)AvlUtil.AvlIterableList.readNext((AvlUtil.AvlLinkedNode)node);
        }
    }

    private static class TestAvlKeyComparator
    implements AvlUtil.AvlKeyComparator<TestAvlNode> {
        private TestAvlKeyComparator() {
        }

        public int compareKey(TestAvlNode node, Object key) {
            return node.getKey() - (Integer)key;
        }
    }

    private static class TestLinkedAvlNode
    extends AvlUtil.AvlLinkedNode<TestLinkedAvlNode> {
        private final int key;

        public TestLinkedAvlNode(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public int compareTo(TestLinkedAvlNode other) {
            return this.key - other.key;
        }

        public String toString() {
            return String.format("TestLinkedAvlNode(%d)", this.key);
        }
    }

    private static class TestAvlNode
    extends AvlUtil.AvlNode<TestAvlNode> {
        private final int key;

        public TestAvlNode(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public int compareTo(TestAvlNode other) {
            return this.key - other.key;
        }

        public String toString() {
            return String.format("TestAvlNode(%d)", this.key);
        }
    }
}

