/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.AbstractHBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.SaslUnwrapHandler;
import org.apache.hadoop.hbase.security.SaslWrapHandler;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NettyHBaseSaslRpcClient
extends AbstractHBaseSaslRpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHBaseSaslRpcClient.class);

    public NettyHBaseSaslRpcClient(Configuration conf, SaslClientAuthenticationProvider provider, Token<? extends TokenIdentifier> token, InetAddress serverAddr, SecurityInfo securityInfo, boolean fallbackAllowed, String rpcProtection) throws IOException {
        super(conf, provider, token, serverAddr, securityInfo, fallbackAllowed, rpcProtection);
    }

    public void setupSaslHandler(ChannelPipeline p, String addAfter) {
        String qop = (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
        LOG.trace("SASL client context established. Negotiated QoP {}", (Object)qop);
        if (qop == null || "auth".equalsIgnoreCase(qop)) {
            return;
        }
        p.addAfter(addAfter, null, (ChannelHandler)new SaslUnwrapHandler(this.saslClient::unwrap)).addAfter(addAfter, null, (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4)).addAfter(addAfter, null, (ChannelHandler)new SaslWrapHandler(this.saslClient::wrap));
    }

    public String getSaslQOP() {
        return (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
    }
}

