/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorageType;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class CopyReplicationPeers
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(CopyReplicationPeers.class);
    public static final String NAME = "copyreppeers";

    public CopyReplicationPeers(Configuration conf) {
        super(conf);
    }

    private ReplicationPeerStorage create(String type, FileSystem fs, ZKWatcher zk) {
        Configuration conf = new Configuration(this.getConf());
        conf.set("hbase.replication.peer.storage.impl", type);
        return ReplicationStorageFactory.getReplicationPeerStorage(fs, zk, conf);
    }

    private ZKWatcher createZKWatcher() throws IOException {
        return new ZKWatcher(this.getConf(), ((Object)((Object)this)).getClass().getSimpleName(), new Abortable(){
            private volatile boolean aborted;

            public boolean isAborted() {
                return this.aborted;
            }

            public void abort(String why, Throwable e) {
                this.aborted = true;
                LOG.error(why, e);
                System.exit(1);
            }
        });
    }

    private void migrate(ReplicationPeerStorage src, ReplicationPeerStorage dst) throws ReplicationException {
        LOG.info("Start migrating from {} to {}", (Object)src.getClass().getSimpleName(), (Object)dst.getClass().getSimpleName());
        for (String peerId : src.listPeerIds()) {
            LOG.info("Going to migrate {}", (Object)peerId);
            ReplicationPeerConfig peerConfig = src.getPeerConfig(peerId);
            boolean enabled = src.isPeerEnabled(peerId);
            SyncReplicationState syncState = src.getPeerSyncReplicationState(peerId);
            SyncReplicationState newSyncState = src.getPeerNewSyncReplicationState(peerId);
            if (newSyncState != SyncReplicationState.NONE) {
                throw new IllegalStateException("Can not migrate peer " + peerId + " as it is in an intermediate state, syncReplicationState is " + syncState + " while newSyncReplicationState is " + newSyncState);
            }
            dst.addPeer(peerId, peerConfig, enabled, syncState);
            LOG.info("Migrated peer {}, peerConfig = '{}', enabled = {}, syncReplicationState = {}", new Object[]{peerId, peerConfig, enabled, syncState});
        }
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: bin/hbase copyreppeers <SRC_REPLICATION_PEER_STORAGE> <DST_REPLICATION_PEER_STORAGE>");
            System.err.println("The possible values for replication storage type:");
            for (ReplicationPeerStorageType type : ReplicationPeerStorageType.values()) {
                System.err.println("  " + type.name().toLowerCase());
            }
            return -1;
        }
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        try (ZKWatcher zk = this.createZKWatcher();){
            ReplicationPeerStorage src = this.create(args[0], fs, zk);
            ReplicationPeerStorage dst = this.create(args[1], fs, zk);
            this.migrate(src, dst);
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new CopyReplicationPeers(conf), (String[])args);
        System.exit(ret);
    }
}

